/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.apihandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.IApiHandleProcessor;
import kd.scm.common.helper.apiconnector.api.util.Parser;

public class PriceHandleProcessor
implements IApiHandleProcessor {
    private static Log logger = LogFactory.getLog(PriceHandleProcessor.class);

    public Map<String, Object> beforeInvoke(Map<String, Object> param, String ecType) {
        Map handleParam = super.beforeInvoke(param, ecType);
        if (null != handleParam && null != handleParam.get("cityId")) {
            String jdCity = AddressUtil.getNumber((Long)Parser.toLong(handleParam.get("cityId")), (String)ecType);
            logger.info("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u82cd\u7a79cityID[" + handleParam.get("cityId") + "]\u5bf9\u5e94\u7684\u7535\u5546\u5730\u5740\uff1a" + jdCity);
            if (StringUtils.isNotBlank((CharSequence)jdCity)) {
                handleParam.put("cityId", jdCity);
            }
        }
        return handleParam;
    }

    public Map<String, PriceInfo> afterInvoke(Object result, String ecType) {
        HashMap<String, PriceInfo> priceMap = new HashMap<String, PriceInfo>();
        try {
            Object res = super.afterInvoke(result, ecType);
            ArrayList priceList = (ArrayList)res;
            for (Map price : priceList) {
                PriceInfo priceInfo = new PriceInfo();
                String skuId = Parser.toString(price.get("skuId"));
                priceInfo.setSkuId(skuId);
                priceInfo.setTaxPrice(Parser.toBigDecimal(price.get("taxPrice")));
                priceInfo.setShowprice(Parser.toBigDecimal(price.get("taxPrice")));
                priceInfo.setPrice(Parser.toBigDecimal(price.get("price")));
                priceInfo.setTax(Parser.toBigDecimal(price.get("tax")));
                priceInfo.setTaxRate(Parser.toBigDecimal(price.get("taxRate")));
                priceInfo.setEcPrice(Parser.toBigDecimal(price.get("ecPrice")));
                priceInfo.setDiscountRate(Parser.toBigDecimal(price.get("discountRate")));
                priceMap.put(skuId, priceInfo);
            }
        }
        catch (KDBizException ex) {
            throw new KDBizException(ex.getErrorCode(), new Object[]{MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u4ef7\u683c\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"PriceHandleProcessor_0", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)ecType).getName(), ex.getMessage())});
        }
        return priceMap;
    }
}

