/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.apihandle;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.IApiHandleProcessor;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.MalOrderUtil;

public class ProdHandleProcessor
implements IApiHandleProcessor {
    public Map<String, Object> beforeInvoke(Map<String, Object> param, String ecType) {
        return super.beforeInvoke(param, ecType);
    }

    public Map<String, GoodsInfo> afterInvoke(Object result, String ecType) {
        HashMap<String, GoodsInfo> prodMap = new HashMap<String, GoodsInfo>();
        try {
            Map prod = (Map)super.afterInvoke(result, ecType);
            GoodsInfo goodsInfo = new GoodsInfo();
            String skuId = Parser.toString(prod.get("skuId"));
            goodsInfo.setProductId("0");
            DynamicObject authDyo = MalOrderUtil.getAuthDyo((String)ecType);
            goodsInfo.setProductUnitID(authDyo.getString("mesureunits.id"));
            goodsInfo.setProductCurrID(authDyo.getString("currency.id"));
            goodsInfo.setSupplier(authDyo.getString("malsupplier.name"));
            goodsInfo.setSupplierId(Long.valueOf(authDyo.getLong("malsupplier.id")));
            goodsInfo.setProductSource(ecType);
            goodsInfo.setProductNumber(skuId);
            goodsInfo.setRemark(skuId);
            goodsInfo.setProductName(Parser.toString(prod.get("name")));
            goodsInfo.setProductImgPath(Parser.toString(prod.get("mainpic")));
            goodsInfo.setProductBrand(Parser.toString(prod.get("brand")));
            goodsInfo.setProductModel(Parser.toString(prod.get("model")));
            goodsInfo.setMinOrderQty(Parser.toBigDecimal(prod.get("minOrderQty")));
            goodsInfo.setPrice(BigDecimal.ZERO);
            goodsInfo.setTaxPrice(BigDecimal.ZERO);
            goodsInfo.setShopPrice(BigDecimal.ZERO);
            goodsInfo.setTax(BigDecimal.ZERO);
            goodsInfo.setTaxRate(BigDecimal.ZERO);
            goodsInfo.setProductDetail(Parser.toString(prod.get("introduction")));
            goodsInfo.setSpecification(Parser.toString(prod.get("param")));
            goodsInfo.setPackinglist(Parser.toString(prod.get("packList")));
            goodsInfo.setIsJDLogistics(Parser.toString(prod.get("isSelf")));
            goodsInfo.setUpc(Parser.toString(prod.get("upc")));
            goodsInfo.setCentralpurtype("1");
            goodsInfo.setCategoryNumber(Parser.toString(prod.get("category")));
            if (EcPlatformEnum.ECPLATFORM_XY.getVal().equals(ecType)) {
                goodsInfo.setNoReasonToReturnText(String.valueOf(prod.get("isReturn")));
            }
            this.handleSpecial(goodsInfo, prod);
            QFilter qFilter = new QFilter("number", "=", (Object)goodsInfo.getCategoryNumber()).and("standard", "=", (Object)authDyo.getLong("standard.id"));
            DynamicObject categoryDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"mdr_goodsclass", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
            if (categoryDyn != null) {
                goodsInfo.setCategoryId(categoryDyn.getString("id"));
                goodsInfo.setCategoryNumber(categoryDyn.getString("number"));
                goodsInfo.setCategoryName(categoryDyn.getString("name"));
            }
            QFilter unitQf = new QFilter("number", "=", (Object)skuId);
            unitQf.and(new QFilter("source", "=", (Object)ecType));
            DynamicObject pbdMallGoods = QueryServiceHelper.queryOne((String)"pbd_mallgoods", (String)"unitid", (QFilter[])unitQf.toArray());
            if (null != pbdMallGoods && 0L != pbdMallGoods.getLong("unitid")) {
                goodsInfo.setProductUnitID(pbdMallGoods.getString("unitid"));
            }
            prodMap.put(skuId, goodsInfo);
        }
        catch (KDBizException ex) {
            throw new KDBizException(ex.getErrorCode(), new Object[]{MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"ProdHandleProcessor_1", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)ecType).getName(), ex.getMessage())});
        }
        return prodMap;
    }

    protected void handleSpecial(GoodsInfo goodsInfo, Map<String, Object> prod) {
    }
}

