/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.apihandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.ecapi.entity.StockInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.IApiHandleProcessor;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.helper.apiconnector.constant.ApiConstant;

public class StockHandleProcessor
implements IApiHandleProcessor {
    public Map<String, Object> beforeInvoke(Map<String, Object> param, String ecType) {
        Map handleParam = super.beforeInvoke(param, ecType);
        Object townId = handleParam.get("townId");
        if (townId != null) {
            String[] jdAddress = AddressUtil.getNumberArr((Long)Parser.toLong(townId), (String)ecType);
            if (StringUtils.isNotBlank((Object)jdAddress) && jdAddress.length >= 3) {
                handleParam.put("provinceId", jdAddress[ApiConstant.PROVINCE_INDEX]);
                handleParam.put("cityId", jdAddress[ApiConstant.CITY_INDEX]);
                handleParam.put("countyId", jdAddress[ApiConstant.COUNTY_INDEX]);
                if (jdAddress.length == 4) {
                    handleParam.put("townId", jdAddress[ApiConstant.TOWN_INDEX]);
                } else {
                    handleParam.put("townId", "0");
                }
            }
            return handleParam;
        }
        Object countyId = handleParam.get("countyId");
        if (null != countyId) {
            String[] jdAddress = AddressUtil.getNumberArr((Long)Parser.toLong(countyId), (String)ecType);
            if (StringUtils.isNotBlank((Object)jdAddress) && jdAddress.length == 3) {
                handleParam.put("provinceId", jdAddress[0]);
                handleParam.put("cityId", jdAddress[1]);
                handleParam.put("countyId", jdAddress[2]);
                handleParam.put("townId", "0");
            }
            return handleParam;
        }
        return handleParam;
    }

    public Map<String, StockInfo> afterInvoke(Object result, String ecType) {
        HashMap<String, StockInfo> stockMap = new HashMap<String, StockInfo>();
        try {
            ArrayList stockList = (ArrayList)super.afterInvoke(result, ecType);
            for (Map stock : stockList) {
                StockInfo stockInfo = new StockInfo();
                String skuId = Parser.toString(stock.get("skuId"));
                stockInfo.setSkuId(skuId);
                stockInfo.setStockStateId(Parser.toString(stock.get("stockStateId")));
                stockInfo.setStockStateDesc(Parser.toString(stock.get("stockStateDesc")));
                String areaId = Parser.toString(stock.get("areaId"));
                if (!StringUtils.isEmpty((CharSequence)areaId)) {
                    if (areaId.startsWith("_")) {
                        areaId = "0" + areaId;
                    }
                    if (areaId.endsWith("_")) {
                        areaId = areaId + "0";
                    }
                    stockInfo.setAreaId(areaId);
                }
                stockMap.put(skuId, stockInfo);
            }
        }
        catch (KDBizException ex) {
            throw new KDBizException(ex.getErrorCode(), new Object[]{MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u83b7\u53d6\u5546\u54c1\u5e93\u5b58\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"StockHandleProcessor_0", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)ecType).getName(), ex.getMessage())});
        }
        return stockMap;
    }
}

