/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.parent;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class TreeListBuildTreePlugin
extends StandardTreeListPlugin {
    private static Log log = LogFactory.getLog(TreeListBuildTreePlugin.class);
    protected static final String SOURCE_JD = "2";
    protected static final String SOURCE_SHARING = "1";
    protected static final String KEY_TREEVIEW = "treeview";
    private static final String MDRGOODSCLASS = "mdr_goodsclass";

    public TreeNode getCloudData(String standardId) {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        TreeNode RootNode = this.getTreeModel().createRootNode();
        RootNode.setText(ResManager.loadKDString((String)"\u81ea\u5efa\u5546\u57ce", (String)"TreeListBuildTreePlugin_0", (String)"scm-common", (Object[])new Object[0]));
        String rootid = RootNode.getId();
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.valueOf(standardId));
        QFilter[] filters = new QFilter[]{qFilter};
        ORM orm = ORM.create();
        cloudNode.add(RootNode);
        try (DataSet ds = orm.queryDataSet(MDRGOODSCLASS, MDRGOODSCLASS, this.assembleSelectFilds(), filters, null);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                Long parentid = row.getLong("parent.id");
                log.info("parentid=" + row.getString("parent.id"));
                node.setText(row.getString("name"));
                if (RootNode.getId().equals(rootid) && 0L == parentid && row.getInteger("level") == 1) {
                    node.setParentid(rootid);
                } else {
                    node.setParentid(String.valueOf(parentid));
                }
                node.setLongNumber(row.getString("longnumber"));
                node.setId(nodeID);
                cloudNode.add(node);
            }
        }
        Map<String, TreeNode> nodes = this.buildTree(cloudNode);
        if (null != nodes.get(RootNode.getId())) {
            RootNode = nodes.get(RootNode.getId());
            RootNode.setParentid("");
        }
        return nodes.get(RootNode.getId());
    }

    private Map<String, TreeNode> buildTree(List<TreeNode> Nodes) {
        LinkedHashMap<String, TreeNode> allNodes = new LinkedHashMap<String, TreeNode>(Nodes.size());
        ArrayList<String> removeIds = new ArrayList<String>();
        for (TreeNode node : Nodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            if (node.getChildren() != null) continue;
            removeIds.add(node.getId());
        }
        for (int i = 0; i < removeIds.size(); ++i) {
            allNodes.remove(removeIds.get(i));
        }
        return allNodes;
    }

    private String assembleSelectFilds() {
        String selectFields = "id,number,name,parent.id,parent.number,longnumber,parent.name,level";
        return selectFields;
    }

    protected List<TreeNode> getAllNodes(String standardId) {
        ArrayList<TreeNode> AllNode = new ArrayList<TreeNode>();
        TreeNode RootNode = this.getTreeModel().createRootNode();
        RootNode.setText(ResManager.loadKDString((String)"\u81ea\u5efa\u5546\u57ce", (String)"TreeListBuildTreePlugin_0", (String)"scm-common", (Object[])new Object[0]));
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.valueOf(standardId));
        if (standardId != null) {
            qFilter = new QFilter("standard", "=", (Object)Long.valueOf(standardId));
        }
        QFilter[] filters = new QFilter[]{qFilter};
        AllNode.add(RootNode);
        ORM orm = ORM.create();
        String orderby = "number";
        try (DataSet ds = orm.queryDataSet(MDRGOODSCLASS, MDRGOODSCLASS, this.assembleSelectFilds(), filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                node.setText(row.getString("name"));
                String parentid = row.getString("parent.id");
                if ("0".equals(parentid)) {
                    node.setParentid(RootNode.getId());
                } else {
                    node.setParentid(parentid);
                }
                node.setLongNumber(row.getString("longnumber"));
                node.setId(nodeID);
                AllNode.add(node);
            }
        }
        return AllNode;
    }
}

