/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class PmmOrgScopeSettingEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(PmmOrgScopeSettingEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        this.initEntryData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String isGoodView = this.getPageCache().get("isGoodView");
        String isgoodvisible = this.getPageCache().get("isgoodvisible");
        Object status = customParams.get("status");
        if (status.equals("0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isgoodvisible", "entryap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirm"});
        } else if (Boolean.parseBoolean(String.valueOf(isGoodView))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isgoodvisible", "entryap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
        } else {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (Boolean.parseBoolean(String.valueOf(isgoodvisible))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"isgoodvisible"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
                for (int i = 0; i < entryentity.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"orgname"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"status"});
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isgoodvisible"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
                for (int i = 0; i < entryentity.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"orgname"});
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject row = (DynamicObject)entryentity.get(i);
            if (null != row.getDynamicObject("orgname")) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"orgname"});
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"status"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgName = (BasedataEdit)this.getControl("orgname");
        orgName.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void initEntryData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object protocolid = customParams.get("protocolid");
        Object protocolentryid = customParams.get("protocolentryid");
        List goodsid = (List)customParams.get("goodsid");
        HashMap<Long, String> orgMap = new HashMap<Long, String>(1024);
        boolean isGoodView = true;
        boolean isExistPool = false;
        if (0 != goodsid.size() || null != customParams.get("prodPoolIds")) {
            HashMap<Long, String> orgPoolMap = new HashMap<Long, String>(1024);
            isExistPool = this.getIsExistPool(orgPoolMap);
            orgMap.putAll(orgPoolMap);
        }
        boolean differentarea = Boolean.parseBoolean(String.valueOf(customParams.get("differentarea")));
        boolean isgoodvisible = true;
        if (null != protocolid && Long.parseLong(String.valueOf(protocolid)) != 0L) {
            DynamicObjectCollection ent_protocols;
            QFilter qFilter;
            String enable = "0";
            if (0 == goodsid.size() || orgMap.size() == 0 && !isExistPool) {
                enable = "1";
            }
            if (differentarea) {
                qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(protocolid)));
                ent_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)"entryentity1.id,entryentity1.purplanid,entryentity1.purorg", (QFilter[])qFilter.toArray());
                long protocolEntryId = Long.parseLong(String.valueOf(protocolentryid));
                long purPlanId = 0L;
                for (DynamicObject pool : ent_protocols) {
                    if (protocolEntryId != pool.getLong("entryentity1.id")) continue;
                    purPlanId = pool.getLong("entryentity1.purplanid");
                }
                for (DynamicObject pool : ent_protocols) {
                    long orgId = pool.getLong("entryentity1.purorg");
                    if (null != orgMap.get(orgId) || purPlanId != pool.getLong("entryentity1.purplanid")) continue;
                    orgMap.put(orgId, enable);
                }
                isGoodView = false;
                isgoodvisible = false;
            } else {
                qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(protocolid)));
                ent_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)"purmode,entryentity.orgname", (QFilter[])qFilter.toArray());
                if (ent_protocols.size() > 0) {
                    DynamicObject protocolInfo = (DynamicObject)ent_protocols.get(0);
                    if (!protocolInfo.getString("purmode").equals("1")) {
                        for (DynamicObject pool : ent_protocols) {
                            long orgId = pool.getLong("entryentity.orgname");
                            if (0L == orgId || null != orgMap.get(orgId)) continue;
                            orgMap.put(orgId, enable);
                        }
                        isgoodvisible = false;
                        isGoodView = false;
                    } else {
                        if (orgMap.size() > 0) {
                            isGoodView = false;
                        }
                        if (orgMap.size() == 0 && null != this.getPageCache().get("isGoodView")) {
                            isGoodView = Boolean.parseBoolean(String.valueOf(this.getPageCache().get("isGoodView")));
                        }
                    }
                }
            }
        } else {
            if (orgMap.size() > 0) {
                isGoodView = false;
            }
            if (orgMap.size() == 0 && null != this.getPageCache().get("isGoodView")) {
                isGoodView = Boolean.parseBoolean(String.valueOf(this.getPageCache().get("isGoodView")));
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (Map.Entry map : orgMap.entrySet()) {
            ts.set("orgname_id", map.getKey(), index);
            ts.set("status", map.getValue(), index);
            ++index;
        }
        this.getModel().beginInit();
        model.batchCreateNewEntryRow("entryentity", ts);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.getPageCache().put("isGoodView", String.valueOf(isGoodView));
        this.getPageCache().put("isgoodvisible", String.valueOf(isgoodvisible));
        this.getModel().setValue("isgoodvisible", (Object)isGoodView);
    }

    private boolean getIsExistPool(Map<Long, String> orgMap) {
        boolean isExistPool = false;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        QFilter qFilter = null;
        if (null != customParams.get("prodPoolIds")) {
            List prodPoolIds = (List)customParams.get("prodPoolIds");
            qFilter = new QFilter("id", "=", prodPoolIds.get(0));
        } else {
            Object protocolid = customParams.get("protocolid");
            Object protocolentryid = customParams.get("protocolentryid");
            List goodsId = (List)customParams.get("goodsid");
            qFilter = new QFilter("goods.id", "in", (Object)goodsId);
            if (null != protocolentryid) {
                qFilter.and(new QFilter("protocolentry.id", "=", (Object)Long.parseLong(String.valueOf(protocolentryid))));
            }
            if (null != protocolid) {
                qFilter.and(new QFilter("protocol.id", "=", (Object)Long.parseLong(String.valueOf(protocolid))));
            }
        }
        boolean isGoodView = true;
        DynamicObjectCollection ent_prodpool = QueryServiceHelper.query((String)"ent_prodpool", (String)"entryentity.orgname,isgoodvisible", (QFilter[])qFilter.toArray());
        for (DynamicObject pool : ent_prodpool) {
            long orgId = pool.getLong("entryentity.orgname");
            if (0L != orgId) {
                orgMap.put(orgId, "1");
            }
            isExistPool = true;
            isGoodView = pool.getBoolean("isgoodvisible");
        }
        if (ent_prodpool.size() > 0) {
            this.getPageCache().put("isGoodView", String.valueOf(isGoodView));
        }
        return isExistPool;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        if ("orgname".equals(property.getName())) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            QFilter qFilter = null;
            ArrayList<Long> orgFilterIdList = new ArrayList<Long>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                orgFilterIdList.add(entry.getLong("orgname_id"));
            }
            Set<Long> conflictOrgIds = this.getConflictOrgIds();
            orgFilterIdList.addAll(conflictOrgIds);
            if (orgFilterIdList.size() > 0) {
                qFilter = new QFilter("id", "not in", orgFilterIdList);
            }
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("isgoodvisible".equals(name) && ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
            Set<Long> conflictOrgIds = this.getConflictOrgIds();
            if (conflictOrgIds.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u751f\u6548\u671f\u95f4\uff0c\u5546\u54c1\u5df2\u5173\u8054\u591a\u4e2a\u7ec4\u7ec7\u9694\u79bb\u7684\u534f\u8bae\uff0c\u4e0d\u652f\u6301\u5c06\u53ef\u552e\u7ec4\u7ec7\u6539\u4e3a\u5168\u96c6\u56e2\u5171\u4eab\u3002", (String)"PmmOrgScopeSettingEdit_2", (String)"scm-malcore-common", (Object[])new Object[0]));
                this.getModel().setValue("isgoodvisible", (Object)false);
            } else {
                this.getModel().deleteEntryData("entryentity");
            }
        }
        if ("status".equals(name) && ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.checkConflictOrgIds(rowIndex);
        }
    }

    private void checkConflictOrgIds(int rowIndex) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgname", rowIndex);
        Long checkOrgId = org.getLong("id");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String protocolId = String.valueOf(customParams.get("protocolid"));
        List goodsId = (List)customParams.get("goodsid");
        QFilter qFilter = new QFilter("goods.id", "in", (Object)goodsId);
        qFilter.and(new QFilter("protocol.id", "!=", (Object)0L));
        QFilter protocolStatus = new QFilter("protocol.protocolstatus", "=", (Object)"A");
        protocolStatus.or(new QFilter("protocol.protocolstatus", "=", (Object)"B"));
        QFilter malstatus = new QFilter("mallstatus", "=", (Object)"A");
        malstatus.or(new QFilter("mallstatus", "=", (Object)"B"));
        qFilter.and(protocolStatus).and(malstatus);
        DynamicObjectCollection prodPoolDynColl = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods.id,goods.number,protocol.id,protocol.protocolname,protocol.effectdate,protocol.invaliddate,isgoodvisible,entryentity.orgname.id orgname", (QFilter[])qFilter.toArray());
        Date srcEffectdate = null;
        Date srcInvaliddate = null;
        boolean protocolIsGoodVisible = false;
        HashMap<String, String> goodsNo_protocolNameMap = new HashMap<String, String>(1024);
        for (Object row : prodPoolDynColl) {
            if (!protocolId.equals(row.getString("protocol.id"))) continue;
            protocolIsGoodVisible = row.getBoolean("isgoodvisible");
            srcEffectdate = row.getDate("protocol.effectdate");
            srcInvaliddate = row.getDate("protocol.invaliddate");
        }
        for (Object row : prodPoolDynColl) {
            if (null == srcEffectdate || null == srcInvaliddate || protocolId.equals(row.getString("protocol.id"))) continue;
            Date date = row.getDate("protocol.effectdate");
            Date tarInvaliddate = row.getDate("protocol.invaliddate");
            long orgId = row.getLong("orgname");
            boolean tarProtocolIsGoodVisible = row.getBoolean("isgoodvisible");
            if (date.after(srcInvaliddate) || tarInvaliddate.before(srcEffectdate) || checkOrgId != orgId && (!protocolIsGoodVisible || 0L == orgId) && !tarProtocolIsGoodVisible) continue;
            goodsNo_protocolNameMap.put(row.getString("goods.number"), row.getString("protocol.protocolname"));
        }
        if (goodsNo_protocolNameMap.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : goodsNo_protocolNameMap.entrySet()) {
                if (goodsNo_protocolNameMap.size() == 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1{0}\u5728\u6709\u6548\u671f\u95f4\u5b58\u5728\u91c7\u4e70\u7ec4\u7ec7\u51b2\u7a81\u7684\u534f\u8bae({1})\u3002", (String)"PmmOrgScopeSettingEdit_3", (String)"scm-malcore-common", (Object[])new Object[]{entry.getKey(), entry.getValue()}));
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u5728\u6709\u6548\u671f\u95f4\u5b58\u5728\u91c7\u4e70\u7ec4\u7ec7\u51b2\u7a81\u7684\u534f\u8bae({1})\u3002", (String)"PmmOrgScopeSettingEdit_3", (String)"scm-malcore-common", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                stringBuilder.append(msg).append('\n');
            }
            if (stringBuilder.length() > 0) {
                String title = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"PmmOrgScopeSettingEdit_4", (String)"scm-malcore-common", (Object[])new Object[0]);
                this.getView().showMessage(title, stringBuilder.toString(), MessageTypes.Default);
            }
            this.getModel().setValue("status", (Object)Boolean.FALSE, rowIndex);
        }
    }

    private Set<Long> getConflictOrgIds() {
        HashSet<Long> conflictOrgIds = new HashSet<Long>(1024);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String protocolId = String.valueOf(customParams.get("protocolid"));
        List goodsId = (List)customParams.get("goodsid");
        QFilter qFilter = new QFilter("goods.id", "in", (Object)goodsId);
        qFilter.and(new QFilter("protocol.id", "!=", (Object)0L));
        QFilter protocolStatus = new QFilter("protocol.protocolstatus", "=", (Object)"A");
        protocolStatus.or(new QFilter("protocol.protocolstatus", "=", (Object)"B"));
        QFilter malstatus = new QFilter("mallstatus", "=", (Object)"A");
        malstatus.or(new QFilter("mallstatus", "=", (Object)"B"));
        DynamicObjectCollection prodPoolDynColl = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods.id,protocol.id,protocol.effectdate,protocol.invaliddate,isgoodvisible,entryentity.orgname.id orgname", (QFilter[])qFilter.toArray());
        Date srcEffectdate = null;
        Date srcInvaliddate = null;
        for (DynamicObject row : prodPoolDynColl) {
            if (!protocolId.equals(row.getString("protocol.id"))) continue;
            srcEffectdate = row.getDate("protocol.effectdate");
            srcInvaliddate = row.getDate("protocol.invaliddate");
        }
        for (DynamicObject row : prodPoolDynColl) {
            if (null == srcEffectdate || null == srcInvaliddate) break;
            if (protocolId.equals(row.getString("protocol.id"))) continue;
            Date tarEffectdate = row.getDate("protocol.effectdate");
            Date tarInvaliddate = row.getDate("protocol.invaliddate");
            long orgId = row.getLong("orgname");
            if (tarEffectdate.after(srcInvaliddate) || tarInvaliddate.before(srcEffectdate) || 0L == orgId) continue;
            conflictOrgIds.add(orgId);
        }
        log.info("conflictOrgIds=" + SerializationUtils.toJsonString(conflictOrgIds));
        Set<Long> protocolOrgIds = this.getProtocolMap(goodsId, srcEffectdate, srcInvaliddate);
        if (protocolOrgIds.size() > 0) {
            log.info("protocolOrgIds=" + SerializationUtils.toJsonString(protocolOrgIds));
            conflictOrgIds.addAll(protocolOrgIds);
        }
        return conflictOrgIds;
    }

    private Set<Long> getProtocolMap(List<Long> goodsIds, Date srcEffectdate, Date srcInvaliddate) {
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        if (null == srcEffectdate || null == srcInvaliddate) {
            return orgIdSet;
        }
        QFilter filter = new QFilter("entryentity.goods.id", "in", goodsIds);
        QFilter statusFilter = new QFilter("cfmstatus", "=", (Object)"A");
        filter.and(statusFilter);
        filter.and(new QFilter("biztype", "=", (Object)"1"));
        filter.and(new QFilter("protocolid.id", "!=", (Object)0L));
        String prodSectlors = "id,entryentity.goods.id,protocolid.id,billno,protocolid.effectdate,protocolid.invaliddate";
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"ent_prodrequest", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
        HashSet<Long> protocolIDSet = new HashSet<Long>(1024);
        for (DynamicObject row : prodDynColl) {
            Date tarEffectdate = row.getDate("protocolid.effectdate");
            Date tarInvaliddate = row.getDate("protocolid.invaliddate");
            if (tarEffectdate.after(srcInvaliddate) || tarInvaliddate.before(srcEffectdate)) continue;
            protocolIDSet.add(row.getLong("protocolid.id"));
        }
        if (protocolIDSet.size() > 0) {
            QFilter proFilter = new QFilter("id", "in", protocolIDSet);
            prodSectlors = "id,entryentity.orgname";
            DynamicObjectCollection protocolCol = QueryServiceHelper.query((String)"pmm_protocol", (String)prodSectlors, (QFilter[])new QFilter[]{proFilter});
            for (DynamicObject row : protocolCol) {
                orgIdSet.add(row.getLong("entryentity.orgname"));
            }
        }
        return orgIdSet;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "confirm": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams.get("prodPoolIds") == null) break;
                List prodPoolIds = (List)customParams.get("prodPoolIds");
                this.updateProdPoolOrgSaleSetting(prodPoolIds);
                break;
            }
        }
    }

    private void updateProdPoolOrgSaleSetting(List<Long> prodPoolIds) {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        this.clearNoDataRow(entryEntity);
        DynamicObject[] prodPoolDynArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,salestatus,isgoodvisible,entryentity.orgname,mallstatus,protocol,goods,protocolentry", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolIds)});
        Boolean isGoodVisible = (Boolean)this.getModel().getValue("isgoodvisible");
        for (DynamicObject prodPoolDyn : prodPoolDynArray) {
            prodPoolDyn.set("isgoodvisible", (Object)isGoodVisible);
            DynamicObjectCollection dynamicObjectCollection = prodPoolDyn.getDynamicObjectCollection("entryentity");
            dynamicObjectCollection.clear();
            DynamicObjectCollection newEntrys = new DynamicObjectCollection();
            for (DynamicObject entry : entryEntity) {
                DynamicObject prodPoolEntry = dynamicObjectCollection.addNew();
                if (!entry.getBoolean("status")) continue;
                prodPoolEntry.set("orgname_id", (Object)entry.getLong("orgname_id"));
                newEntrys.add((Object)prodPoolEntry);
            }
            prodPoolDyn.set("entryentity", (Object)newEntrys);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"salestatusset", (String)"pmm_prodpool", (DynamicObject[])prodPoolDynArray, (OperateOption)option);
    }

    private void clearNoDataRow(DynamicObjectCollection entryEntity) {
        Iterator iterator = entryEntity.iterator();
        DynamicObject row = null;
        Object obj = null;
        while (iterator.hasNext()) {
            row = (DynamicObject)iterator.next();
            obj = row.get("orgname");
            if (!StringUtils.isBlank((Object)obj)) continue;
            iterator.remove();
        }
    }
}

