/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.CommonUtil;

@Deprecated
public class MalFeeHandleHelper {
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final Map<String, String> MALFEE_CACHE = new HashMap<String, String>(16);
    private static String CACHEPREFIX = "mal_fee_";

    public static Map<String, String> getCacheHolder() {
        return MALFEE_CACHE;
    }

    public static void clearRedisCacheByExtFeeKey(String extFeeId) {
        MALFEE_CACHE.remove(CACHEPREFIX + extFeeId);
    }

    public static void clearRedisCacheByGoodsKey(String goodsId) {
        MALFEE_CACHE.remove(CACHEPREFIX + goodsId);
    }

    public static void clearRedisCacheBySupKey(String supplierId) {
        MALFEE_CACHE.remove(CACHEPREFIX + supplierId);
    }

    public static String getAddressLongNum(String addressId) {
        String longNum = "";
        QFilter idfilter = new QFilter("id", "=", (Object)Long.valueOf(addressId));
        DynamicObject address = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,longnumber", (QFilter[])new QFilter[]{idfilter});
        longNum = address.getString("longnumber");
        return longNum;
    }

    public static void calDynamicObjectFee(DynamicObject bill, String addressId, boolean isForceCahce) {
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        MalFeeHandleHelper.preHandleData(dyoCol, isForceCahce);
        MalFeeHandleHelper.calExtendFee(bill);
        MalFeeHandleHelper.calAvgFreight(bill, addressId);
        MalFeeHandleHelper.handleTaxAmount(dyoCol, true);
    }

    public static void handleTailDiff(DynamicObject bill) {
        int pricePrecision = ((DynamicObject)bill.get("curr")).getInt("priceprecision");
        int amtPrecision = ((DynamicObject)bill.get("curr")).getInt("amtprecision");
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        BigDecimal totalCalTaxAmount = BigDecimal.ZERO;
        BigDecimal sumAmount = bill.getBigDecimal("sumamount");
        BigDecimal diffAmount = BigDecimal.ZERO;
        HashMap<Integer, BigDecimal> qtyMap = new HashMap<Integer, BigDecimal>();
        for (DynamicObject dyo : dyoCol) {
            qtyMap.put(dyo.getInt("seq"), dyo.getBigDecimal("qty"));
            totalCalTaxAmount = totalCalTaxAmount.add(dyo.getBigDecimal("qty").multiply(dyo.getBigDecimal("taxprice")));
        }
        boolean flag = true;
        if (totalCalTaxAmount.compareTo(sumAmount) < 0) {
            diffAmount = sumAmount.subtract(totalCalTaxAmount);
            MalFeeHandleHelper.setDiffToDynamicObject(dyoCol, diffAmount, qtyMap, flag, pricePrecision, amtPrecision);
        } else if (totalCalTaxAmount.compareTo(sumAmount) > 0) {
            diffAmount = totalCalTaxAmount.subtract(sumAmount);
            flag = false;
            MalFeeHandleHelper.setDiffToDynamicObject(dyoCol, diffAmount, qtyMap, flag, pricePrecision, amtPrecision);
        }
    }

    private static void setDiffToDynamicObject(DynamicObjectCollection dyoCol, BigDecimal diffAmount, Map<Integer, BigDecimal> qtyMap, boolean flag, int pricePrecision, int amtPrecision) {
        BigDecimal BASEAMOUNT = BigDecimal.TEN.pow(amtPrecision);
        BigDecimal taxPrice = BigDecimal.ZERO;
        DynamicObject targetDyo = null;
        String integerStr = "";
        for (Map.Entry<Integer, BigDecimal> seqMap : qtyMap.entrySet()) {
            integerStr = diffAmount.multiply(BASEAMOUNT).divide(seqMap.getValue(), amtPrecision, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
            if (!Pattern.matches("\\d+", integerStr)) continue;
            targetDyo = (DynamicObject)dyoCol.get(seqMap.getKey() - 1);
            taxPrice = targetDyo.getBigDecimal("taxprice");
            if (flag) {
                targetDyo.set("taxprice", (Object)taxPrice.add(diffAmount.divide(seqMap.getValue(), pricePrecision, RoundingMode.HALF_UP)));
            } else {
                targetDyo.set("taxprice", (Object)taxPrice.subtract(diffAmount.divide(seqMap.getValue(), pricePrecision, RoundingMode.HALF_UP)));
            }
            dyoCol.set(seqMap.getKey() - 1, (Object)targetDyo);
            break;
        }
    }

    public static void calExtendFee(DynamicObject bill) {
        int pricePrecision = ((DynamicObject)bill.get("curr")).getInt("priceprecision");
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        String goodsId = "";
        BigDecimal goodPrice = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal extAmount = BigDecimal.ZERO;
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal perAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal totalExtAmount = BigDecimal.ZERO;
        BigDecimal rowTotalExtAmount = BigDecimal.ZERO;
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods");
            taxPrice = goodPrice = dyo.getBigDecimal("goodprice");
            rowTotalExtAmount = BigDecimal.ZERO;
            String extFeeCacheIds = MALFEE_CACHE.get(CACHEPREFIX + goodsId);
            if (StringUtils.equalsIgnoreCase((CharSequence)extFeeCacheIds, (CharSequence)"NOEXTFEE")) {
                dyo.set("extamount", (Object)extAmount);
                dyo.set("taxprice", (Object)taxPrice);
            } else {
                for (String key : extFeeCacheIds.split(",")) {
                    qty = dyo.getBigDecimal("qty");
                    extAmount = BigDecimal.ZERO;
                    String feeAmount = MALFEE_CACHE.get(key);
                    if (null != feeAmount) {
                        perAmount = CommonUtil.getBigDecimalPro((Object)feeAmount.split("_")[0]);
                        maxAmount = CommonUtil.getBigDecimalPro((Object)feeAmount.split("_")[1]);
                    }
                    if (qty.multiply(perAmount).compareTo(maxAmount) <= 0) {
                        taxPrice = taxPrice.add(perAmount);
                        extAmount = extAmount.add(perAmount.multiply(qty));
                    } else {
                        extAmount = maxAmount;
                        taxPrice = goodPrice.add(maxAmount.divide(qty, RoundingMode.HALF_UP)).setScale(pricePrecision, RoundingMode.HALF_UP);
                    }
                    rowTotalExtAmount = rowTotalExtAmount.add(extAmount);
                }
            }
            dyo.set("extamount", (Object)rowTotalExtAmount);
            dyo.set("taxprice", (Object)taxPrice);
            totalExtAmount = totalExtAmount.add(rowTotalExtAmount);
        }
        bill.set("freight", (Object)totalExtAmount);
    }

    public static void calAvgFreight(DynamicObject bill, String addressId) {
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        String addressLongNum = MalFeeHandleHelper.getAddressLongNum(addressId);
        List<ProductInfo> supGroupList = MalFeeHandleHelper.getSupGroupList(dyoCol, BigDecimal.ZERO, true);
        MalFeeHandleHelper.setProdInfoSupFreight(addressLongNum, supGroupList);
        MalFeeHandleHelper.handleAvgFreight4Entry(supGroupList, bill, true);
    }

    public static void calAvgFreight4Jd(DynamicObject bill) {
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        BigDecimal freight = bill.getBigDecimal("freight");
        List<ProductInfo> supGroupList = MalFeeHandleHelper.getSupGroupList(dyoCol, freight, false);
        MalFeeHandleHelper.handleAvgFreight4Entry(supGroupList, bill, false);
        MalFeeHandleHelper.handleTaxAmount(dyoCol, false);
    }

    private static void handleTaxAmount(DynamicObjectCollection dyoCol, boolean isContainsExt) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (DynamicObject dyo : dyoCol) {
            taxAmount = isContainsExt ? dyo.getBigDecimal("goodamount").add(dyo.getBigDecimal("extamount")).add(dyo.getBigDecimal("avgfreight")) : dyo.getBigDecimal("goodamount").add(dyo.getBigDecimal("avgfreight"));
            dyo.set("taxamount", (Object)taxAmount);
        }
    }

    public static List<ProductInfo> getSupGroupList(DynamicObjectCollection dyoCol, BigDecimal freight, boolean isContainsExt) {
        HashSet<String> supplierSet = new HashSet<String>(MalFeeHandleHelper.getListByProperty(dyoCol, "supplier"));
        String goodsId = "";
        String supplierId = "";
        HashMap<String, EntryInfo> map = null;
        ArrayList<ProductInfo> supGroupList = new ArrayList<ProductInfo>(supplierSet.size());
        for (String id : supplierSet) {
            map = new HashMap<String, EntryInfo>();
            for (DynamicObject dyo : dyoCol) {
                supplierId = dyo.getString("supplier");
                goodsId = dyo.getString("goods");
                if (!StringUtils.equals((CharSequence)id, (CharSequence)supplierId)) continue;
                map.put(goodsId, new EntryInfo(goodsId, dyo.getBigDecimal("qty"), dyo.getBigDecimal("goodprice"), isContainsExt ? dyo.getBigDecimal("taxprice") : dyo.getBigDecimal("goodprice"), BigDecimal.ZERO, isContainsExt ? dyo.getBigDecimal("extamount") : BigDecimal.ZERO, dyo.getBigDecimal("goodamount")));
            }
            supGroupList.add(new ProductInfo(id, freight, BigDecimal.ZERO, map));
        }
        return supGroupList;
    }

    public static Map<String, List<String>> getSupGoodsGroupMap(DynamicObject bill) {
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        HashSet<String> supplierSet = new HashSet<String>(MalFeeHandleHelper.getListByProperty(dyoCol, "supplier"));
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(supplierSet.size());
        ArrayList<String> goodsList = null;
        String goodsNum = "";
        String supplierId = "";
        for (String id : supplierSet) {
            goodsList = new ArrayList<String>();
            for (DynamicObject dyo : dyoCol) {
                supplierId = dyo.getString("supplier");
                goodsNum = dyo.getString("goodsnum");
                if (!StringUtils.equals((CharSequence)id, (CharSequence)supplierId)) continue;
                goodsList.add(goodsNum);
            }
            resultMap.put(id, goodsList);
        }
        return resultMap;
    }

    public static void handleAvgFreight4Entry(List<ProductInfo> supGroupList, DynamicObject bill, boolean isContainsExt) {
        int pricePrecision = ((DynamicObject)bill.get("curr")).getInt("priceprecision");
        int amtPrecision = ((DynamicObject)bill.get("curr")).getInt("amtprecision");
        BigDecimal totalSupFreight = BigDecimal.ZERO;
        BigDecimal rowTaxAmount = BigDecimal.ZERO;
        BigDecimal rowFreight = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal totalSupAmount = BigDecimal.ZERO;
        BigDecimal totalFreight = BigDecimal.ZERO;
        BigDecimal leftFreight = BigDecimal.ZERO;
        Map<String, EntryInfo> entryMap = null;
        HashMap<String, EntryInfo> allEntryMap = new HashMap<String, EntryInfo>();
        BigDecimal freight = BigDecimal.ZERO;
        for (ProductInfo info : supGroupList) {
            totalSupFreight = info.getTotalFreight();
            totalSupAmount = info.getTotalAmount();
            leftFreight = totalSupFreight;
            entryMap = info.getEntryList();
            int i = 0;
            for (Map.Entry<String, EntryInfo> goodsIdMap : entryMap.entrySet()) {
                rowTaxAmount = goodsIdMap.getValue().getTaxAmount();
                if (++i < entryMap.size()) {
                    rowFreight = totalSupFreight.multiply(rowTaxAmount).divide(totalSupAmount, RoundingMode.HALF_UP).setScale(amtPrecision, RoundingMode.HALF_UP);
                    leftFreight = leftFreight.subtract(rowFreight);
                } else {
                    rowFreight = leftFreight;
                }
                taxPrice = goodsIdMap.getValue().getTaxprice().add(rowFreight.divide(goodsIdMap.getValue().getQty(), RoundingMode.HALF_UP)).setScale(pricePrecision, RoundingMode.HALF_UP);
                goodsIdMap.getValue().setAvgfreight(rowFreight);
                goodsIdMap.getValue().setTaxprice(taxPrice);
            }
            allEntryMap.putAll(entryMap);
            totalFreight = totalFreight.add(totalSupFreight);
        }
        String goodsId = "";
        DynamicObjectCollection dyoCol = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods");
            dyo.set("avgfreight", (Object)((EntryInfo)allEntryMap.get(goodsId)).getAvgfreight());
            dyo.set("taxprice", (Object)((EntryInfo)allEntryMap.get(goodsId)).getTaxprice());
        }
        freight = isContainsExt ? bill.getBigDecimal("freight").add(totalFreight) : totalFreight;
        bill.set("freight", (Object)freight);
        bill.set("sumamount", (Object)bill.getBigDecimal("freight").add(bill.getBigDecimal("totalamount")));
    }

    public static Set<String> checkGoodsSellArea(String addressId, Map<String, List<String>> supGoodsMap) {
        HashSet<String> resultSet = new HashSet<String>();
        String longNum = MalFeeHandleHelper.getAddressLongNum(addressId);
        Set<String> suppliers = supGoodsMap.keySet();
        HashSet<Long> supplierSet = new HashSet<Long>(suppliers.size());
        for (String supplier : suppliers) {
            supplierSet.add(Long.valueOf(supplier));
        }
        QFilter freightFilter = new QFilter("supplier", "in", supplierSet);
        String freightFields = "supplier.id,supplier.number,national,entryentity.longnumber";
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"ent_freightscheme", (String)freightFields, (QFilter[])new QFilter[]{freightFilter});
        String entryLongNum = "";
        String national = "";
        String supplierId = "";
        if (null != dyoCol && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                national = dyo.getString("national");
                supplierId = dyo.getString("supplier.id");
                if (StringUtils.equals((CharSequence)national, (CharSequence)"true") || !StringUtils.isBlank((CharSequence)(entryLongNum = dyo.getString("entryentity.longnumber"))) && MalFeeHandleHelper.maxLenOfLCString(longNum, entryLongNum) > 3) continue;
                resultSet.addAll((Collection<String>)supGoodsMap.get(supplierId));
            }
        }
        return resultSet;
    }

    public static void setProdInfoSupFreight(String addressLongNum, List<ProductInfo> supGroupList) {
        String supplierId = "";
        for (ProductInfo info : supGroupList) {
            Map freightInfoMap = null;
            supplierId = info.getSupplier();
            String result = MALFEE_CACHE.get(CACHEPREFIX + supplierId);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                freightInfoMap = (Map)SerializationUtils.fromJsonString((String)MALFEE_CACHE.get(CACHEPREFIX + supplierId), Map.class);
            }
            MalFeeHandleHelper.setTotalFreight(freightInfoMap, info, addressLongNum);
        }
    }

    private static void setTotalFreight(Map<String, String> freightInfoMap, ProductInfo info, String addressLongNum) {
        if (null == freightInfoMap || freightInfoMap.isEmpty()) {
            info.setTotalFreight(BigDecimal.ZERO);
        } else {
            String freightMsg = MalFeeHandleHelper.getFinalFreight(addressLongNum, freightInfoMap);
            if (StringUtils.isNotBlank((CharSequence)freightMsg)) {
                if (CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[0]).compareTo(info.getTotalAmount()) > 0) {
                    info.setTotalFreight(CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[1]));
                } else {
                    info.setTotalFreight(BigDecimal.ZERO);
                }
            } else if (StringUtils.equals((CharSequence)"true", (CharSequence)freightInfoMap.get("isNational"))) {
                freightMsg = freightInfoMap.get("basefreight");
                info.setTotalFreight(CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[1]));
            } else {
                info.setTotalFreight(BigDecimal.ZERO);
            }
        }
    }

    public static BigDecimal getFreightFree(String addressId, String supplierId) {
        String freightMsg;
        Map freightInfoMap = null;
        String result = MalFeeHandleHelper.getCacheHolder().get(CACHEPREFIX + supplierId);
        String addressLongNum = MalFeeHandleHelper.getAddressLongNum(addressId);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            freightInfoMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        }
        BigDecimal freightFree = null;
        freightFree = null == freightInfoMap || freightInfoMap.isEmpty() ? BigDecimal.ZERO : (StringUtils.isNotBlank((CharSequence)(freightMsg = MalFeeHandleHelper.getFinalFreight(addressLongNum, freightInfoMap))) ? CommonUtil.getBigDecimalPro((Object)freightMsg.split("_")[0]) : BigDecimal.ZERO);
        return freightFree;
    }

    public static String getFinalFreight(String addressLongNum, Map<String, String> freightInfoMap) {
        String freightMsg = "";
        for (Map.Entry<String, String> longNumMap : freightInfoMap.entrySet()) {
            if (StringUtils.equals((CharSequence)"basefreight", (CharSequence)longNumMap.getKey()) || StringUtils.equals((CharSequence)"isNational", (CharSequence)longNumMap.getKey())) continue;
            String[] longNumS = longNumMap.getKey().split(",");
            if (StringUtils.contains((CharSequence)longNumMap.getKey(), (CharSequence)".")) {
                for (String splitNum : longNumS) {
                    if (!addressLongNum.contains(splitNum)) continue;
                    freightMsg = longNumMap.getValue();
                    break;
                }
            }
            if (!StringUtils.isBlank((CharSequence)freightMsg) || StringUtils.contains((CharSequence)longNumMap.getKey(), (CharSequence)".")) continue;
            for (String splitNum : longNumS) {
                if (!addressLongNum.contains(splitNum)) continue;
                freightMsg = longNumMap.getValue();
            }
        }
        return freightMsg;
    }

    public static void preHandleData(DynamicObjectCollection dyoCol, boolean isForceCahce) {
        ArrayList<String> goodsIdList = new ArrayList<String>();
        HashSet<String> supplierIdSet = new HashSet<String>();
        String goodsId = "";
        String supplierId = "";
        for (DynamicObject dyo : dyoCol) {
            goodsId = dyo.getString("goods");
            if (StringUtils.isBlank((CharSequence)MALFEE_CACHE.get(CACHEPREFIX + goodsId))) {
                goodsIdList.add(goodsId);
            }
            supplierId = dyo.getString("supplier");
            if (!StringUtils.isBlank((CharSequence)MALFEE_CACHE.get(CACHEPREFIX + supplierId)) && !isForceCahce) continue;
            supplierIdSet.add(supplierId);
        }
        if (goodsIdList.size() > 0) {
            MalFeeHandleHelper.cacheExtFee(goodsIdList);
        }
        if (supplierIdSet.size() > 0) {
            MalFeeHandleHelper.cacheFreight(supplierIdSet);
        }
    }

    public static void cacheExtFee(List<String> goodsIdList) {
        Map<String, Object> resultMap = MalFeeHandleHelper.getExtendFeeMap(goodsIdList);
        Map goodsFeeMap = (Map)resultMap.get("goodsFeeMap");
        Set feeIdSet = (Set)resultMap.get("feeIdSet");
        MalFeeHandleHelper.updateCacheExtFee(feeIdSet);
        for (Map.Entry goodsIdMap : goodsFeeMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)goodsIdMap.getValue()))) {
                MALFEE_CACHE.put(CACHEPREFIX + (String)goodsIdMap.getKey(), "NOEXTFEE");
                continue;
            }
            MALFEE_CACHE.put(CACHEPREFIX + (String)goodsIdMap.getKey(), CACHEPREFIX + ((String)goodsIdMap.getValue()).replaceAll(",", "," + CACHEPREFIX));
        }
    }

    public static void updateCacheExtFee(Set<String> feeIdSet) {
        HashSet feeSet = new HashSet();
        feeIdSet.forEach(id -> feeSet.add(Long.valueOf(id)));
        QFilter extFeeFilter = new QFilter("id", "in", feeSet);
        String extFeeFields = "id,cost,maxcost";
        DynamicObjectCollection feeDyoCol = QueryServiceHelper.query((String)"ent_surcharge", (String)extFeeFields, (QFilter[])new QFilter[]{extFeeFilter});
        if (null != feeDyoCol && feeDyoCol.size() > 0) {
            String cacheKey = "";
            String cacheValue = "";
            for (DynamicObject dyo : feeDyoCol) {
                cacheKey = CACHEPREFIX + dyo.getString("id");
                cacheValue = dyo.getString("cost") + "_" + dyo.getString("maxcost");
                MALFEE_CACHE.put(cacheKey, cacheValue);
            }
        }
    }

    public static void cacheFreight(Set<String> supplierIdSet) {
        String cacheKey = "";
        String cacheValue = "";
        String supplierId = "";
        HashMap<String, String> freightMap = null;
        HashSet supplierSet = new HashSet();
        supplierIdSet.forEach(id -> supplierSet.add(Long.valueOf(id)));
        QFilter freightFilter = new QFilter("supplier", "in", supplierSet);
        String freightFields = "supplier.id,national,basefreight,entryentity.longnumber,entryentity.price,entryentity.freight";
        DynamicObject[] freightDyoCol = BusinessDataServiceHelper.load((String)"ent_freightscheme", (String)freightFields, (QFilter[])new QFilter[]{freightFilter}, (String)"entryentity.longnumber desc");
        if (null != freightDyoCol && freightDyoCol.length > 0) {
            for (DynamicObject dyo : freightDyoCol) {
                supplierId = dyo.getString("supplier.id");
                DynamicObjectCollection entryCol = dyo.getDynamicObjectCollection("entryentity");
                freightMap = new HashMap<String, String>();
                for (DynamicObject entryDyo : entryCol) {
                    String longNum = entryDyo.getString("longnumber");
                    if (!StringUtils.isNotBlank((CharSequence)longNum)) continue;
                    freightMap.put(longNum, entryDyo.getString("price") + "_" + entryDyo.getString("freight"));
                }
                freightMap.put("basefreight", "0.00_" + dyo.getString("basefreight"));
                freightMap.put("isNational", dyo.getString("national"));
                cacheKey = CACHEPREFIX + supplierId;
                cacheValue = SerializationUtils.toJsonString(freightMap);
                MALFEE_CACHE.put(cacheKey, cacheValue);
            }
        }
    }

    private static Map<String, Object> getExtendFeeMap(List<String> goodsIdList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> goodsFeeMap = new HashMap<String, String>();
        HashSet<String> feeIdSet = new HashSet<String>();
        ArrayList goodsList = new ArrayList();
        goodsIdList.forEach(id -> goodsList.add(Long.valueOf(id)));
        QFilter filter = new QFilter("id", "in", goodsList);
        String selectFields = "id,surchargeid";
        DynamicObjectCollection goodDyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)selectFields, (QFilter[])new QFilter[]{filter});
        String extenFeeIds = "";
        String goodsId = "";
        if (null != goodDyoCol && goodDyoCol.size() > 0) {
            for (DynamicObject dyo : goodDyoCol) {
                goodsId = dyo.getString("id");
                extenFeeIds = dyo.getString("surchargeid");
                goodsFeeMap.put(goodsId, extenFeeIds);
                if (StringUtils.isBlank((CharSequence)extenFeeIds)) continue;
                for (String feeId : extenFeeIds.split(",")) {
                    feeIdSet.add(feeId);
                }
            }
            resultMap.put("feeIdSet", feeIdSet);
            resultMap.put("goodsFeeMap", goodsFeeMap);
        }
        return resultMap;
    }

    public static int maxLenOfLCString(String X, String Y) {
        int[][] c = new int[X.length() + 1][Y.length() + 1];
        int maxlen = 0;
        for (int i = 1; i <= X.length(); ++i) {
            for (int j = 1; j <= Y.length(); ++j) {
                if (X.charAt(i - 1) != Y.charAt(j - 1)) continue;
                c[i][j] = c[i - 1][j - 1] + 1;
                if (c[i][j] <= maxlen) continue;
                maxlen = c[i][j];
            }
        }
        return maxlen;
    }

    public static List<String> getListByProperty(DynamicObjectCollection selectedRowsDyObject, String property) {
        ArrayList<String> proList = new ArrayList<String>();
        for (DynamicObject dyObj : selectedRowsDyObject) {
            proList.add(dyObj.getString(property));
        }
        return proList;
    }

    static class EntryInfo {
        private String goods;
        private BigDecimal qty;
        private BigDecimal goodprice;
        private BigDecimal taxprice;
        private BigDecimal avgfreight;
        private BigDecimal extamount;
        private BigDecimal taxAmount;

        public EntryInfo(String goods, BigDecimal qty, BigDecimal goodprice, BigDecimal taxprice, BigDecimal avgfreight, BigDecimal extamount, BigDecimal taxAmount) {
            this.goods = goods;
            this.qty = qty;
            this.goodprice = goodprice;
            this.taxprice = taxprice;
            this.avgfreight = avgfreight;
            this.extamount = extamount;
            this.taxAmount = taxAmount;
        }

        public String getGoods() {
            return this.goods;
        }

        public void setGoods(String goods) {
            this.goods = goods;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getGoodprice() {
            return this.goodprice;
        }

        public void setGoodprice(BigDecimal goodprice) {
            this.goodprice = goodprice;
        }

        public BigDecimal getTaxprice() {
            return this.taxprice;
        }

        public void setTaxprice(BigDecimal taxprice) {
            this.taxprice = taxprice;
        }

        public BigDecimal getAvgfreight() {
            return this.avgfreight;
        }

        public void setAvgfreight(BigDecimal avgfreight) {
            this.avgfreight = avgfreight;
        }

        public BigDecimal getExtamount() {
            return this.extamount;
        }

        public void setExtamount(BigDecimal extamount) {
            this.extamount = extamount;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public String toString() {
            return "EntryInfo [goods=" + this.goods + ", qty=" + this.qty + ", goodprice=" + this.goodprice + ", taxprice=" + this.taxprice + ", avgfreight=" + this.avgfreight + ", extamount=" + this.extamount + ", taxAmount=" + this.taxAmount + "]";
        }
    }

    static class ProductInfo {
        private String supplier;
        private BigDecimal totalFreight;
        private BigDecimal totalAmount;
        private Map<String, EntryInfo> entryList;

        public ProductInfo(String supplier, BigDecimal totalFreight, BigDecimal totalAmount, Map<String, EntryInfo> entryList) {
            this.supplier = supplier;
            this.entryList = entryList;
            this.totalFreight = totalFreight;
            this.totalAmount = totalAmount;
            this.calSupTotalAmount();
        }

        private void calSupTotalAmount() {
            if (this.entryList != null) {
                for (Map.Entry<String, EntryInfo> map : this.entryList.entrySet()) {
                    this.totalAmount = this.totalAmount.add(map.getValue().getTaxAmount());
                }
            }
        }

        public String getSupplier() {
            return this.supplier;
        }

        public void setSupplier(String supplier) {
            this.supplier = supplier;
        }

        public BigDecimal getTotalFreight() {
            return this.totalFreight;
        }

        public void setTotalFreight(BigDecimal totalFreight) {
            this.totalFreight = totalFreight;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
        }

        public Map<String, EntryInfo> getEntryList() {
            return this.entryList;
        }

        public void setEntryList(Map<String, EntryInfo> entryList) {
            this.entryList = entryList;
        }
    }
}

