/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.malcore.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.scm.malcore.cache.MalSimpleObject;

public class MalObjectCache<T extends MalSimpleObject> {
    private final IAppCache cache = this.getAppCache();
    private final Class<T> type;
    private Map<String, String> objectMap;

    private IAppCache getAppCache() {
        return AppCache.get((String)MalObjectCache.class.getName());
    }

    public static <T extends MalSimpleObject> MalObjectCache<T> get(Class<T> type) {
        return new MalObjectCache<T>(type);
    }

    public void put(String key, T value) {
        String valJson = SerializationUtils.toJsonString(value);
        this.objectMap.put(key, valJson);
        this.cache.put(this.type.getName(), this.objectMap);
    }

    public T get(String key) {
        String json = this.objectMap.get(key);
        if (json == null || json.isEmpty()) {
            return null;
        }
        return (T)((MalSimpleObject)SerializationUtils.fromJsonString((String)json, this.type));
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this.objectMap.remove(key);
        }
        this.cache.put(this.type.getName(), this.objectMap);
    }

    private void initObjectMap() {
        Map map = (Map)this.cache.get(this.type.getName(), Map.class);
        this.objectMap = map == null ? new HashMap<String, String>() : map;
    }

    public MalObjectCache(Class<T> type) {
        this.type = type;
        this.initObjectMap();
    }
}

