/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.malcore.util.prodinfochange.handle;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.malcore.util.prodinfochange.domain.PropertyInfoVO;
import kd.scm.malcore.util.prodinfochange.enums.ProdInfoChangeTypeEnum;

public class CommonFieldChangeHandle {
    private static Log log = LogFactory.getLog(CommonFieldChangeHandle.class);

    public PropertyInfoVO initPropertyInfoVO(DynamicObject dataEntity, IDataEntityProperty property) {
        PropertyInfoVO propertyInfoVO = new PropertyInfoVO();
        MainEntityType mainEntityType = (MainEntityType)dataEntity.getDataEntityType();
        String propName = property.getName();
        LocaleString propDisplayName = mainEntityType.getProperty(propName).getDisplayName();
        propertyInfoVO.setPropName(propName);
        propertyInfoVO.setPropDisplayName(propDisplayName == null ? null : propDisplayName.toString());
        return propertyInfoVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFieldInfo(Map<String, PropertyInfoVO> valueMap, DynamicObject dataEntity, IDataEntityProperty property, PropertyInfoVO propertyInfoVO) {
        try {
            Object propValue = dataEntity.get(property);
            String infoType = ProdInfoChangeTypeEnum.CHAR.getVal();
            propertyInfoVO.setPropValue(propValue);
            propertyInfoVO.setInfoType(infoType);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        finally {
            valueMap.put(propertyInfoVO.getKey(), propertyInfoVO);
        }
    }

    public boolean propValueCompare(PropertyInfoVO oldPropertyInfoVO, PropertyInfoVO newPropertyInfoVO) {
        Object oldPropValue = oldPropertyInfoVO.getPropValue();
        Object newPropValue = newPropertyInfoVO.getPropValue();
        return oldPropValue.toString().equals(newPropValue.toString());
    }

    public void insertValueToDyn(PropertyInfoVO oldPropertyInfoVO, PropertyInfoVO newPropertyInfoVO, DynamicObject targetDynamicObject) {
        log.info("\u65b0\u589e\u5206\u5f55\u5f00\u59cb" + newPropertyInfoVO.getPropName());
        Object v1 = oldPropertyInfoVO.getPropValue();
        Object v2 = newPropertyInfoVO.getPropValue();
        log.info("\u65b0\u589e\u5206\u5f55\u5f00\u59cbV1:" + v1 + " ,v2:" + v2);
        if (StringUtils.isBlank((Object)v1) && StringUtils.isBlank((Object)v2)) {
            return;
        }
        EntryProp entryProp = (EntryProp)targetDynamicObject.getDataEntityType().getProperties().get((Object)"entryentity");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject tempRow = new DynamicObject((DynamicObjectType)entryType);
        tempRow.set("chgfield", (Object)newPropertyInfoVO.getPropDisplayName());
        tempRow.set("oldvalue", oldPropertyInfoVO.getPropValue());
        tempRow.set("newvalue", newPropertyInfoVO.getPropValue());
        tempRow.set("fieldname", (Object)newPropertyInfoVO.getPropName());
        tempRow.set("srcdata", (Object)newPropertyInfoVO.getSrcData());
        tempRow.set("infotype", (Object)newPropertyInfoVO.getInfoType());
        tempRow.set("entryname", (Object)newPropertyInfoVO.getEntryName());
        tempRow.set("srcbillentryid", (Object)newPropertyInfoVO.getEntryId());
        DynamicObjectCollection tgtChangeEntry = targetDynamicObject.getDynamicObjectCollection("entryentity");
        tgtChangeEntry.add((Object)tempRow);
        log.info("\u65b0\u589e\u5206\u5f55\u5b8c\u6210");
    }

    public void changeEffectUpdateProd(DynamicObject entry, DynamicObject prod) {
        String newValue = entry.getString("newvalue");
        String fieldName = entry.getString("fieldname");
        prod.set(fieldName, (Object)newValue);
    }
}

