/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.malcore.util.prodinfochange.handle.Impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.malcore.util.prodinfochange.domain.PropertyInfoVO;
import kd.scm.malcore.util.prodinfochange.enums.ProdInfoChangeTypeEnum;
import kd.scm.malcore.util.prodinfochange.handle.CommonFieldChangeHandle;

public class PicturePropChangeHandleImpl
extends CommonFieldChangeHandle {
    private static Log log = LogFactory.getLog(PicturePropChangeHandleImpl.class);

    @Override
    public void getFieldInfo(Map<String, PropertyInfoVO> valueMap, DynamicObject dataEntity, IDataEntityProperty property, PropertyInfoVO propertyInfoVO) {
        String picture = (String)dataEntity.get(property);
        if (picture == null) {
            picture = "";
        }
        log.info("\u56fe\u7247:" + propertyInfoVO.getKey() + "\u7684url:" + picture);
        propertyInfoVO.setPropValue(picture);
        propertyInfoVO.setInfoType(ProdInfoChangeTypeEnum.PICTURE.getVal());
        valueMap.put(propertyInfoVO.getKey(), propertyInfoVO);
    }

    @Override
    public void insertValueToDyn(PropertyInfoVO oldPropertyInfoVO, PropertyInfoVO newPropertyInfoVO, DynamicObject targetDynamicObject) {
        log.info("\u56fe\u7247\u5904\u7406\u5f00\u59cb" + newPropertyInfoVO.getPropName());
        String v1 = oldPropertyInfoVO.getPropValue().toString().trim();
        String v2 = newPropertyInfoVO.getPropValue().toString().trim();
        log.info("\u56fe\u7247\u5904\u7406:V1:" + v1 + " ,v2:" + v2);
        if (StringUtils.isBlank((CharSequence)v1) && StringUtils.isBlank((CharSequence)v2)) {
            return;
        }
        targetDynamicObject.set("old" + oldPropertyInfoVO.getPropName(), oldPropertyInfoVO.getPropValue());
        targetDynamicObject.set(newPropertyInfoVO.getPropName(), newPropertyInfoVO.getPropValue());
    }

    @Override
    public void changeEffectUpdateProd(DynamicObject chgDyn, DynamicObject prod) {
        List<String> pictureList = Arrays.asList("thumbnail", "picture1", "picture2", "picture3", "picture4");
        for (String picture : pictureList) {
            String newValue = chgDyn.getString(picture);
            String oldValue = chgDyn.getString("old" + picture);
            if (!StringUtils.isNotBlank((CharSequence)oldValue) && !StringUtils.isNotBlank((CharSequence)newValue)) continue;
            prod.set(picture, (Object)newValue);
        }
    }
}

