/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.cloudkingdee;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tenant.TenantInfo;
import kd.scm.common.cloudkingdee.CloudKingdeeApiService;
import kd.scm.common.cloudkingdee.CompanyInfo;
import kd.scm.common.util.DateUtil;

public class CloudDataUtils {
    private static Log log = LogFactory.getLog(CloudKingdeeApiService.class);
    private static final String api_getCompanyByKeyWord = "/company/getCompanyByKeyWord";

    public static CompanyInfo getCompany(String keyWord) {
        CompanyInfo companyInfo = null;
        return companyInfo;
    }

    public static CompanyInfo getCompanyInfo(String companyName) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"srm_declarationref", (String)"cfmstatus", (QFilter[])new QFilter[]{new QFilter("isdisplay", "=", (Object)"1")});
        String cfmstatus = obj.getString("cfmstatus");
        if (cfmstatus == null || cfmstatus.isEmpty() || !cfmstatus.equals("B")) {
            return null;
        }
        CompanyInfo companyInfo = null;
        List<CompanyInfo> companylist = CloudDataUtils.getCompanyByKeyWord(companyName);
        if (companylist == null || companylist.size() == 0) {
            return null;
        }
        for (CompanyInfo info : companylist) {
            if (!companyName.equals(info.getCompanyName())) continue;
            companyInfo = info;
            break;
        }
        return companyInfo;
    }

    public static List<CompanyInfo> getCompanyByKeyWord(String keyWord) {
        String url;
        ApiRequest request;
        ApiResult result;
        ArrayList<CompanyInfo> infos = new ArrayList<CompanyInfo>();
        log.info("\u5f00\u59cb\u67e5\u8be2\u5de5\u5546\u4fe1\u606f");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("keyWord", keyWord);
        TenantInfo tenantInfo = RequestContext.get().getTenantInfo();
        if (tenantInfo != null) {
            param.put("client_company_id", tenantInfo.getId());
            param.put("client_company_name", tenantInfo.getName());
        }
        if ((result = CloudDataUtils.invokeApi(request = CloudDataUtils.getPostRequestContext(param, url = CloudDataUtils.getUrl(api_getCompanyByKeyWord)))) != null) {
            log.info("\u67e5\u8be2\u4f01\u4e1a\u5de5\u5546\u4fe1\u606f\u7ed3\u679c\uff1a" + result.toString());
        }
        if (result != null && result.isOk()) {
            log.info("\u67e5\u8be2\u4f01\u4e1a\u5de5\u5546\u4fe1\u606f\u7ed3\u679c\uff1a" + result.getData());
            JSONObject node = null;
            try {
                node = JSONObject.parseObject((String)result.getData());
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4f01\u4e1a\u5de5\u5546\u4fe1\u606f\u51fa\u9519\uff1a" + result.getData());
            }
            if (node != null && node.containsKey((Object)"status") && "success".equalsIgnoreCase(node.getString("status")) && node.containsKey((Object)"data")) {
                CompanyInfo info = null;
                JSONArray datas = node.getJSONArray("data");
                JSONObject data = null;
                int size = datas.size();
                for (int i = 0; i < size; ++i) {
                    data = datas.getJSONObject(i);
                    info = new CompanyInfo();
                    if (data.get((Object)"companyAddress") != null) {
                        info.setAddress(data.getString("companyAddress"));
                    }
                    if (data.containsKey((Object)"businessScope")) {
                        info.setBusinessScope(data.getString("businessScope"));
                    }
                    if (data.containsKey((Object)"companyName")) {
                        info.setCompanyName(data.getString("companyName"));
                    }
                    if (data.containsKey((Object)"email")) {
                        info.setEmail(data.getString("email"));
                    }
                    if (data.containsKey((Object)"establisDate") && StringUtils.isNotBlank((CharSequence)data.getString("establisDate"))) {
                        String establisDate = data.getString("establisDate");
                        try {
                            info.setEstablisDate(DateUtil.string2date(establisDate, "yyyy-MM-dd"));
                        }
                        catch (RuntimeException e) {
                            log.warn((Throwable)e);
                        }
                    }
                    if (data.containsKey((Object)"insuredPersons")) {
                        info.setInsuredPersons(data.getString("insuredPersons"));
                    }
                    if (data.containsKey((Object)"profile")) {
                        info.setProfile(data.getString("profile"));
                    }
                    if (data.containsKey((Object)"socialCreditCode")) {
                        info.setSocialCreditCode(data.getString("socialCreditCode"));
                    }
                    if (data.containsKey((Object)"state")) {
                        info.setState(data.getString("state"));
                    }
                    if (data.containsKey((Object)"legalPerson")) {
                        info.setLegalPerson(data.getString("legalPerson"));
                    }
                    infos.add(info);
                }
            } else {
                log.info(MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528\u5927\u6570\u636e\u4e91\u5e73\u53f0\u63a5\u53e3\uff1a{0}\u5931\u8d25", (String)"CloudKingdeeApiService_1", (String)"scm-common", (Object[])new Object[0]), url));
            }
        } else {
            log.info(MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528\u5927\u6570\u636e\u4e91\u5e73\u53f0\u63a5\u53e3\uff1a{0}\u5931\u8d25", (String)"CloudKingdeeApiService_1", (String)"scm-common", (Object[])new Object[0]), api_getCompanyByKeyWord));
        }
        return infos;
    }

    protected static String getUrl(String api) {
        StringBuilder sb = new StringBuilder();
        QFilter qFilter = new QFilter("id", "=", (Object)1534206068832669696L);
        qFilter.and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        DynamicObject clientInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"pur_apiconfig", (String)"ip,client_id,client_secret,enable,status", (QFilter[])new QFilter[]{qFilter});
        if (clientInfo != null) {
            sb.append(clientInfo.getString("ip"));
            sb.append(api);
            sb.append("?client_id=").append(clientInfo.getString("client_id"));
            String client_secret = clientInfo.getString("client_secret");
            try {
                sb.append("&client_secret=").append(EncrypterFactory.getAesEncrypter().decrypt(client_secret));
            }
            catch (EncryptException e) {
                log.error("decrypt error!");
            }
        }
        return sb.toString();
    }

    protected static ApiRequest getPostRequestContext(Map param, String url) {
        ApiRequest request = new ApiRequest("post", url);
        if (param != null && !param.isEmpty()) {
            request.setPostData((Object)param);
        }
        return request;
    }

    private static ApiResult invokeApi(ApiRequest request) {
        return ApiClientFactory.getInternal().execute(request);
    }
}

