/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.httpsutil;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.errorcode.EcApiErrorCode;
import kd.scm.common.ecapi.exception.EcApiException;
import kd.scm.common.ecapi.httpsutil.MyResponseHandler;
import kd.scm.common.enums.PlatformEnums;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.ExceptionUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class HttpClientUtil {
    private static final Log logger = LogFactory.getLog(HttpClientUtil.class);
    public static final long RELEASE_CONNECTION_WAIT_TIME = 600000L;
    private static PoolingHttpClientConnectionManager httpClientConnectionManager = null;
    private static LaxRedirectStrategy redirectStrategy = null;
    private static HttpRequestRetryHandler myRetryHandler = null;
    private static SSLConnectionSocketFactory sslConnectionSocketFactory = null;
    private static MyResponseHandler rh = null;
    private static final Map<String, String> PROXY_MAP = new HashMap<String, String>(16);

    public static void initHttpClient() {
        try {
            rh = new MyResponseHandler();
            redirectStrategy = new LaxRedirectStrategy();
            myRetryHandler = new HttpRequestRetryHandler(){

                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    boolean idempotent;
                    if (executionCount >= 3) {
                        return false;
                    }
                    if (exception instanceof InterruptedIOException) {
                        return false;
                    }
                    if (exception instanceof UnknownHostException) {
                        return false;
                    }
                    if (exception instanceof ConnectTimeoutException) {
                        return false;
                    }
                    if (exception instanceof SSLException) {
                        return false;
                    }
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    HttpRequest request = clientContext.getRequest();
                    boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                    return idempotent;
                }
            };
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            httpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
            httpClientConnectionManager.setMaxTotal(200);
            httpClientConnectionManager.setDefaultMaxPerRoute(20);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setCookieSpec("ignoreCookies").setConnectionRequestTimeout(5000).build();
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)redirectStrategy).setRetryHandler(myRetryHandler).build();
        return httpClient;
    }

    public static String getUrlContent(String urlString, Map<String, String> ... headers) {
        String result = "";
        HttpGet httpGet = null;
        if (null == (urlString = urlString.trim()) || urlString.isEmpty() || !urlString.startsWith("http")) {
            return result;
        }
        try {
            URL url = new URL(urlString);
            URI uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
            httpGet = new HttpGet(uri);
            HttpClientUtil.setCommonHeaders((AbstractHttpMessage)httpGet);
            if (headers != null && headers.length > 0) {
                for (Map.Entry<String, String> header : headers[0].entrySet()) {
                    if (httpGet.containsHeader(header.getKey())) {
                        httpGet.setHeader(header.getKey(), header.getValue());
                        continue;
                    }
                    httpGet.addHeader(header.getKey(), header.getValue());
                }
            }
            CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
            result = (String)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)rh);
        }
        catch (Exception e) {
            throw new EcApiException(EcApiErrorCode.SYS_ERROR, ExceptionUtil.getStackTrace(e));
        }
        finally {
            if (httpGet != null) {
                httpGet.abort();
            }
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> params, Map<String, String> headers) {
        String result = "";
        HttpGet httpGet = null;
        if (StringUtils.isBlank((CharSequence)url)) {
            return result;
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            Set<String> paramSet = params.keySet();
            for (String key : paramSet) {
                uriBuilder.addParameter(key, params.get(key));
            }
            httpGet = new HttpGet(uriBuilder.build());
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                httpGet.setHeader(key, headers.get(key));
            }
            result = (String)HttpClientUtil.getHttpClient().execute((HttpUriRequest)httpGet, (ResponseHandler)rh);
        }
        catch (Exception e) {
            throw new EcApiException(EcApiErrorCode.SYS_ERROR, ExceptionUtil.getStackTrace(e));
        }
        finally {
            httpGet.abort();
        }
        return result;
    }

    public static String postForEntity(String urlString, Map<String, String> params, Map<String, String> ... headers) {
        String result = "";
        HttpPost httpPost = null;
        urlString = urlString.trim();
        try {
            if (null == urlString || urlString.isEmpty() || !urlString.startsWith("http")) {
                String string = result;
                return string;
            }
            if (urlString.startsWith("https://bizapi.jd.com")) {
                String newUrl = PROXY_MAP.get("proxy");
                logger.info("###newUrl\u7f13\u5b58:" + newUrl);
                if (StringUtils.isBlank((CharSequence)newUrl)) {
                    DynamicObject config = HttpClientUtil.getEcmaDynamicObject();
                    logger.info("###config:" + config);
                    newUrl = config != null && StringUtils.isNotBlank((CharSequence)config.getString("proxy")) ? config.getString("proxy") : "https://bizapi.jd.com";
                    PROXY_MAP.put("proxy", newUrl);
                }
                urlString = urlString.replace("https://bizapi.jd.com", newUrl);
                logger.info("###urlString:" + urlString);
            }
            if (urlString.contains("oauth2/access_token")) {
                urlString = urlString.replace("oauth2/access_token", "oauth2/accessToken");
            }
            if (urlString.contains("oauth2/refresh_token")) {
                urlString = urlString.replace("oauth2/refresh_token", "oauth2/refreshToken");
            }
            URL url = new URL(urlString);
            URI uri = new URI(url.getProtocol(), null, url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
            httpPost = new HttpPost(uri);
            HttpClientUtil.setCommonHeaders((AbstractHttpMessage)httpPost);
            if (headers != null && headers.length > 0) {
                for (Map.Entry<String, String> header : headers[0].entrySet()) {
                    if (httpPost.containsHeader(header.getKey())) {
                        httpPost.setHeader(header.getKey(), header.getValue());
                        continue;
                    }
                    httpPost.addHeader(header.getKey(), header.getValue());
                }
            }
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            }
            CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
            result = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)rh);
            if (params.containsKey("token")) {
                params.put("token", AESUtil.encryptToStringNew(params.get("token")));
                logger.info("@@@\u8bbf\u95eeJD--url:" + urlString + ";param:" + params + "\r\noutput: " + result);
            }
        }
        catch (Exception e) {
            throw new EcApiException(EcApiErrorCode.SYS_ERROR, ExceptionUtil.getStackTrace(e));
        }
        finally {
            if (null != httpPost) {
                httpPost.abort();
            }
        }
        return result;
    }

    private static void setCommonHeaders(AbstractHttpMessage request) {
        request.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        request.addHeader("Accept-Language", "zh-CN,zh;q=0.8");
        request.addHeader("Accept-Encoding", "gzip, deflate, br");
        request.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36");
    }

    private static DynamicObject getEcmaDynamicObject() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        QFilter qfiter = new QFilter("tenantid", "=", (Object)enterpriseId).and(new QFilter("platform", "=", (Object)PlatformEnums.JD.getValue()));
        return QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)"proxy", (QFilter[])new QFilter[]{qfiter});
    }

    public static void clearCache() {
        PROXY_MAP.clear();
    }

    static {
        HttpClientUtil.initHttpClient();
        ConnectionMonitorThread idleConnectionMonitorThread = new ConnectionMonitorThread(httpClientConnectionManager);
        idleConnectionMonitorThread.setDaemon(true);
        idleConnectionMonitorThread.start();
    }

    public static class ConnectionMonitorThread
    extends Thread {
        private static volatile boolean shutdown = false;
        private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;

        public ConnectionMonitorThread(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
            this.poolingHttpClientConnectionManager = poolingHttpClientConnectionManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (!shutdown) {
                    Class<ConnectionMonitorThread> clazz = ConnectionMonitorThread.class;
                    // MONITORENTER : kd.scm.common.ecapi.httpsutil.HttpClientUtil$ConnectionMonitorThread.class
                    this.wait(600000L);
                    this.poolingHttpClientConnectionManager.closeExpiredConnections();
                    this.poolingHttpClientConnectionManager.closeIdleConnections(10L, TimeUnit.MINUTES);
                    // MONITOREXIT : clazz
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            shutdown = true;
            Class<ConnectionMonitorThread> clazz = ConnectionMonitorThread.class;
            synchronized (ConnectionMonitorThread.class) {
                this.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

