/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.httpsutil;

import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class MyResponseHandler
implements ResponseHandler<String> {
    private static final Log logger = LogFactory.getLog(MyResponseHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    return string;
                }
                case 400: {
                    logger.info("\u4e0b\u8f7d400\u9519\u8bef\u4ee3\u7801\uff0c\u8bf7\u6c42\u51fa\u73b0\u8bed\u6cd5\u9519\u8bef.");
                    return "";
                }
                case 403: {
                    logger.info("\u4e0b\u8f7d403\u9519\u8bef\u4ee3\u7801\uff0c\u8d44\u6e90\u4e0d\u53ef\u7528.");
                    return "";
                }
                case 404: {
                    logger.info("\u4e0b\u8f7d404\u9519\u8bef\u4ee3\u7801\uff0c\u65e0\u6cd5\u627e\u5230\u6307\u5b9a\u8d44\u6e90\u5730\u5740.");
                    return "";
                }
                case 503: {
                    logger.info("\u4e0b\u8f7d503\u9519\u8bef\u4ee3\u7801\uff0c\u670d\u52a1\u4e0d\u53ef\u7528.");
                    return "";
                }
                case 504: {
                    logger.info("\u4e0b\u8f7d504\u9519\u8bef\u4ee3\u7801\uff0c\u7f51\u5173\u8d85\u65f6.");
                    return "";
                }
                default: {
                    logger.info("\u672a\u5904\u7406\u7684\u9519\u8bef,code=" + statusCode);
                    return "";
                }
            }
        }
        finally {
            if (response != null) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u54cd\u5e94\u9519\u8bef.", (Throwable)e);
                }
            }
        }
    }
}

