/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.jd;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.httpsutil.HttpClientUtil;
import kd.scm.common.ecapi.jd.entity.JDAuthorizationToken;
import kd.scm.common.ecapi.util.EcDateUtil;
import kd.scm.common.ecapi.util.JDMD5Util;
import kd.scm.common.jd.errorcode.JDAPIErrorCode;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.OrgUtil;
import net.sf.json.JSONObject;

public class JDAccessTokenUtil {
    private static Log log = LogFactory.getLog(JDAccessTokenUtil.class);
    private static final String kingdeeTokenID = "kingdeeID";
    private static final Map<String, JDAuthorizationToken> AuthTokenMap = new HashMap<String, JDAuthorizationToken>();

    public static String getAccessTokenByOrgID(String companyOrgID, String enterpriseid) {
        JDAuthorizationToken tokenInfo = AuthTokenMap.get(RequestContext.get().getTenantId() + companyOrgID);
        if (tokenInfo == null) {
            tokenInfo = JDAccessTokenUtil.getJDAuthorizationToken(companyOrgID, enterpriseid);
            JDAccessTokenUtil.getAccessTokenByRefreshToken(tokenInfo);
            AuthTokenMap.put(RequestContext.get().getTenantId() + companyOrgID, tokenInfo);
        }
        JDAccessTokenUtil.updateTokenInfo(tokenInfo, companyOrgID);
        return tokenInfo.getAccess_token();
    }

    private static void updateTokenInfo(JDAuthorizationToken tokenInfo, String companyOrgID) {
        if (tokenInfo.getRefresh_token_timeout() == null || JDAccessTokenUtil.isTokenOutOfDate(tokenInfo)) {
            AuthTokenMap.remove(RequestContext.get().getTenantId() + companyOrgID);
            throw new KDBizException(JDAPIErrorCode.JD_REFRESHTOKEN_EXPIRE, new Object[]{tokenInfo.getCompanyName()});
        }
        if (JDAccessTokenUtil.isAccessTokenOutOfDate(tokenInfo)) {
            JDAccessTokenUtil.getAccessTokenByRefreshToken(tokenInfo);
            AuthTokenMap.put(RequestContext.get().getTenantId() + companyOrgID, tokenInfo);
        }
    }

    public static JDAuthorizationToken getJDAuthorizationToken(String companyOrgID, String enterpriseid) {
        JDAuthorizationToken tokenInfo = new JDAuthorizationToken();
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("companyOrgID-->").append(companyOrgID);
        errorMsg.append("enterpriseID-->").append(enterpriseid);
        try {
            tokenInfo = JDAccessTokenUtil.getValidTokenInfo(companyOrgID, EcPlatformEnum.ECPLATFORM_JD.getVal());
            if (StringUtils.isBlank((CharSequence)tokenInfo.getCompanyID()) && StringUtils.isBlank((CharSequence)tokenInfo.getEnterpriseID())) {
                String defaultCompanyId = JDAccessTokenUtil.getDefaultCompanyOrg(enterpriseid);
                tokenInfo = null != defaultCompanyId ? (AuthTokenMap.get(RequestContext.get().getTenantId() + JDAccessTokenUtil.getDefaultCompanyOrg(enterpriseid)) != null ? AuthTokenMap.get(RequestContext.get().getTenantId() + JDAccessTokenUtil.getDefaultCompanyOrg(enterpriseid)) : JDAccessTokenUtil.getJDAuthorizationToken(defaultCompanyId, enterpriseid)) : JDAccessTokenUtil.getDefaultAccessToken();
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw new KDBizException(JDAPIErrorCode.GET_JDTOKEN_FAILED, new Object[]{errorMsg});
            }
            throw new KDException(JDAPIErrorCode.GET_JDTOKEN_FAILED, new Object[]{"****" + errorMsg + e.getMessage()});
        }
        if (JDAccessTokenUtil.isTokenOutOfDate(tokenInfo)) {
            throw new KDBizException(JDAPIErrorCode.JD_REFRESHTOKEN_EXPIRE, new Object[]{tokenInfo.getCompanyName()});
        }
        return tokenInfo;
    }

    private static JDAuthorizationToken getValidTokenInfo(String companyOrgID, String platform) {
        JDAuthorizationToken tokenInfo = new JDAuthorizationToken();
        String tanentId = RequestContext.get().getTenantId();
        DynamicObject dynamicObject = JDAccessTokenUtil.getEcmaDynamicObject(tanentId, companyOrgID, platform);
        if (null != dynamicObject && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("entryentity.token"))) {
            tokenInfo.setCompanyID(companyOrgID);
            tokenInfo.setEnterpriseID(tanentId);
            tokenInfo.setRefresh_token(dynamicObject.getString("entryentity.token"));
            tokenInfo.setRefresh_token_timeout(dynamicObject.getDate("entryentity.uneffectualdate"));
            tokenInfo.setCompanyName(dynamicObject.getString("entryentity.companyorg.name"));
            tokenInfo.setMallAccount(dynamicObject.getString("entryentity.mallaccount"));
            tokenInfo.setMallPwd(AESUtil.decryptToStringNew(dynamicObject.getString("entryentity.mallpwd")));
        }
        return tokenInfo;
    }

    public static DynamicObject getEcmaDynamicObject(String enterpriseid, String companyOrgID, String platform) {
        String selectFields = "entryentity.mallaccount,entryentity.mallpwd,entryentity.token,entryentity.uneffectualdate,entryentity.companyorg.name";
        QFilter qfiter = new QFilter("tenantid", "=", (Object)enterpriseid).and(new QFilter("openstatus", "=", (Object)"2")).and(new QFilter("platform", "=", (Object)platform)).and(new QFilter("entryentity.companyorg", "=", (Object)Long.parseLong(companyOrgID)));
        return QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)selectFields, (QFilter[])new QFilter[]{qfiter});
    }

    public static JDAuthorizationToken getDefaultAccessToken() {
        String json = JDAccessTokenUtil.getJDTokenJSON("", "", null, "", "");
        JSONObject node = JSONObject.fromObject((Object)json);
        if (!node.optBoolean("success")) {
            throw new KDBizException(JDAPIErrorCode.GET_KDTOKEN_FAILED, new Object[]{json});
        }
        JSONObject value = node.getJSONObject("result");
        String refreshToken = value.optString("refresh_token");
        String accessToken = value.optString("access_token");
        Calendar now = Calendar.getInstance();
        now.add(5, 1);
        long expires = value.optLong("refresh_token_expires");
        Date timeOutDate = new Date(expires);
        JDAuthorizationToken tokenInfo = new JDAuthorizationToken();
        tokenInfo.setCompanyID(kingdeeTokenID);
        tokenInfo.setEnterpriseID(kingdeeTokenID);
        tokenInfo.setRefresh_token(refreshToken);
        tokenInfo.setRefresh_token_timeout(timeOutDate);
        tokenInfo.setAccess_token_timeout(now.getTime());
        tokenInfo.setAccess_token(accessToken);
        AuthTokenMap.put(RequestContext.get().getTenantId() + kingdeeTokenID, tokenInfo);
        return tokenInfo;
    }

    public static boolean isTokenOutOfDate(JDAuthorizationToken result) {
        return result.getRefresh_token_timeout() != null && result.getRefresh_token_timeout().before(Calendar.getInstance().getTime());
    }

    public static boolean isAccessTokenOutOfDate(JDAuthorizationToken result) {
        return result.getAccess_token_timeout().before(Calendar.getInstance().getTime());
    }

    public static String getAccessTokenByKD(String enterpriseID) {
        String companyid = null;
        if (StringUtils.isNotBlank((CharSequence)enterpriseID)) {
            companyid = JDAccessTokenUtil.getDefaultCompanyOrg(enterpriseID);
        }
        if (StringUtils.isNotBlank(companyid)) {
            return JDAccessTokenUtil.getAccessTokenByOrgID(companyid, enterpriseID);
        }
        JDAuthorizationToken tokenInfo = AuthTokenMap.get(RequestContext.get().getTenantId() + kingdeeTokenID);
        if (tokenInfo == null || JDAccessTokenUtil.isTokenOutOfDate(tokenInfo)) {
            tokenInfo = JDAccessTokenUtil.getDefaultAccessToken();
        }
        if (JDAccessTokenUtil.isAccessTokenOutOfDate(tokenInfo)) {
            JDAccessTokenUtil.getAccessTokenByRefreshToken(tokenInfo);
            AuthTokenMap.put(RequestContext.get().getTenantId() + kingdeeTokenID, tokenInfo);
        }
        return tokenInfo.getAccess_token();
    }

    private static String getDefaultCompanyOrg(String enterpriseID) {
        List<Long> idList = JDAccessTokenUtil.getRegisterCompanyOrgList(enterpriseID);
        return idList.size() > 0 ? String.valueOf(idList.get(0)) : null;
    }

    public static String getAccessTokenByRefreshToken(JDAuthorizationToken tokenInfo) {
        return JDAccessTokenUtil.getAccessTokenByRefreshToken(tokenInfo, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    private static void setInfoByAccessToken(JDAuthorizationToken tokenInfo, String platform) {
        String enterpriseid = tokenInfo.getEnterpriseID();
        Map<String, String> jdMap = JDAccessTokenUtil.getClient(enterpriseid, platform);
        String json = JDAccessTokenUtil.getJDTokenJSONWithPlatform(tokenInfo.getMallAccount(), tokenInfo.getMallPwd(), jdMap.get("client_id"), jdMap.get("client_secret"), platform);
        JSONObject node = JSONObject.fromObject((Object)json);
        if (!node.optBoolean("success")) {
            throw new KDBizException(JDAPIErrorCode.GET_KDTOKEN_FAILED, new Object[]{json});
        }
        JSONObject value = node.getJSONObject("result");
        String refreshToken = value.optString("refresh_token");
        String accessToken = value.optString("access_token");
        Calendar now = Calendar.getInstance();
        now.add(5, 1);
        long expires = value.optLong("refresh_token_expires");
        Date timeOutDate = new Date(expires);
        tokenInfo.setRefresh_token(refreshToken);
        tokenInfo.setRefresh_token_timeout(timeOutDate);
        tokenInfo.setAccess_token_timeout(now.getTime());
        tokenInfo.setAccess_token(accessToken);
    }

    public static String getAccessTokenByRefreshToken(String refreshToken, String enterpriseid) {
        Map<String, String> jdMap = JDAccessTokenUtil.getClient(enterpriseid);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("refresh_token", refreshToken);
        params.put("client_id", jdMap.get("client_id"));
        params.put("client_secret", jdMap.get("client_secret"));
        String json = HttpClientUtil.postForEntity("https://bizapi.jd.com/oauth2/refresh_token", params, new Map[0]);
        return JDAccessTokenUtil.getJSONObjectByKey(json, "access_token");
    }

    private static String getAccessTokenJson(String refreshToken, String enterpriseid) {
        Map<String, String> jdMap = JDAccessTokenUtil.getClient(enterpriseid);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("refresh_token", refreshToken);
        params.put("client_id", jdMap.get("client_id"));
        params.put("client_secret", jdMap.get("client_secret"));
        return HttpClientUtil.postForEntity("https://bizapi.jd.com/oauth2/refresh_token", params, new Map[0]);
    }

    public static String getJDTokenJSON(String userName, String passWord, String enterpriseid, String clientId, String secreatId) {
        return JDAccessTokenUtil.getJDTokenJSONWithPlatform(userName, passWord, clientId, secreatId, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    private static String getJDTokenJSONWithPlatform(String userName, String passWord, String clientId, String secreatId, String platform) {
        String pswd = JDMD5Util.getMD5Str(passWord);
        String grant_type = "access_token";
        String nowStr = EcDateUtil.getFormatCurrentTime();
        String tempSign = secreatId + nowStr + clientId + userName + pswd + grant_type + secreatId;
        String sign = JDMD5Util.getMD5Str(tempSign).toUpperCase();
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("grant_type", grant_type);
        params.put("client_id", clientId);
        params.put("timestamp", nowStr);
        params.put("username", userName);
        params.put("password", pswd);
        params.put("sign", sign);
        String apiServiceUrl = "https://bizapi.jd.com";
        if (EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)) {
            apiServiceUrl = "https://api-iop.jd.com";
        }
        return HttpClientUtil.postForEntity(apiServiceUrl + "/oauth2/access_token", params, new Map[0]);
    }

    private static String getJSONObjectByKey(String json, String key) {
        JSONObject node = JSONObject.fromObject((Object)json);
        if (!StringUtils.isEmpty((CharSequence)node.optString(key))) {
            return node.optString(key);
        }
        JSONObject rs = node.getJSONObject("result");
        return rs.getString(key);
    }

    public static List<Long> getRegisterCompanyOrgList(String enterpriseID) {
        return OrgUtil.getRegisterCompanyOrgList(enterpriseID);
    }

    public static Map<String, String> getClient(String enterpriseid) {
        return JDAccessTokenUtil.getClient(enterpriseid, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getClient(String enterpriseid, String platform) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (enterpriseid != null && !enterpriseid.equals(kingdeeTokenID)) {
            String selectFields = "client_id,client_secret";
            QFilter tanantFilter = new QFilter("tenantid", "=", (Object)enterpriseid);
            QFilter platformFilter = new QFilter("platform", "=", (Object)platform);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)selectFields, (QFilter[])new QFilter[]{tanantFilter.and(platformFilter)});
            if (dynamicObject == null) throw new KDBizException(JDAPIErrorCode.GET_JDTOKEN_FAILED, new Object[]{ResManager.loadKDString((String)"jdclientid\u4e3a\u7a7a", (String)"JDAccessTokenUtil_0", (String)"scm-common", (Object[])new Object[0])});
            map.put("client_secret", dynamicObject.getString("client_secret"));
            map.put("client_id", dynamicObject.getString("client_id"));
            return map;
        } else {
            map.put("client_secret", "");
            map.put("client_id", "");
        }
        return map;
    }

    public static String getJDAccessTokenWithCompany(String orgId) {
        String token = "";
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        try {
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                token = JDAccessTokenUtil.getAccessTokenByOrgID(orgId, enterpriseId);
            } else {
                Long adminOrgId = RequestContext.getOrCreate().getOrgId();
                String companyOrgId = OrgUtil.getCompanyOrgByAdminOrg(adminOrgId);
                token = JDAccessTokenUtil.getAccessTokenByOrgID(companyOrgId, enterpriseId);
            }
            log.info("\u79df\u6237ID:" + enterpriseId + ";\u8d22\u52a1\u7ec4\u7ec7:" + orgId);
        }
        catch (KDException e) {
            log.error("@@@kd.scm.common.ecapi.jd.JDAccessTokenUtil.getJDAccessTokenWithCompany \u83b7\u53d6Token\u5931\u8d25\uff0c\u4f20\u5165\u7ec4\u7ec7\uff1a" + orgId);
        }
        return token;
    }

    public static String getAccessToken() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        return JDAccessTokenUtil.getAccessTokenByKD(enterpriseId);
    }

    public static void clearCache() {
        AuthTokenMap.clear();
        HttpClientUtil.clearCache();
    }

    public static String getValidToken(String companyOrgID) {
        log.info("getValidToken.companyOrgID:" + companyOrgID);
        return JDAccessTokenUtil.getValidToken(companyOrgID, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static String getValidToken(String companyOrgID, String platform) {
        log.info("getValidToken.companyOrgID:" + companyOrgID);
        String token = "";
        int count = 0;
        String cacheKey = RequestContext.get().getTenantId() + companyOrgID;
        QFilter platformFilter = new QFilter("platform", "=", (Object)platform).and(new QFilter("openstatus", "=", (Object)"2"));
        String selectFields = "entryentity.id";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getValidToken", (String)"pmm_ecadmit", (String)selectFields, (QFilter[])new QFilter[]{platformFilter}, null);){
            count = ds.count("entryentity.id", true);
        }
        if (count > 1) {
            JDAuthorizationToken tokenInfo = AuthTokenMap.get(cacheKey);
            if (tokenInfo == null) {
                tokenInfo = JDAccessTokenUtil.getValidTokenInfo(companyOrgID, platform);
                if (StringUtils.isBlank((CharSequence)tokenInfo.getCompanyID()) || StringUtils.isBlank((CharSequence)tokenInfo.getEnterpriseID())) {
                    return token;
                }
                JDAccessTokenUtil.getAccessTokenByRefreshToken(tokenInfo, platform);
                AuthTokenMap.put(cacheKey, tokenInfo);
            }
            if (tokenInfo.getRefresh_token_timeout() == null || JDAccessTokenUtil.isTokenOutOfDate(tokenInfo)) {
                AuthTokenMap.remove(RequestContext.get().getTenantId() + companyOrgID);
                throw new KDBizException(JDAPIErrorCode.JD_REFRESHTOKEN_EXPIRE, new Object[]{tokenInfo.getCompanyName()});
            }
            if (JDAccessTokenUtil.isAccessTokenOutOfDate(tokenInfo)) {
                JDAccessTokenUtil.getAccessTokenByRefreshToken(tokenInfo, platform);
                AuthTokenMap.put(RequestContext.get().getTenantId() + companyOrgID, tokenInfo);
            }
            token = tokenInfo.getAccess_token();
        }
        return token;
    }

    private static String getAccessTokenByRefreshToken(JDAuthorizationToken tokenInfo, String platform) {
        String json = JDAccessTokenUtil.getAccessTokenJson(tokenInfo.getRefresh_token(), tokenInfo.getEnterpriseID(), platform);
        if (StringUtils.isBlank((CharSequence)json) || StringUtils.equals((CharSequence)JDAccessTokenUtil.getJSONObjectByKey(json, "success"), (CharSequence)"false")) {
            JDAccessTokenUtil.setInfoByAccessToken(tokenInfo, platform);
            return tokenInfo.getAccess_token();
        }
        String accessToken = JDAccessTokenUtil.getJSONObjectByKey(json, "access_token");
        tokenInfo.setAccess_token(accessToken);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        tokenInfo.setAccess_token_timeout(calendar.getTime());
        return accessToken;
    }

    private static String getAccessTokenJson(String refreshToken, String enterpriseid, String platform) {
        Map<String, String> jdMap = JDAccessTokenUtil.getClient(enterpriseid, platform);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("refresh_token", refreshToken);
        params.put("client_id", jdMap.get("client_id"));
        params.put("client_secret", jdMap.get("client_secret"));
        String apiServiceUrl = "https://bizapi.jd.com";
        if (EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(platform)) {
            apiServiceUrl = "https://api-iop.jd.com";
        }
        return HttpClientUtil.postForEntity(apiServiceUrl + "/oauth2/refresh_token", params, new Map[0]);
    }
}

