/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.jd;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.AbstractEcApiService;
import kd.scm.common.ecapi.EcApiContext;
import kd.scm.common.ecapi.errorcode.EcApiErrorCode;
import kd.scm.common.ecapi.errorcode.JDApiErrorCode;
import kd.scm.common.ecapi.exception.EcApiException;
import kd.scm.common.ecapi.httpsutil.HttpClientUtil;
import kd.scm.common.ecapi.jd.entity.JdApiResponse;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONObject;

public class JDApiService
extends AbstractEcApiService {
    private static Log logger = LogFactory.getLog(JDApiService.class);

    public JdApiResponse executeEcApi(EcApiContext context) {
        String result = "";
        JdApiResponse jdResponse = new JdApiResponse();
        try {
            this.checkParams(context);
            HashMap<String, String> params = new HashMap<String, String>();
            String apiUrl = context.getUrl() + context.getApi();
            params.putAll(context.getApiParam());
            params.putAll(context.getSysParam());
            result = HttpClientUtil.postForEntity(apiUrl, params, new Map[0]);
        }
        catch (Exception e) {
            logger.error("@@@kd.scm.common.ecapi.jd.JDApiService.executeEcApi\u6267\u884cAPI" + context.getUrl() + "\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace(e));
            throw new EcApiException(EcApiErrorCode.SYS_ERROR, ExceptionUtil.getStackTrace(e));
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            jdResponse = this.handleResults(result, context);
        }
        return jdResponse;
    }

    public JdApiResponse handleResults(String result, EcApiContext context) {
        JdApiResponse jdResponse = this.parseJsonToObj(result);
        if (!jdResponse.isSuccess()) {
            ErrorCode code = JDApiErrorCode.getEcApiErrorCode(context.getApi());
            throw new EcApiException(code == null ? JDApiErrorCode.INVOKE_JD_FAILED : code, jdResponse.getResultMessage());
        }
        return jdResponse;
    }

    private JdApiResponse parseJsonToObj(String resultStr) {
        JdApiResponse jdResponse = new JdApiResponse();
        JSONObject node = JSONObject.fromObject((Object)resultStr);
        jdResponse.setResponseData(resultStr);
        jdResponse.setSuccess(node.getBoolean("success"));
        String resultMessage = "";
        if (node.containsKey((Object)"resultMessage")) {
            resultMessage = node.getString("resultMessage");
        }
        String resultCode = node.getString("resultCode");
        if (!node.containsKey((Object)"result")) {
            throw new EcApiException(JDApiErrorCode.INVOKE_JD_FAILED, resultMessage);
        }
        String result = node.getString("result");
        if (StringUtils.isNotBlank((CharSequence)resultMessage)) {
            jdResponse.setResultMessage(resultMessage);
        }
        if (StringUtils.isNotBlank((CharSequence)resultMessage)) {
            jdResponse.setResultCode(resultCode);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            jdResponse.setResult(result);
        }
        return jdResponse;
    }
}

