/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.jd;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.config.EcConfigration;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.entity.SkuGoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.errorcode.EcApiErrorCode;
import kd.scm.common.ecapi.exception.EcApiException;
import kd.scm.common.ecapi.jd.JDApiService;
import kd.scm.common.ecapi.jd.JdProdUtil;
import kd.scm.common.ecapi.jd.dto.AfsServicebyCustomerPin;
import kd.scm.common.ecapi.jd.dto.AfterSaleDto;
import kd.scm.common.ecapi.jd.entity.JdApiResponse;
import kd.scm.common.ecapi.jd.entity.JdPictureInfo;
import kd.scm.common.ecapi.jd.entity.JdStockInfo;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.ecapi.jd.enums.ComponentExportEnum;
import kd.scm.common.enums.MalNoReasonToReturnEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JdApiUtil {
    private static Log logger = LogFactory.getLog(JdApiUtil.class);

    public static JdApiResponse getJdApiResponse(String jdApi, Map<String, String> params, String orgId) {
        EcConfigration ecConfig = new EcConfigration(EcPlatformEnum.ECPLATFORM_JD.getVal(), params, jdApi, orgId);
        JDApiService apiService = new JDApiService();
        return (JdApiResponse)apiService.executeEcApi(ecConfig.getContext());
    }

    public static String searchFromJd(Map<String, String> params) {
        return JdApiUtil.getJdApiResponse("/api/search/search", params, null).getResult();
    }

    public static List<GoodsInfo> searchGoodsFromJd(Map<String, String> params) {
        ArrayList<GoodsInfo> jdProductList = new ArrayList<GoodsInfo>();
        ArrayList<String> skuList = new ArrayList<String>();
        try {
            HashMap<String, PriceInfo> priceMap = new HashMap();
            JSONObject node = null;
            JSONArray skus = null;
            JSONObject sku = null;
            String resultJson = JdApiUtil.searchFromJd(params);
            node = JSONObject.fromObject((Object)resultJson);
            if (node.get("hitResult") != null && !node.get("hitResult").equals("null")) {
                skus = node.getJSONArray("hitResult");
                for (int i = 0; i < skus.size(); ++i) {
                    sku = skus.getJSONObject(i);
                    jdProductList.add(JdProdUtil.getJdProductInfo(sku));
                    skuList.add(sku.getString("wareId"));
                }
            } else {
                String keyWord = params.get("keyword");
                if (StringUtils.isNotBlank((CharSequence)keyWord) && StringUtils.isNumeric((CharSequence)keyWord)) {
                    GoodsInfo goodsInfo = JdApiUtil.getJdProdDetail(keyWord, true);
                    jdProductList.add(goodsInfo);
                    skuList.add(goodsInfo.getProductId());
                }
            }
            if (skuList.size() > 0) {
                priceMap = JdApiUtil.batchGetJdPriceMap(skuList);
                JdProdUtil.setJdProductInfoPrice(jdProductList, priceMap);
            }
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                logger.error("@@@kd.scm.common.ecapi.jd.JdApiUtil.searchGoodsFromJd--->" + ExceptionUtil.getStackTrace(e));
            }
            throw new KDException(EcApiErrorCode.SYS_ERROR, new Object[]{ExceptionUtil.getStackTrace(e)});
        }
        return jdProductList;
    }

    public static Map<String, PriceInfo> batchGetJdPriceMap(List<String> skus) {
        HashMap<String, PriceInfo> priceMap = new HashMap<String, PriceInfo>(skus.size());
        if (skus.isEmpty()) {
            return priceMap;
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        String data = String.join((CharSequence)",", skus);
        params.put("sku", data);
        params.put("containsTax", "1");
        params.put("queryExts", "marketPrice");
        String resuString = JdApiUtil.getJdApiResponse("/api/price/getSellPrice", params, null).getResult();
        logger.info("@@\u83b7\u53d6\u4eac\u4e1c\u5546\u54c1\u4ef7\u683c:" + resuString);
        String priceParm = MalOrderUtil.getDefaultPrice();
        JSONArray jsons = JSONArray.fromObject((Object)resuString);
        JSONArray jsonNode = JSONArray.fromObject((Object)jsons);
        for (JSONObject jsonObject : jsonNode) {
            PriceInfo price = new PriceInfo();
            price.setTaxPrice(JDOrderUtil.converStr2BigDecimal(jsonObject.getString("price")));
            price.setEcPrice(JDOrderUtil.converStr2BigDecimal(jsonObject.getString("jdPrice")));
            price.setTaxRate(JDOrderUtil.converStr2BigDecimal(jsonObject.getString("tax")));
            price.setTax(JDOrderUtil.converStr2BigDecimal(jsonObject.getString("taxPrice")));
            price.setPrice(JDOrderUtil.converStr2BigDecimal(jsonObject.getString("nakedPrice")));
            price.setDiscountRate(BigDecimal.ONE);
            price.setPriceParm(priceParm);
            price.setSkuId(jsonObject.getString("skuId"));
            if ("1".equalsIgnoreCase(priceParm)) {
                price.setShowprice(price.getTaxPrice());
            } else {
                price.setShowprice(price.getEcPrice());
            }
            priceMap.put(jsonObject.getString("skuId"), price);
        }
        return priceMap;
    }

    public static PriceInfo getJdPriceBySku(String sku) {
        PriceInfo priceInfo = new PriceInfo();
        if (StringUtils.isBlank((CharSequence)sku)) {
            return priceInfo;
        }
        ArrayList<String> skus = new ArrayList<String>(1);
        skus.add(sku);
        return JdApiUtil.batchGetJdPriceMap(skus).get(sku);
    }

    public static GoodsInfo getJdProdDetail(String sku, boolean isSimple) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("sku", sku);
        params.put("queryExts", "isJDLogistics");
        String detailStr = JdApiUtil.getJdApiResponse("/api/product/getDetail", params, null).getResult();
        if (isSimple) {
            JSONObject node = JSONObject.fromObject((Object)detailStr);
            return JdProdUtil.getJdProductInfo4Detail(node);
        }
        return JdProdUtil.getJdProdInfo4Detail(detailStr);
    }

    public static List<SkuGoodsInfo> getJdSimilarSku(String sku) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("skuId", sku);
        String SkuStr = JdApiUtil.getJdApiResponse("/api/product/getSimilarSku", params, null).getResult();
        return JdProdUtil.getJdInfoSimilarSku(SkuStr);
    }

    public static String getJdCatogry(String cid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cid", cid);
        return JdApiUtil.getJdApiResponse("/api/product/getCategory", params, null).getResult();
    }

    public static Map<String, JdStockInfo> batchGetJdStock(List<String> skus, String area) {
        HashMap<String, JdStockInfo> jdStockMap = new HashMap<String, JdStockInfo>();
        if (skus.isEmpty()) {
            return jdStockMap;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        String skuNums = JdProdUtil.convertList2JdJson(skus);
        params.put("skuNums", skuNums);
        params.put("area", area);
        String stockStr = JdApiUtil.getJdApiResponse("/api/stock/getNewStockById", params, null).getResult();
        JSONArray jsons = JSONArray.fromObject((Object)stockStr);
        for (Object obj : jsons) {
            JSONObject jsonObject = null;
            if (obj == null || obj.equals("null")) continue;
            jsonObject = (JSONObject)obj;
            JdStockInfo stock = new JdStockInfo();
            String state = jsonObject.getString("stockStateId");
            int remainNum = jsonObject.getInt("remainNum");
            stock.setState(state);
            if (state.equals(StockEnum.BOOK.getVal()) || state.equals(StockEnum.SOLDOUT.getVal()) || state.equals(StockEnum.SOLDOUTBOOK.getVal())) {
                stock.setDesc(StockEnum.SOLDOUT.getName());
            } else if (remainNum != -1) {
                stock.setDesc(String.valueOf(remainNum));
            } else {
                stock.setDesc(StockEnum.SALE.getName());
            }
            stock.setRemainNum(remainNum);
            jdStockMap.put(jsonObject.getString("skuId"), stock);
        }
        return jdStockMap;
    }

    public static JdStockInfo getJdStockBySku(String sku, String area) {
        JdStockInfo jdStockInfo = new JdStockInfo();
        if (StringUtils.isBlank((CharSequence)sku)) {
            return jdStockInfo;
        }
        ArrayList<String> skus = new ArrayList<String>(1);
        skus.add(sku);
        return JdApiUtil.batchGetJdStock(skus, area).get(sku);
    }

    public static Map<String, List<JdPictureInfo>> getAllPicture(List<String> skus) {
        Map<String, List<JdPictureInfo>> pictureMap = new HashMap<String, List<JdPictureInfo>>();
        if (skus.isEmpty()) {
            return pictureMap;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        String data = String.join((CharSequence)",", skus);
        params.put("sku", data);
        String picJson = JdApiUtil.getJdApiResponse("/api/product/skuImage", params, null).getResult();
        logger.info("@@picJson:" + picJson);
        pictureMap = JdApiUtil.getJSONObjectAssistImage(picJson, data);
        return pictureMap;
    }

    public static List<JdPictureInfo> getJdPictureListBySku(String sku) {
        ArrayList<JdPictureInfo> jdStockInfoList = new ArrayList<JdPictureInfo>();
        if (StringUtils.isBlank((CharSequence)sku)) {
            return jdStockInfoList;
        }
        ArrayList<String> skus = new ArrayList<String>(1);
        skus.add(sku);
        return JdApiUtil.getAllPicture(skus).get(sku);
    }

    private static Map<String, List<JdPictureInfo>> getJSONObjectAssistImage(String picJson, String skus) {
        String[] sku = skus.split(",");
        HashMap<String, List<JdPictureInfo>> pictureMap = new HashMap<String, List<JdPictureInfo>>(sku.length);
        JSONObject picJo = JSONObject.fromObject((Object)picJson);
        for (int i = 0; i < sku.length; ++i) {
            ArrayList<JdPictureInfo> pictures = new ArrayList<JdPictureInfo>();
            JSONArray jsonArray = picJo.getJSONArray(sku[i]);
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JdPictureInfo picture = new JdPictureInfo();
                JSONObject jsonObject = (JSONObject)iterator.next();
                picture.setPath(jsonObject.getString("path"));
                picture.setPrimary(jsonObject.getInt("isPrimary"));
                if (!jsonObject.getString("orderSort").equals("null")) {
                    picture.setOrderSort(jsonObject.getString("orderSort"));
                }
                pictures.add(picture);
            }
            pictureMap.put(sku[i], pictures);
        }
        return pictureMap;
    }

    public static String submitJdOrder(Map<String, String> params, String orgId) {
        return JdApiUtil.getJdApiResponse("/api/order/submit", params, orgId).getResponseData();
    }

    public static boolean confirmJdOrder(String jdOrderId, String orgId) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("jdOrderId", jdOrderId);
        String result = JdApiUtil.getJdApiResponse("/api/order/confirmOrder", params, orgId).getResult();
        logger.info("@@\u786e\u8ba4JD\u8ba2\u5355:" + result);
        JSONObject node = JSONObject.fromObject((Object)result);
        return node.isNullObject() && !node.isEmpty();
    }

    public static String getSelectJdOrder(String jdOrderId) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("jdOrderId", jdOrderId);
        String result = JdApiUtil.getJdApiResponse("/api/order/selectJdOrder", params, null).getResult();
        logger.info("@@\u83b7\u53d6JD\u8ba2\u5355\u8be6\u60c5:" + result);
        return result;
    }

    public static Map<String, String> getJdChildOrderIdMap(String jdOrderID) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String json = JdApiUtil.getSelectJdOrder(jdOrderID);
        logger.info("@@\u6839\u636e\u4eac\u4e1c\u8ba2\u5355\u83b7\u53d6\u5b50\u8ba2\u5355ID:" + json);
        JSONObject node = JSONObject.fromObject((Object)json);
        JSONArray corders = null;
        JSONArray skus = null;
        JSONObject corder = null;
        if (node.get("cOrder") != null && !node.get("cOrder").equals("null")) {
            resultMap.put("isHasChildOrder", String.valueOf(true));
            corders = node.getJSONArray("cOrder");
            int size = corders.size();
            for (int i = 0; i < size; ++i) {
                corder = corders.getJSONObject(i);
                skus = corder.getJSONArray("sku");
                String childJdOrderId = corder.optString("jdOrderId");
                for (int j = 0; j < skus.size(); ++j) {
                    String skuId = skus.getJSONObject(j).optString("skuId");
                    resultMap.put(skuId, childJdOrderId);
                }
            }
        } else {
            resultMap.put("isHasChildOrder", String.valueOf(false));
        }
        return resultMap;
    }

    public static List<String> getCanceldJdOrderList(List<String> jdOrderList) {
        ArrayList<String> cancelOrderList = new ArrayList<String>();
        jdOrderList.forEach(jdOrderID -> {
            String json = JdApiUtil.getSelectJdOrder(jdOrderID);
            JSONObject node = JSONObject.fromObject((Object)json);
            int orderState = node.getInt("orderState");
            if (orderState == 0) {
                cancelOrderList.add((String)jdOrderID);
            }
        });
        return cancelOrderList;
    }

    public static boolean checkJdOrderStatus(String jdOrderID) {
        ArrayList<String> jdOrderList = new ArrayList<String>(1);
        jdOrderList.add(jdOrderID);
        return JdApiUtil.getCanceldJdOrderList(jdOrderList).size() == 0;
    }

    public static BigDecimal getFreight(Map<String, Integer> skuNumMap, String[] area, String paymentType) {
        if (skuNumMap.isEmpty() || area.length != 4) {
            return BigDecimal.ZERO.setScale(2);
        }
        String tempSku = JdProdUtil.convertMap2JdJson(skuNumMap);
        HashMap<String, String> params = new HashMap<String, String>(20);
        params.put("sku", tempSku);
        params.put("province", area[0]);
        params.put("city", area[1]);
        params.put("county", area[2]);
        params.put("town", area[3]);
        params.put("paymentType", paymentType);
        String resultJson = JdApiUtil.getJdApiResponse("/api/order/getFreight", params, null).getResult();
        logger.info("@@\u83b7\u53d6\u5f53\u524d\u4e0b\u5355\u5546\u54c1\u9700\u8981\u7684\u8fd0\u8d39:" + resultJson);
        JSONObject node = JSONObject.fromObject((Object)resultJson);
        String freightstr = String.valueOf(node.get("freight"));
        return CommonUtil.getBigDecimalPro(freightstr);
    }

    public static String getJdAddressProvince() {
        return JdApiUtil.getJdApiResponse("/api/area/getProvince", null, null).getResult();
    }

    private static Map<String, String> getAddressParam(String id) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("ID", id);
        return params;
    }

    public static String getJdAddressCity(String id) {
        return JdApiUtil.getJdApiResponse("/api/area/getCity", JdApiUtil.getAddressParam(id), null).getResult();
    }

    public static String getJdAddressCounty(String id) {
        return JdApiUtil.getJdApiResponse("/api/area/getCounty", JdApiUtil.getAddressParam(id), null).getResult();
    }

    public static String getAddressTown(String id) {
        return JdApiUtil.getJdApiResponse("/api/area/getTown", JdApiUtil.getAddressParam(id), null).getResult();
    }

    public static String getAddressJonString(String adress) {
        if (adress.isEmpty()) {
            return "";
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("address", adress);
        logger.info("@@\u6839\u636e\u5730\u5740\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u53c2\u6570\uff1a" + params);
        String addrJson = JdApiUtil.getJdApiResponse("/api/area/getJDAddressFromAddress", params, null).getResult();
        logger.info("@@\u6839\u636e\u5730\u5740\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u7f16\u7801:" + addrJson);
        return addrJson;
    }

    public static String getAddressByLngLat(double lng, double lat) {
        String[] data = JdProdUtil.adjustLngAndLat(lng, lat);
        HashMap<String, String> params = new HashMap<String, String>(20);
        params.put("lng", data[0]);
        params.put("lat", data[1]);
        String addrJson = JdApiUtil.getJdApiResponse("/api/area/getJDAddressFromLatLng", params, null).getResult();
        logger.info("@@\u6839\u636e\u7ecf\u7eac\u5ea6\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u7f16\u7801\u8fd4\u56de\uff1a" + addrJson);
        return addrJson;
    }

    public static Map<String, String> getSkuStateMap(List<String> skus) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (skus.isEmpty()) {
            return resultMap;
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        String data = String.join((CharSequence)",", skus);
        params.put("sku", data);
        String str = JdApiUtil.getJdApiResponse("/api/product/skuState", params, null).getResult();
        logger.info("@@\u6279\u91cf\u83b7\u53d6\u5546\u54c1\u7684\u4e0a\u4e0b\u67b6\u72b6\u6001 \uff1a" + str);
        JSONArray jsons = JSONArray.fromObject((Object)str);
        for (JSONObject jsonObject : jsons) {
            String state = jsonObject.getString("state");
            String sku = jsonObject.getString("sku");
            resultMap.put(sku, state);
        }
        return resultMap;
    }

    public static JdApiResponse createAfsApply(AfterSaleDto afterSaleDto, String orgId) {
        if (afterSaleDto == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param", afterSaleDto.toString());
        logger.info("@@\u552e\u540e\u7533\u8bf7\u5355\u7533\u8bf7\u53c2\u6570afterSaleDto:" + afterSaleDto.toString());
        JdApiResponse rs = JdApiUtil.getJdApiResponse("/api/afterSale/createAfsApply", params, orgId);
        logger.info("@@\u552e\u540e\u7533\u8bf7\u5355\u7533\u8bf7\u8fd4\u56de\u7ed3\u679c:" + rs);
        return rs;
    }

    public static BigDecimal getAvailableNumberComp(String jdCOrderId, String skuId, String orgId) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"jdOrderId\":").append(jdCOrderId).append(",\"skuId\":").append(skuId).append('}');
        String param = sb.toString();
        params.put("param", param);
        logger.info("10.3 \u6821\u9a8c\u67d0\u8ba2\u5355\u4e2d\u67d0\u5546\u54c1\u662f\u5426\u53ef\u4ee5\u63d0\u4ea4\u552e\u540e\u670d\u52a1param:" + param);
        JdApiResponse response = null;
        try {
            response = JdApiUtil.getJdApiResponse("/api/afterSale/getAvailableNumberComp", params, orgId);
            logger.info("10.3 \u6821\u9a8c\u67d0\u8ba2\u5355\u4e2d\u67d0\u5546\u54c1\u662f\u5426\u53ef\u4ee5\u63d0\u4ea4\u552e\u540e\u670d\u52a1result:" + response.getResult());
            BigDecimal canReturnQty = BigDecimal.ZERO;
            if (response.isSuccess()) {
                canReturnQty = new BigDecimal(response.getResult());
            }
            return canReturnQty;
        }
        catch (Exception e) {
            logger.error("10.3 \u6821\u9a8c\u67d0\u8ba2\u5355\u4e2d\u67d0\u5546\u54c1\u662f\u5426\u53ef\u4ee5\u63d0\u4ea4\u552e\u540e\u670d\u52a1param:" + param + "\r\nres:" + response + ResManager.loadKDString((String)"\r\n\u9519\u8bef\u5806\u6808\u4fe1\u606f:", (String)"JdApiUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<AfterSaleServiceTypeEnum> getCustomerExpectComp(String jdCOrderId, String skuId, String orgId) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"jdOrderId\":").append(jdCOrderId).append(",\"skuId\":").append(skuId).append('}');
        String param = sb.toString();
        params.put("param", param);
        logger.info("10.4 \u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578bparam:" + param);
        JdApiResponse response = null;
        try {
            response = JdApiUtil.getJdApiResponse("/api/afterSale/getCustomerExpectComp", params, orgId);
            logger.info("10.4 \u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578bres:" + response);
            if (StringUtils.isBlank((CharSequence)response.getResult())) {
                logger.info("10.4 \u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578bparam:" + param + "\r\nres:" + response);
                return new ArrayList<AfterSaleServiceTypeEnum>();
            }
            JSONArray ja = JSONArray.fromObject((Object)response.getResult());
            return ja.stream().map(jo -> AfterSaleServiceTypeEnum.fromVal(((JSONObject)jo).getInt("code"))).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("10.4 \u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578bparam:" + param + "\r\nres;" + response + ResManager.loadKDString((String)"\r\n\u9519\u8bef\u5806\u6808\u4fe1\u606f:", (String)"JdApiUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578b\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JdApiUtil_1", (String)"scm-common", (Object[])new Object[0]));
        }
    }

    public static List<ComponentExportEnum> getWareReturnJdComp(String jdCOrderId, String skuId, String orgId) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"jdOrderId\":").append(jdCOrderId).append(",\"skuId\":").append(skuId).append('}');
        String param = sb.toString();
        params.put("param", param);
        logger.info("10.5 \u5546\u54c1\u8fd4\u56de\u4eac\u4e1c\u65b9\u5f0fparam:" + param);
        JdApiResponse response = null;
        try {
            response = JdApiUtil.getJdApiResponse("/api/afterSale/getWareReturnJdComp", params, orgId);
            logger.info("10.5 \u5546\u54c1\u8fd4\u56de\u4eac\u4e1c\u65b9\u5f0fres:" + response);
            JSONArray ja = JSONArray.fromObject((Object)response.getResult());
            return ja.stream().map(jo -> ComponentExportEnum.fromVal(((JSONObject)jo).getInt("code"))).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("10.5 \u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u5546\u54c1\u8fd4\u56de\u4eac\u4e1c\u65b9\u5f0fparam:" + param + "\r\nres:" + response + ResManager.loadKDString((String)"\r\n\u9519\u8bef\u5806\u6808\u4fe1\u606f:", (String)"JdApiUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u8ba2\u5355\u53f7\u3001\u5546\u54c1\u7f16\u53f7\u67e5\u8be2\u652f\u6301\u7684\u5546\u54c1\u8fd4\u56de\u4eac\u4e1c\u65b9\u5f0f\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JdApiUtil_2", (String)"scm-common", (Object[])new Object[0]));
        }
    }

    public static List<AfsServicebyCustomerPin> getServiceListPage(String jdCOrderId, String pageIndex, String pageSize, String orgId) {
        ArrayList<AfsServicebyCustomerPin> afsSerList = new ArrayList<AfsServicebyCustomerPin>();
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"jdOrderId\":").append(jdCOrderId).append(",\"pageIndex\":").append(pageIndex).append(",\"pageSize\":").append(pageSize).append('}');
        String param = sb.toString();
        logger.info("@@\u67e5\u8be2\u53c2\u6570\uff1a" + param);
        params.put("param", param);
        JdApiResponse response = null;
        try {
            response = JdApiUtil.getJdApiResponse("/api/afterSale/getServiceListPage", params, orgId);
            logger.info("@@10.6 \u6839\u636e\u5ba2\u6237\u8d26\u53f7\u548c\u8ba2\u5355\u53f7\u5206\u9875\u67e5\u8be2\u670d\u52a1\u5355\u6982\u8981\u4fe1\u606f:" + response);
            JSONObject jo = JSONObject.fromObject((Object)response.getResult());
            JSONArray ja = jo.getJSONArray("serviceInfoList");
            for (int i = ja.size() - 1; i >= 0; --i) {
                Object object = ja.get(i);
                if (object == null) continue;
                AfsServicebyCustomerPin afsServicebyCustomerPin = new AfsServicebyCustomerPin();
                JSONObject jsonObject = JSONObject.fromObject((Object)object);
                afsServicebyCustomerPin.setAfsApplyTime(jsonObject.getString("afsApplyTime"));
                afsServicebyCustomerPin.setAfsServiceId(jsonObject.getInt("afsServiceId"));
                afsServicebyCustomerPin.setAfsServiceStep(jsonObject.getInt("afsServiceStep"));
                afsServicebyCustomerPin.setAfsServiceStepName(jsonObject.getString("afsServiceStepName"));
                afsServicebyCustomerPin.setCancel(jsonObject.getInt("cancel"));
                afsServicebyCustomerPin.setCustomerExpect(jsonObject.getInt("customerExpect"));
                afsServicebyCustomerPin.setCustomerExpectName(jsonObject.getString("customerExpectName"));
                afsServicebyCustomerPin.setOrderId(jsonObject.getLong("orderId"));
                afsServicebyCustomerPin.setWareId(jsonObject.getLong("wareId"));
                afsServicebyCustomerPin.setWareName(jsonObject.getString("wareName"));
                afsSerList.add(afsServicebyCustomerPin);
            }
            return afsSerList;
        }
        catch (Exception e) {
            logger.error("10.6 \u6839\u636e\u5ba2\u6237\u8d26\u53f7\u548c\u8ba2\u5355\u53f7\u5206\u9875\u67e5\u8be2\u670d\u52a1\u5355\u6982\u8981\u4fe1\u606fparam:" + param + "\r\nres:" + response + ResManager.loadKDString((String)"\r\n\u9519\u8bef\u5806\u6808\u4fe1\u606f:", (String)"JdApiUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5ba2\u6237\u8d26\u53f7\u548c\u8ba2\u5355\u53f7\u5206\u9875\u67e5\u8be2\u670d\u52a1\u5355\u6982\u8981\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JdApiUtil_3", (String)"scm-common", (Object[])new Object[0]));
        }
    }

    public static JSONObject getServiceDetailInfo(String afsServiceId, JSONArray appendInfoSteps) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"afsServiceId\":").append(afsServiceId).append(",\"appendInfoSteps\":").append(appendInfoSteps).append('}');
        String param = sb.toString();
        logger.info("@@10.7 \u6839\u636e\u670d\u52a1\u5355\u53f7\u67e5\u8be2\u670d\u52a1\u5355\u660e\u7ec6\u4fe1\u606f\u67e5\u8be2\u53c2\u6570\uff1a" + param);
        JdApiResponse response = null;
        params.put("param", param);
        try {
            response = JdApiUtil.getJdApiResponse("/api/afterSale/getServiceDetailInfo", params, null);
            logger.info("@@10.7 \u6839\u636e\u670d\u52a1\u5355\u53f7\u67e5\u8be2\u670d\u52a1\u5355\u660e\u7ec6\u4fe1\u606f:" + response);
            JSONObject jo = JSONObject.fromObject((Object)response.getResult());
            return jo;
        }
        catch (Exception e) {
            logger.error("10.7 \u6839\u636e\u670d\u52a1\u5355\u53f7\u67e5\u8be2\u670d\u52a1\u5355\u660e\u7ec6\u4fe1\u606fparam:" + param + "\r\nres:" + response + ResManager.loadKDString((String)"\r\n\u9519\u8bef\u5806\u6808\u4fe1\u606f:", (String)"JdApiUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u670d\u52a1\u5355\u53f7\u67e5\u8be2\u670d\u52a1\u5355\u660e\u7ec6\u4fe1\u606f\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JdApiUtil_4", (String)"scm-common", (Object[])new Object[0]));
        }
    }

    public static String auditCancel(List<Long> serviceIdList, String approveNotes, String orgId) {
        HashMap<String, String> params = new HashMap<String, String>();
        serviceIdList.removeIf(serviceId -> serviceId == 0L);
        if (serviceIdList.isEmpty()) {
            logger.info("\u6ca1\u6709\u6709\u6548\u670d\u52a1\u5355");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"serviceIdList\":").append(JSONArray.fromObject(serviceIdList)).append(",\"approveNotes\":\"").append(approveNotes).append("\"}");
        String param = sb.toString();
        logger.info("@@\u53d6\u6d88\u670d\u52a1\u5355/\u5ba2\u6237\u653e\u5f03param:" + param);
        params.put("param", param);
        JdApiResponse response = null;
        try {
            response = JdApiUtil.getJdApiResponse("/api/afterSale/auditCancel", params, orgId);
            if (!response.isSuccess()) {
                logger.info("@@\u53d6\u6d88\u670d\u52a1\u5355/\u5ba2\u6237\u653e\u5f03param:" + param + "\r\nres:" + response);
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4eac\u4e1c\u670d\u52a1\u5355\u5931\u8d25\u3002", (String)"JdApiUtil_5", (String)"scm-common", (Object[])new Object[0]) + response.getResultMessage());
            }
            logger.info("@@\u53d6\u6d88\u670d\u52a1\u5355/\u5ba2\u6237\u653e\u5f03result" + response);
            return response.getResult();
        }
        catch (Exception e) {
            logger.error("@@\u53d6\u6d88\u670d\u52a1\u5355/\u5ba2\u6237\u653e\u5f03param:" + param + "\r\nres:" + response + ResManager.loadKDString((String)"\r\n\u9519\u8bef\u5806\u6808\u4fe1\u606f:", (String)"JdApiUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u670d\u52a1\u5355/\u5ba2\u6237\u653e\u5f03\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JdApiUtil_6", (String)"scm-common", (Object[])new Object[0]) + response);
        }
    }

    public static JSONArray getOrderTrack(String jdOrderId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jdOrderId", jdOrderId);
        JdApiResponse response = JdApiUtil.getJdApiResponse("/api/order/orderTrack", params, null);
        logger.info("7.15 \u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3res:" + response);
        JSONObject jo = JSONObject.fromObject((Object)response.getResult());
        return jo.getJSONArray("orderTrack");
    }

    public static JSONArray queryDeliveryNo(String jdOrderId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jdOrderId", jdOrderId);
        logger.info("11.8 \u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u7968\u7269\u6d41\u4fe1\u606fparam:" + params);
        JdApiResponse response = JdApiUtil.getJdApiResponse("/api/invoice/queryDeliveryNo", params, null);
        logger.info("11.8 \u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u7968\u7269\u6d41\u4fe1\u606fres:" + response);
        JSONArray ja = JSONArray.fromObject((Object)response.getResult());
        return ja;
    }

    public static String selectRemittanceCode(int payMethod, int cardType, String businessId, int mergeType, int payChannelType, String phone, int virtualType, BigDecimal amount) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("payMethod", String.valueOf(payMethod));
        params.put("cardType", String.valueOf(cardType));
        params.put("businessId", businessId);
        params.put("mergeType", String.valueOf(mergeType));
        params.put("payChannelType", String.valueOf(payChannelType));
        params.put("phone", phone);
        params.put("virtualType", String.valueOf(virtualType));
        params.put("amount", String.valueOf(amount));
        logger.info("12.5 \u83b7\u53d6\u6c47\u6b3e\u8bc6\u522b\u7801\u53c2\u6570:" + JSONObject.fromObject(params));
        try {
            JdApiResponse response = JdApiUtil.getJdApiResponse("/api/price/selectRemittanceCode", params, null);
            logger.info("12.5 \u83b7\u53d6\u6c47\u6b3e\u8bc6\u522b\u7801res:" + response);
            JSONObject jo = JSONObject.fromObject((Object)response.getResult());
            if (jo.containsKey((Object)"httpURL")) {
                return jo.getString("httpURL");
            }
        }
        catch (EcApiException e) {
            logger.info("12.5 \u83b7\u53d6\u6c47\u6b3e\u8bc6\u522b\u7801\u5931\u8d25\uff0c" + ExceptionUtil.getStackTrace((Throwable)((Object)e)));
        }
        return "";
    }

    public static String getPromiseTips(String skuId, String province, String city, String county, String town) {
        HashMap<String, String> params = new HashMap<String, String>(1024);
        params.put("skuId", skuId);
        params.put("num", "1");
        params.put("province", String.valueOf(province));
        params.put("city", String.valueOf(city));
        params.put("county", String.valueOf(county));
        params.put("town", String.valueOf(town));
        logger.info("7.15 \u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u53c2\u6570:" + JSONObject.fromObject(params));
        try {
            JdApiResponse response = JdApiUtil.getJdApiResponse("/api/order/getPromiseTips", params, null);
            logger.info("7.15 \u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4res:" + response);
            if (response.getResult() != null) {
                return response.getResult();
            }
        }
        catch (EcApiException e) {
            logger.error("7.15 \u67e5\u8be2\u914d\u9001\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff0c" + ExceptionUtil.getStackTrace((Throwable)((Object)e)));
        }
        return "";
    }

    public static Map<String, String> getNoReasonToReturnType(String skuIds) {
        HashMap<String, String> resultMap = new HashMap<String, String>(1024);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("skuIds", skuIds);
        params.put("queryExts", "noReasonToReturn");
        logger.info("4.6 \u9a8c\u8bc1\u5546\u54c1\u53ef\u552e\u6027-\u65e0\u7406\u7531\u9000\u8d27\u7c7b\u578b" + JSONObject.fromObject(params));
        try {
            String result = JdApiUtil.getJdApiResponse("/api/product/check", params, null).getResult();
            logger.info("4.6 \u9a8c\u8bc1\u5546\u54c1\u53ef\u552e\u6027-\u65e0\u7406\u7531\u9000\u8d27\u7c7b\u578bres:" + result);
            if (result != null) {
                JSONArray jsonArr = JSONArray.fromObject((Object)result);
                for (JSONObject jsonObject : jsonArr) {
                    String sku = jsonObject.getString("skuId");
                    String noReasonToReturn = jsonObject.getString("noReasonToReturn");
                    resultMap.put(sku, MalNoReasonToReturnEnum.fromVal(noReasonToReturn).getName());
                }
            }
        }
        catch (EcApiException e) {
            logger.error("4.6 \u9a8c\u8bc1\u5546\u54c1\u53ef\u552e\u6027-\u65e0\u7406\u7531\u9000\u8d27\u7c7b\u578b\u67e5\u8be2\u5931\u8d25\uff0c" + ExceptionUtil.getStackTrace((Throwable)((Object)e)));
        }
        return resultMap;
    }

    public static Map<String, String> getMessage(String type) {
        HashMap<String, String> resultMap = new HashMap<String, String>(1024);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("type", type);
        logger.info("\u6d88\u606fType\u7c7b\u578b\uff1a" + type);
        try {
            String result = JdApiUtil.getJdApiResponse("/api/message/get", params, null).getResult();
            if (StringUtils.isNotBlank((CharSequence)result)) {
                JSONArray jsonArr = JSONArray.fromObject((Object)result);
                for (JSONObject jsonObject : jsonArr) {
                    String id = jsonObject.getString("id");
                    String info = jsonObject.getString("result");
                    resultMap.put(id, info);
                }
            }
        }
        catch (Exception e) {
            logger.info("\u672c\u6b21\u6d88\u8d39\u6d88\u606f\u5f02\u5e38\uff1a" + ExceptionUtil.getStackTrace(e));
        }
        logger.info("\u672c\u6b21\u66f4\u65b0\u7684\u4fe1\u606f\uff1a" + resultMap);
        return resultMap;
    }

    public static boolean delMessage(String idStr) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("id", idStr);
        logger.info("\u672c\u6b21\u5220\u9664\u7684\u4fe1\u606f\u53c2\u6570\uff1a" + idStr);
        String result = JdApiUtil.getJdApiResponse("/api/message/del", params, null).getResult();
        logger.info("\u672c\u6b21\u5220\u9664\u7684\u4fe1\u606f\u7ed3\u679c\uff1a" + result);
        return StringUtils.isNotBlank((CharSequence)result) && StringUtils.equals((CharSequence)"true", (CharSequence)result);
    }
}

