/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;

public class EcDateUtil {
    private static final Map<String, DateTimeFormatter> DTFMAP = new ConcurrentHashMap<String, DateTimeFormatter>();
    public static final String DATE_FORMAT_YYYY = "yyyy";
    public static final String DATE_FORMAT_YYYYMM = "yyyyMM";
    public static final String DATE_FORMAT_YYYY_MM = "yyyy-MM";
    public static final String DATE_FORMAT_YYMMDD = "yyMMdd";
    public static final String DATE_FORMAT_YY_MM_DD = "yy-MM-dd";
    public static final String DATE_FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATE_FORMAT_POINTYYYYMMDD = "yyyy.MM.dd";
    public static final String DATE_TIME_FORMAT_YYYY\u5e74MM\u6708DD\u65e5 = EcDateUtil.getMsgInvoice();
    public static final String DATE_FORMAT_YYYYMMDDHHmm = "yyyyMMddHHmm";
    public static final String DATE_TIME_FORMAT_YYYYMMDD_HH_MI = "yyyyMMdd HH:mm";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI = "yyyy-MM-dd HH:mm";
    public static final String DATE_TIME_FORMAT_YYYYMMDDHHMISS = "yyyyMMddHHmmss";
    public static final String DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_FORMAT_YYYYMMDDHHMISSSSS = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT_MMDDHHMI = "MM-dd HH:mm";

    private static String getMsgInvoice() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"EcDateUtil_0", (String)"scm-common", (Object[])new Object[0]);
    }

    public static String getFormatCurrentTime() {
        return EcDateUtil.format(LocalDateTime.now(ZoneId.systemDefault()), DATE_TIME_FORMAT_YYYY_MM_DD_HH_MI_SS);
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter newDtf;
        DateTimeFormatter dtf = DTFMAP.get(pattern);
        if (dtf == null && (dtf = DTFMAP.putIfAbsent(pattern, newDtf = DateTimeFormatter.ofPattern(pattern))) == null) {
            dtf = newDtf;
        }
        return dtf;
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(EcDateUtil.getDateTimeFormatter(pattern));
    }

    public static LocalDateTime parse(String timeString, String pattern) {
        return LocalDateTime.parse(timeString, EcDateUtil.getDateTimeFormatter(pattern));
    }
}

