/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.util;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.util.InvoiceTypeUtil;
import kd.scm.common.ecapi.util.PayTypeUtil;

public class EmalParamsUtil {
    private static final String PMM_ECADMIT = "pmm_ecadmit";
    private static final QFilter defaultFilter = new QFilter("openstatus", "=", (Object)"2").and(new QFilter("enable", "=", (Object)"1"));

    public static List<String> getOpenedEmalNumberList() {
        QFilter filter = new QFilter("openstatus", "=", (Object)"2");
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)PMM_ECADMIT, (String)"platform", (QFilter[])new QFilter[]{filter.and(new QFilter("enable", "=", (Object)"1"))});
        if (dyos.isEmpty()) {
            return null;
        }
        return dyos.stream().map(item -> item.getString("platform")).collect(Collectors.toList());
    }

    public static String getInvoiceTypeNumber(String emalType) {
        QFilter filter = new QFilter("platform", "=", (Object)emalType);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)PMM_ECADMIT, (String)"invoicetype.bdinvoicetype.number", (QFilter[])new QFilter[]{filter, defaultFilter});
        if (dyo == null) {
            return "";
        }
        return dyo.getString("invoicetype.bdinvoicetype.number");
    }

    public static String getBdInvoiceTypeId(String emalType) {
        QFilter filter = new QFilter("platform", "=", (Object)emalType);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)PMM_ECADMIT, (String)"invoicetype.bdinvoicetype.id", (QFilter[])new QFilter[]{filter, defaultFilter});
        if (dyo == null) {
            return "0";
        }
        return dyo.getString("invoicetype.bdinvoicetype.id");
    }

    public static Long getInvoiceTypeId(String emalType) {
        QFilter filter = new QFilter("platform", "=", (Object)emalType);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)PMM_ECADMIT, (String)"invoicetype.id", (QFilter[])new QFilter[]{filter, defaultFilter});
        if (dyo == null) {
            return 0L;
        }
        return dyo.getLong("invoicetype.id");
    }

    public static String getPayTypeNumber(String emalType) {
        QFilter filter = new QFilter("platform", "=", (Object)emalType);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)PMM_ECADMIT, (String)"paytype.number", (QFilter[])new QFilter[]{filter, defaultFilter});
        if (dyo == null) {
            return "";
        }
        return dyo.getString("paytype.number");
    }

    public static Long getPayTypeId(String emalType) {
        QFilter filter = new QFilter("platform", "=", (Object)emalType);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)PMM_ECADMIT, (String)"paytype.id", (QFilter[])new QFilter[]{filter, defaultFilter});
        if (dyo == null) {
            return 0L;
        }
        return dyo.getLong("paytype.id");
    }

    public static String getEmalPayTypeNumber(String emalType) {
        return PayTypeUtil.getNumber(EmalParamsUtil.getPayTypeNumber(emalType), emalType);
    }

    public static String getEmalInvoiceNumber(String emalType) {
        QFilter filter = new QFilter("platform", "=", (Object)emalType);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)PMM_ECADMIT, (String)"invoicetype.number", (QFilter[])new QFilter[]{filter, defaultFilter});
        if (dyo == null) {
            return "";
        }
        String number = dyo.getString("invoicetype.number");
        return InvoiceTypeUtil.getNumber(number, emalType);
    }
}

