/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class JDMD5Util {
    private static Log log = LogFactory.getLog(JDMD5Util.class);

    public static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static byte[] md5(byte[] data) {
        return JDMD5Util.getDigest().digest(data);
    }

    public static byte[] md5(String data) {
        return JDMD5Util.md5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5Hex(byte[] data) {
        return JDMD5Util.toHexString(JDMD5Util.md5(data));
    }

    public static String md5Hex(String data) {
        return JDMD5Util.toHexString(JDMD5Util.md5(data));
    }

    public static String getMD5Str(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("NoSuchAlgorithmException caught!");
            System.exit(-1);
        }
        byte[] byteArray = messageDigest.digest(str.getBytes(StandardCharsets.UTF_8));
        StringBuilder md5StrBuff = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            String formatStr = String.format("%02X", byteArray[i]);
            if (formatStr.length() == 1) {
                md5StrBuff.append('0').append(formatStr);
                continue;
            }
            md5StrBuff.append(formatStr);
        }
        return md5StrBuff.toString();
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append("0123456789abcdef".charAt(b[i] >>> 4 & 0xF));
            sb.append("0123456789abcdef".charAt(b[i] & 0xF));
        }
        return sb.toString();
    }
}

