/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.eip.IEipApiService;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.eip.errorcode.EipErrorCode;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DataTransterLogUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import net.sf.json.JSONObject;

public abstract class EipApiService
implements IEipApiService {
    private static Log log = LogFactory.getLog(EipApiService.class);
    private IAppCache cache = AppCache.get((String)"scm");
    private static final int TOKEN_EXPIRED_TIME_HOUR = 0;
    private static final int TOKEN_EXPIRED_TIME_MINUTE = 3;
    private static ThreadLocal<String> URL = new ThreadLocal();
    private static ThreadLocal<DynamicObject> logInfo = new ThreadLocal();
    private Map<String, Object> param = null;

    @Override
    public String process(Map<String, Object> param) {
        this.param = param;
        String data = null;
        String exceptionStr = null;
        try {
            if (EipConfigration.isISLOG()) {
                DynamicObject log = DataTransterLogUtil.logInputData(EipConfigration.getAPICONFIGID(), this.getInterfaceId(), this.getInterfaceId(), param);
                logInfo.set(log);
            }
            this.checkParams();
            ApiResult result = this.invokeApi(this.getRequestContext());
            data = this.handleResult(result);
        }
        catch (Exception e) {
            try {
                exceptionStr = ExceptionUtil.getStackTrace(e);
                throw e;
            }
            catch (Throwable throwable) {
                if (EipConfigration.isISLOG()) {
                    if (exceptionStr == null) {
                        DataTransterLogUtil.logOutputData(logInfo.get(), data);
                    } else {
                        DataTransterLogUtil.logOutputData(logInfo.get(), exceptionStr);
                    }
                }
                throw throwable;
            }
        }
        if (EipConfigration.isISLOG()) {
            if (exceptionStr == null) {
                DataTransterLogUtil.logOutputData(logInfo.get(), data);
            } else {
                DataTransterLogUtil.logOutputData(logInfo.get(), exceptionStr);
            }
        }
        return data;
    }

    protected ApiRequest getRequestContext() {
        String method = this.getMethod();
        String url = this.getUrl();
        URL.set(url);
        ApiRequest request = new ApiRequest(method, url);
        request.addHeader("referer", request.getUrl());
        if ("post".equals(method)) {
            request.setPostData(this.param);
        }
        if (!"login".equals(this.getInterfaceId())) {
            // empty if block
        }
        return request;
    }

    protected String getUrl() {
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(EipConfigration.getHOST()).append(':').append(EipConfigration.getPORT()).append("/easportal/eip/webAPI");
        StringBuilder urlSufix = new StringBuilder();
        if ("login".equals(this.getInterfaceId())) {
            urlSufix.append('/').append(this.getInterfaceId()).append("?user=").append(this.getUser()).append("&password=").append(this.getPassword()).append("&dcName=").append(this.encodeString(EipConfigration.getAIS())).append("&language=").append(EipConfigration.getLANGUAGE());
        } else if ("get".equals(this.getMethod())) {
            urlSufix.append("/dataService/").append(this.getInterfaceId()).append("?license=").append(EipConfigration.getLICENSE()).append("&AIS=").append(this.encodeString(EipConfigration.getAIS())).append("&data=").append(this.getData()).append("&token=").append(this.getToken());
        } else if ("post".equals(this.getMethod())) {
            urlSufix.append("/dataService/").append(this.getInterfaceId()).append("?license=").append(EipConfigration.getLICENSE()).append("&AIS=").append(this.encodeString(EipConfigration.getAIS())).append("&token=").append(this.getToken());
        }
        return urlSb.append((CharSequence)urlSufix).toString();
    }

    protected String getMethod() {
        return "post";
    }

    protected String getInterfaceId() {
        return null;
    }

    protected String getData() {
        String data = "{}";
        if (this.param != null && !this.param.isEmpty()) {
            data = com.alibaba.fastjson.JSONObject.toJSONString(this.param);
        }
        return this.encodeString(data);
    }

    protected String encodeString(String str) {
        String encodeStr = null;
        try {
            encodeStr = URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error((Throwable)e);
        }
        return encodeStr;
    }

    protected void checkParams() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String handleResult(ApiResult result) {
        String msg = null;
        String errorMsg = null;
        if (result.isOk()) {
            Object json = JacksonJsonUtil.fromJson(result.getData(), Object.class);
            if (json instanceof Map) {
                Map map = (Map)json;
                if (map.get("code").equals(0)) {
                    if (!(map.get("out") instanceof String)) return JacksonJsonUtil.toJSON(map.get("out"));
                    return map.get("out").toString();
                }
                errorMsg = String.format(EipErrorCode.INVOKE_FAILED.getMessage(), MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25\uff1a{0}EIP\u8fd4\u56de\u6d88\u606f\uff1a{1}", (String)"EipApiService_0", (String)"scm-common", (Object[])new Object[0]), URL.get(), map.get("message").toString()));
                log.info(errorMsg);
                throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{errorMsg});
            }
            errorMsg = String.format(EipErrorCode.RETURNDATA_FORMAT_ERROR.getMessage(), MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EAS\u63a5\u53e3\u5931\u8d25\uff1a{0},\u8fd4\u56de\u6570\u636e\uff1a{1}", (String)"EipApiService_1", (String)"scm-common", (Object[])new Object[0]), URL.get(), result.getData()));
            log.info(errorMsg);
            throw new KDException(EipErrorCode.RETURNDATA_FORMAT_ERROR, new Object[]{errorMsg});
        }
        errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EAS\u63a5\u53e3\uff1a{0},\u8fd4\u56de\u6570\u636e\u4e0d\u5bf9,\u8fd4\u56de\u6570\u636e\uff1a{1}", (String)"EipApiService_2", (String)"scm-common", (Object[])new Object[0]), URL.get(), result.getData());
        log.info(errorMsg);
        throw new KDException(EipErrorCode.RETURNDATA_FORMAT_ERROR, new Object[]{errorMsg});
    }

    protected Map<String, Object> handResult2Map(ApiResult result) {
        JSONObject jsonData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String errorMsg = null;
        if (result.isOk()) {
            jsonData = JSONObject.fromObject((Object)result.getData());
            if (!jsonData.get("code").equals(0)) {
                errorMsg = String.format(EipErrorCode.INVOKE_FAILED.getMessage(), MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EIP\u63a5\u53e3\uff1a{0}EIP\u8fd4\u56de\u6d88\u606f\uff1a{1}", (String)"EipApiService_3", (String)"scm-common", (Object[])new Object[0]), URL.get(), jsonData.get("message").toString()));
                log.error(errorMsg);
                throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{errorMsg});
            }
        } else {
            errorMsg = String.format(EipErrorCode.INVOKE_FAILED.getMessage(), MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EIP\u63a5\u53e3\uff1a{0}", (String)"EipApiService_4", (String)"scm-common", (Object[])new Object[0]), URL.get()));
            log.error(errorMsg);
            throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{errorMsg});
        }
        map.put("data", jsonData.get("out"));
        return map;
    }

    private ApiResult invokeApi(ApiRequest request) {
        ApiClient.Option option = new ApiClient.Option();
        option.connectTimeout = 5000;
        option.readTimeout = 50000;
        ApiClient client = null;
        ApiResult apiResult = null;
        try {
            client = ApiClientFactory.getExternal((ApiClient.Option)option);
            apiResult = client.execute(request);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{e.getMessage()});
        }
        finally {
            this.close(client);
        }
        return apiResult;
    }

    private void close(ApiClient client) {
        if (client != null) {
            client.close();
        }
    }

    protected String getToken() {
        StringBuilder tokenKey = new StringBuilder();
        tokenKey.append(EipConfigration.getHOST()).append(EipConfigration.getPORT()).append(EipConfigration.getAIS()).append(":token");
        StringBuilder getTokenDateKey = new StringBuilder();
        getTokenDateKey.append(EipConfigration.getHOST()).append(EipConfigration.getPORT()).append(EipConfigration.getAIS()).append(":getTokenDate");
        String token = (String)this.cache.get(tokenKey.toString(), String.class);
        if (token == null || token.isEmpty() || this.isTokenExpired()) {
            token = ApiUtil.Login();
            this.cache.put(getTokenDateKey.toString(), (Object)DateUtil.date2str(TimeServiceHelper.now(), null));
            this.cache.put(tokenKey.toString(), (Object)token);
        }
        return this.encodeString(token);
    }

    private boolean isTokenExpired() {
        Date currDate = new Date();
        Calendar calendar = Calendar.getInstance();
        StringBuilder getTokenDateKey = new StringBuilder();
        getTokenDateKey.append(EipConfigration.getHOST()).append(EipConfigration.getPORT()).append(EipConfigration.getAIS()).append(":getTokenDate");
        String getTokenDateStr = (String)this.cache.get(getTokenDateKey.toString(), String.class);
        Date getTokenDate = null;
        getTokenDate = getTokenDateStr != null ? DateUtil.string2date(getTokenDateStr, null) : DateUtil.string2date("1990-12-12 00:00:00", null);
        calendar.setTime(getTokenDate);
        calendar.add(10, 0);
        calendar.add(12, 3);
        return currDate.after(calendar.getTime());
    }

    protected String getUser() {
        return EipConfigration.getUSERNAME();
    }

    protected String getPassword() {
        return EipConfigration.getPW();
    }
}

