/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class LocationHelper
extends CoreHelper {
    private static final String ENTITY_KEY = "pur_location";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj = super.setDefaultProperties(obj);
        obj.set("auditdate", (Object)new Date());
        obj.set("auditor", (Object)RequestContext.get().getUserId());
        obj.set("creator", (Object)RequestContext.get().getUserId());
        obj.set("createorg", (Object)RequestContext.get().getOrgId());
        obj.set("ctrlstrategy", (Object)"5");
        return obj;
    }

    @Override
    protected String getSelectfields(Set<String> keySet, List<String> bd_properties) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(super.getSelectfields(keySet, bd_properties));
        strBuffer.append(",number,name,enable,status,creator,createtime");
        return strBuffer.toString();
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        for (DynamicObject warehouse : dynamicObjects) {
            String enable = warehouse.getString("enable");
            if (!"2".equals(enable)) continue;
            warehouse.set("enable", (Object)"0");
        }
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.afterAddEntity(dynamicObjects, dataMap);
        for (DynamicObject location : dynamicObjects) {
            String number = location.getString("number");
            Map<String, Object> locationMap = dataMap.get(number.toLowerCase());
            Iterator<DynamicObject> ware = locationMap.get("warehouse");
            if (ware == null) continue;
            ApiUtil.syncWarehouse("'" + ware + "'");
        }
        Object bdLocatiion = null;
        HashSet<DynamicObject> bdLocationSet = new HashSet<DynamicObject>();
        HashSet<String> warehouseIdSet = new HashSet<String>();
        HashSet<String> purLocatSet = new HashSet<String>(dynamicObjects.size());
        for (DynamicObject localtion : dynamicObjects) {
            purLocatSet.add(localtion.getString("number"));
            if (null == localtion.getString("warehouse")) continue;
            warehouseIdSet.add(localtion.getString("warehouse"));
        }
        QFilter purWarefilter = new QFilter("id", "in", warehouseIdSet);
        DynamicObject[] purWareArray = BusinessDataServiceHelper.load((String)"pur_warehouse", (String)DynamicObjectUtil.getSelectfields("pur_warehouse", false), (QFilter[])new QFilter[]{purWarefilter});
        HashSet<String> wareNumberSet = new HashSet<String>(purWareArray.length);
        HashMap<String, DynamicObject> purWareMap = new HashMap<String, DynamicObject>(purWareArray.length);
        for (int i = 0; i < purWareArray.length; ++i) {
            wareNumberSet.add(purWareArray[i].getString("number"));
            purWareMap.put(purWareArray[i].getString("id"), purWareArray[i]);
        }
        QFilter bdLocatfilter = new QFilter("number", "in", purLocatSet);
        DynamicObject[] bdLocatArray = BusinessDataServiceHelper.load((String)"bd_location", (String)DynamicObjectUtil.getSelectfields("bd_location", false), (QFilter[])new QFilter[]{bdLocatfilter});
        HashMap<String, DynamicObject> bdMap = new HashMap<String, DynamicObject>(bdLocatArray.length);
        for (int i = 0; i < bdLocatArray.length; ++i) {
            bdMap.put(bdLocatArray[i].getString("number"), bdLocatArray[i]);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.addBdLocation(bdLocationSet, dynamicObject, bdMap);
        }
        HashMap<String, DynamicObject> num_bdlocatMap = new HashMap<String, DynamicObject>(bdLocationSet.size());
        for (DynamicObject bdlocat : bdLocationSet) {
            num_bdlocatMap.put(bdlocat.getString("number"), bdlocat);
        }
        QFilter qFilter = new QFilter("number", "in", wareNumberSet);
        DynamicObject[] bdArray = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)(DynamicObjectUtil.getSelectfields("bd_warehouse", false) + "," + DynamicObjectUtil.getEntrySelectfields(null, "bd_warehouse", "entryentity", false)), (QFilter[])new QFilter[]{qFilter});
        DynamicObject warehouse = null;
        HashMap<String, DynamicObject> wareMap = new HashMap<String, DynamicObject>(bdArray.length);
        HashMap ware_locatMap = new HashMap(bdArray.length);
        for (int i = 0; i < bdArray.length; ++i) {
            warehouse = bdArray[i];
            wareMap.put(warehouse.getString("number"), warehouse);
            DynamicObjectCollection locationentry = warehouse.getDynamicObjectCollection("entryentity");
            HashSet<String> locationSet = new HashSet<String>();
            for (int j = 0; j < locationentry.size(); ++j) {
                DynamicObject bdLocat = (DynamicObject)locationentry.get(j);
                DynamicObject entry_locat = bdLocat.getDynamicObject("location");
                if (null == entry_locat) continue;
                locationSet.add(entry_locat.getString("number"));
            }
            ware_locatMap.put(warehouse.getString("number"), locationSet);
        }
        HashSet<DynamicObject> bdWareSet = new HashSet<DynamicObject>();
        for (DynamicObject localtion : dynamicObjects) {
            DynamicObjectCollection bdWareEntryCol;
            String number;
            if (null == localtion.getString("warehouse") || null == (warehouse = (DynamicObject)purWareMap.get(localtion.getString("warehouse"))) || null == wareMap.get(number = warehouse.getString("number"))) continue;
            DynamicObject bdwarehouse = (DynamicObject)wareMap.get(number);
            Set bdlocatNumSet = (Set)ware_locatMap.get(number);
            if (bdlocatNumSet.contains(localtion.getString("number"))) {
                bdWareEntryCol = bdwarehouse.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < bdWareEntryCol.size(); ++i) {
                    DynamicObject entry = (DynamicObject)bdWareEntryCol.get(i);
                    DynamicObject entry_locat = entry.getDynamicObject("location");
                    if (!entry_locat.getString("number").equals(localtion.getString("number"))) continue;
                    entry.set("location", num_bdlocatMap.get(localtion.getString("number")));
                }
                bdwarehouse.set("entryentity", (Object)bdWareEntryCol);
                bdWareSet.add(bdwarehouse);
                continue;
            }
            bdWareEntryCol = bdwarehouse.getDynamicObjectCollection("entryentity");
            DynamicObject entry = ORMUtil.newDynamicObject(bdWareEntryCol.getDynamicObjectType());
            entry.set("seq", (Object)(bdWareEntryCol.size() + 1));
            entry.set("location", num_bdlocatMap.get(localtion.getString("number")));
            bdWareEntryCol.add((Object)entry);
            if (bdWareEntryCol.size() > 0) {
                bdwarehouse.set("isopenlocation", (Object)1);
            }
            bdwarehouse.set("entryentity", (Object)bdWareEntryCol);
            bdWareSet.add(bdwarehouse);
        }
        if (bdLocationSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bdLocationSet.toArray(new DynamicObject[0]));
        }
        if (bdWareSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bdWareSet.toArray(new DynamicObject[0]));
        }
    }

    private void addBdLocation(Set<DynamicObject> bdLocationSet, DynamicObject warehouse, Map<String, DynamicObject> bdMap) {
        DynamicObject bdLocatiion = null != bdMap.get(warehouse.getString("number")) ? bdMap.get(warehouse.getString("number")) : ORMUtil.newDynamicObject("bd_location");
        bdLocatiion.set("number", (Object)warehouse.getString("number"));
        bdLocatiion.set("name", (Object)warehouse.getString("name"));
        bdLocatiion.set("enable", (Object)warehouse.getString("enable"));
        bdLocatiion.set("status", (Object)warehouse.getString("status"));
        bdLocatiion.set("id", warehouse.getPkValue());
        bdLocatiion.set("masterid", warehouse.getPkValue());
        bdLocatiion.set("creator", (Object)warehouse.getLong("creator"));
        bdLocatiion.set("createtime", (Object)warehouse.getDate("createtime"));
        bdLocationSet.add(bdLocatiion);
    }
}

