/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class MatProdMappingHelper
extends CoreHelper {
    private static Log log = LogFactory.getLog(MatProdMappingHelper.class);

    @Override
    protected String getEntityKey() {
        return "pmm_prodmatmapping";
    }

    @Override
    public String addEntity(Map<String, Object> dataMap) {
        log.info("@start addEntity--------------------------------------");
        HashMap<String, String> returnVal = new HashMap<String, String>(2);
        returnVal.put("code", "200");
        if (dataMap.get("data") == null || StringUtils.isEmpty((String)dataMap.get("data").toString())) {
            return null;
        }
        try {
            Object[] dyos;
            this.logInputData(String.valueOf(dataMap.get("data")));
            JSONArray list = JSONArray.fromObject((Object)dataMap.get("data"));
            ArrayList<String> goodsNoList = new ArrayList<String>();
            JSONObject entity = null;
            HashMap<String, Object> goodsMatMap = new HashMap<String, Object>();
            HashMap<String, Object> goodsModifierMap = new HashMap<String, Object>();
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject dynamicObject;
                String result;
                entity = JSONObject.fromObject(list.get(i));
                if (null == entity) continue;
                String goodsNumber = entity.get("number").toString().toLowerCase();
                String materialNumber = entity.get("material").toString().toLowerCase();
                String modifierNumber = entity.get("modifier").toString().toLowerCase();
                if (!this.isExist(materialNumber, "bd_material")) {
                    JSONObject jSONObject;
                    result = ApiUtil.invokeApi("bd_material", "'" + materialNumber + "'");
                    if (null != result && (jSONObject = JSONObject.fromObject((Object)result)).get("code") != null && jSONObject.get("code").toString().equals("500")) {
                        throw new KDBizException(jSONObject.get("msg") == null ? ResManager.loadKDString((String)"\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"MatProdMappingHelper_0", (String)"scm-common", (Object[])new Object[0]) : jSONObject.get("msg").toString());
                    }
                    QFilter qFilter = new QFilter("number", "=", (Object)materialNumber);
                    dynamicObject = QueryServiceHelper.queryOne((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
                    goodsMatMap.put(goodsNumber, dynamicObject.get("id"));
                }
                if (!this.isExist(modifierNumber, "bos_user")) {
                    JSONObject jSONObject;
                    result = ApiUtil.invokeApi("bos_user", "'" + modifierNumber + "'");
                    if (null != result && (jSONObject = JSONObject.fromObject((Object)result)).get("code") != null && jSONObject.get("code").toString().equals("500")) {
                        throw new KDBizException(jSONObject.get("msg") == null ? ResManager.loadKDString((String)"\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"MatProdMappingHelper_0", (String)"scm-common", (Object[])new Object[0]) : jSONObject.get("msg").toString());
                    }
                    QFilter qFilter = new QFilter("number", "=", (Object)modifierNumber);
                    dynamicObject = QueryServiceHelper.queryOne((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
                    goodsModifierMap.put(goodsNumber, dynamicObject.get("id"));
                }
                goodsNoList.add(goodsNumber);
            }
            QFilter filter = new QFilter("goods.number", "in", goodsNoList);
            for (DynamicObject dynamicObject : dyos = BusinessDataServiceHelper.load((String)"pmm_prodmatmapping", (String)"goods,material,modifier,billdate,modifytime", (QFilter[])new QFilter[]{filter})) {
                Object goodsModifierMapValue;
                String goodsNum = dynamicObject.getString("goods.number");
                Date currDate = TimeServiceHelper.now();
                Object goodsMatMapValue = goodsMatMap.get(goodsNum);
                if (goodsMatMapValue != null) {
                    dynamicObject.set("material", goodsMatMapValue);
                }
                if ((goodsModifierMapValue = goodsModifierMap.get(goodsNum)) != null) {
                    dynamicObject.set("modifier", goodsModifierMapValue);
                }
                dynamicObject.set("billdate", (Object)currDate);
                dynamicObject.set("modifytime", (Object)currDate);
            }
            SaveServiceHelper.save((DynamicObject[])dyos);
            log.info("update success:" + Arrays.toString(dyos));
        }
        catch (Exception e) {
            String exceptionStr = ExceptionUtil.getStackTrace(e);
            returnVal.put("msg", exceptionStr);
            returnVal.put("code", "500");
        }
        String returnStr = com.alibaba.fastjson.JSONObject.toJSONString(returnVal);
        this.logOutputData(this.getLogInfo().get(), returnStr);
        return returnStr;
    }

    private List<Long> getGoodsIdList(List<String> goodsNoList) {
        ArrayList<Long> goodsIdList = new ArrayList<Long>();
        QFilter filter = new QFilter("number", "in", goodsNoList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pbd_goods", (String)"id", (QFilter[])new QFilter[]{filter});
        if (null != dyoCol && dyoCol.size() > 0) {
            for (DynamicObject dyo : dyoCol) {
                goodsIdList.add(dyo.getLong("id"));
            }
        }
        return goodsIdList;
    }

    protected boolean isExist(String number, String entityKey) {
        HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, String> numberMap = new HashMap<String, String>(1);
        numberMap.put("=", number);
        paramMap.put("number", numberMap);
        return ORMUtil.isExist4MultiQFilter(entityKey, paramMap);
    }
}

