/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.DynamicObjectUtil;

public class MaterialHelper
extends CoreHelper {
    private static String ENTITY_KEY = "bd_material";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj = super.setDefaultProperties(obj);
        return obj;
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        for (DynamicObject dyn : dynamicObjects) {
            if (null != dyn.get("ctrlstrategy")) continue;
            dyn.set("ctrlstrategy", (Object)"5");
        }
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.afterAddEntity(dynamicObjects, dataMap);
        this.setSupplierStard(dynamicObjects);
    }

    private void setSupplierStard(List<DynamicObject> dynamicObjects) {
        HashSet<Long> groupIdSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (0L == dynamicObject.getLong("group")) continue;
            groupIdSet.add(dynamicObject.getLong("group"));
        }
        QFilter groupfilter = new QFilter("id", "in", groupIdSet);
        DynamicObject[] groupArray = BusinessDataServiceHelper.load((String)"bd_materialgroup", (String)"id,number,standard", (QFilter[])new QFilter[]{groupfilter});
        DynamicObject group = null;
        HashMap<Long, Long> group_stard = new HashMap<Long, Long>();
        for (int i = 0; i < groupArray.length; ++i) {
            group = groupArray[i];
            DynamicObject stard = group.getDynamicObject("standard");
            if (null == stard) continue;
            group_stard.put(group.getLong("id"), stard.getLong("id"));
        }
        if (group_stard.isEmpty()) {
            return;
        }
        HashMap supplier_stard = new HashMap(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long l = dynamicObject.getLong("group");
            supplier_stard.put(dynamicObject.getLong("id"), group_stard.get(l));
        }
        QFilter detailfilter = null;
        for (Map.Entry entry : supplier_stard.entrySet()) {
            if (null == detailfilter) {
                detailfilter = new QFilter("material.id", "=", entry.getKey());
                detailfilter.and(new QFilter("standard.id", "=", entry.getValue()));
                continue;
            }
            QFilter filter = new QFilter("material.id", "=", entry.getKey());
            filter.and(new QFilter("standard.id", "=", entry.getValue()));
            detailfilter.or(filter);
        }
        Object var9_12 = null;
        Object var10_18 = null;
        String selectors = DynamicObjectUtil.getSelectfields("bd_materialgroupdetail", false);
        DynamicObject[] detailArray = BusinessDataServiceHelper.load((String)"bd_materialgroupdetail", (String)selectors, (QFilter[])new QFilter[]{detailfilter});
        HashSet<DynamicObject> detailSet = new HashSet<DynamicObject>(detailArray.length);
        HashSet<Long> existSupplierId = new HashSet<Long>(detailArray.length);
        for (int i = 0; i < detailArray.length; ++i) {
            DynamicObject dynamicObject = detailArray[i];
            DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("material");
            dynamicObject.set("group", (Object)dynamicObject2.getDynamicObject("group"));
            detailSet.add(detailArray[0]);
            existSupplierId.add(dynamicObject2.getLong("id"));
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (existSupplierId.contains(dynamicObject.getLong("id"))) continue;
            DynamicObject detail = ORMUtil.newDynamicObject("bd_materialgroupdetail");
            detail.set("group", (Object)dynamicObject.getLong("group"));
            detail.set("material", dynamicObject.getPkValue());
            detail.set("standard", supplier_stard.get(dynamicObject.getLong("id")));
            detailSet.add(detail);
        }
        if (detailSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])detailSet.toArray(new DynamicObject[0]));
        }
    }
}

