/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.scm.common.eip.helper.BillCoreHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;

public class SouInquiryHelper
extends BillCoreHelper {
    private static String ENTITY_KEY = "sou_inquiry";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected String getSelectfields(Set<String> keySet) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(super.getSelectfields(keySet));
        strBuffer.append(",materialentry.srcbillid,billno");
        return strBuffer.toString();
    }

    @Override
    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        long billtype;
        obj = super.setHeadDefaultProperties(obj);
        obj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        obj.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        obj.set("supscope", null);
        obj.set("exchrate", (Object)BigDecimal.ONE);
        obj.set("inquirytitle", obj.get(this.getBillNumber()));
        obj.set("enddate", null);
        obj.set("turns", (Object)"1");
        obj.set("billdate", (Object)new Date());
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"billtype") && (billtype = obj.getLong("billtype")) == 0L) {
            obj.set("billtype", (Object)this.getDefaultBillType("sou_inquiry"));
        }
        return obj;
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() == 0L) continue;
        }
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntity(dynamicObjects, headDataMap, entryDataMap);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        DynamicObjectCollection entrys = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            entrys = dynamicObject.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                dataMap.put(entry.getString("srcbillid"), dynamicObject.getString("billno"));
            }
        }
        this.getReturnVal().put("data", dataMap);
    }

    @Override
    protected boolean isNotUpdated(DynamicObject obj, Map<String, Object> map) {
        return true;
    }
}

