/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.DynamicObjectUtil;

public class SupplierHelper
extends CoreHelper {
    private static String ENTITY_KEY = "bd_supplier";
    private static Log log = LogFactory.getLog(SupplierHelper.class);

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected String getSelectfields(Set<String> keySet, List<String> bd_properties) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(super.getSelectfields(keySet, bd_properties));
        strBuffer.append(',').append(DynamicObjectUtil.getEntrySelectfields(null, "bd_supplier", "entry_groupstandard", false));
        return strBuffer.toString();
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        String enable = obj.getString("enable");
        obj = super.setDefaultProperties(obj);
        obj.set("issuppcolla", (Object)"1");
        obj.set("ctrlstrategy", (Object)"5");
        obj.set("enable", (Object)enable);
        return obj;
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        HashSet<String> supplierNumberSet = new HashSet<String>(1024);
        Map<Object, Object> dataialMap = new HashMap(1024);
        HashMap<String, DynamicObject> orgMap = new HashMap<String, DynamicObject>(1024);
        for (Map.Entry<String, Map<String, Object>> entry : dataMap.entrySet()) {
            dataialMap = entry.getValue();
            if (null == dataialMap) continue;
            supplierNumberSet.add(String.valueOf(dataialMap.get("number")));
        }
        if (supplierNumberSet.size() > 0) {
            DynamicObject[] prodArray;
            QFilter prodfilter = new QFilter("number", "in", supplierNumberSet);
            for (DynamicObject supplier : prodArray = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,number,createorg.number,createorg.id", (QFilter[])new QFilter[]{prodfilter})) {
                DynamicObject createorg = supplier.getDynamicObject("createorg");
                if (null == createorg) continue;
                orgMap.put(supplier.getString("number"), createorg);
            }
        }
        DynamicObject creatorg = null;
        String supplierNum = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.get("createorg") instanceof Long && null != orgMap.get(supplierNum = dynamicObject.getString("number"))) {
                creatorg = (DynamicObject)orgMap.get(supplierNum);
                log.info("creatorg=" + creatorg.getPkValue());
                dynamicObject.set("createorg", creatorg.getPkValue());
            }
            this.setBizpartner(dynamicObject);
            this.setSuppState(dynamicObject);
        }
    }

    private void setSupplierStard(List<DynamicObject> dynamicObjects) {
        HashSet<Long> groupIdSet = new HashSet<Long>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            groupIdSet.add(dynamicObject.getLong("group"));
        }
        HashMap<Long, DynamicObject> groupId_OrgMap = new HashMap<Long, DynamicObject>(1024);
        QFilter groupfilter = new QFilter("id", "in", groupIdSet);
        DynamicObject[] groupArray = BusinessDataServiceHelper.load((String)"bd_suppliergroup", (String)"id,number,standard,createorg", (QFilter[])new QFilter[]{groupfilter});
        DynamicObject group = null;
        HashMap<Long, Long> group_stard = new HashMap<Long, Long>();
        for (int i = 0; i < groupArray.length; ++i) {
            group = groupArray[i];
            DynamicObject stard = group.getDynamicObject("standard");
            if (null != stard) {
                group_stard.put(group.getLong("id"), stard.getLong("id"));
            }
            groupId_OrgMap.put(group.getLong("id"), group.getDynamicObject("createorg"));
        }
        if (group_stard.isEmpty()) {
            return;
        }
        HashMap supplier_stard = new HashMap(dynamicObjects.size());
        HashMap<Long, Long> supplier_group = new HashMap<Long, Long>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long l = dynamicObject.getLong("group");
            supplier_stard.put(dynamicObject.getLong("id"), group_stard.get(l));
            supplier_group.put(dynamicObject.getLong("id"), l);
        }
        QFilter detailfilter = null;
        for (Map.Entry entry : supplier_stard.entrySet()) {
            if (null == detailfilter) {
                detailfilter = new QFilter("supplier.id", "=", entry.getKey());
                detailfilter.and(new QFilter("standard.id", "=", entry.getValue()));
                continue;
            }
            QFilter filter = new QFilter("supplier.id", "=", entry.getKey());
            filter.and(new QFilter("standard.id", "=", entry.getValue()));
            detailfilter.or(filter);
        }
        Object var11_14 = null;
        Object var12_20 = null;
        String selectors = DynamicObjectUtil.getSelectfields("bd_suppliergroupdetail", false);
        DynamicObject[] detailArray = BusinessDataServiceHelper.load((String)"bd_suppliergroupdetail", (String)"standard.id,group.id,supplier.id,supplier.group.id", (QFilter[])new QFilter[]{detailfilter});
        HashSet<DynamicObject> detailSet = new HashSet<DynamicObject>(detailArray.length);
        HashSet<Long> existSupplierId = new HashSet<Long>(detailArray.length);
        for (int i = 0; i < detailArray.length; ++i) {
            DynamicObject dynamicObject = detailArray[i];
            DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("supplier");
            Long supplierGroupValue = (Long)supplier_group.get(dynamicObject2.getLong("id"));
            if (supplierGroupValue == null) continue;
            dynamicObject.set("group_id", (Object)supplierGroupValue);
            detailSet.add(detailArray[0]);
            existSupplierId.add(dynamicObject2.getLong("id"));
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (existSupplierId.contains(dynamicObject.getLong("id"))) continue;
            DynamicObject detail = ORMUtil.newDynamicObject("bd_suppliergroupdetail");
            detail.set("group", (Object)dynamicObject.getLong("group"));
            detail.set("supplier", dynamicObject.getPkValue());
            detail.set("standard", supplier_stard.get(dynamicObject.getLong("id")));
            detail.set("createorg", groupId_OrgMap.get(dynamicObject.getLong("group")));
            detailSet.add(detail);
        }
        if (detailSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])detailSet.toArray(new DynamicObject[0]));
        }
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.afterAddEntity(dynamicObjects, dataMap);
        String enable = "";
        HashSet<Long> enableBizpartnerId = new HashSet<Long>();
        HashSet<Long> okBizpartnerId = new HashSet<Long>();
        String id = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            enable = dynamicObject.getString("enable");
            id = dynamicObject.getString("bizpartner");
            if ("0".equals(enable)) {
                enableBizpartnerId.add(Long.valueOf(id.toString()));
            }
            if ("1".equals(enable)) {
                okBizpartnerId.add(Long.valueOf(id.toString()));
            }
            dynamicObject.set("masterid", dynamicObject.getPkValue());
        }
        this.setSupplierStard(dynamicObjects);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        DynamicObject[] enableUsers = this.getUsers(enableBizpartnerId);
        DynamicObject[] okUsers = this.getUsers(okBizpartnerId);
        for (DynamicObject dynamicObject : enableUsers) {
            dynamicObject.set("enable", (Object)0);
        }
        for (DynamicObject dynamicObject : okUsers) {
            dynamicObject.set("enable", (Object)1);
        }
        if (enableUsers.length > 0) {
            SaveServiceHelper.save((DynamicObject[])enableUsers);
        }
        if (okUsers.length > 0) {
            SaveServiceHelper.save((DynamicObject[])okUsers);
        }
        ArrayList<Long> supplierIds = new ArrayList<Long>(dynamicObjects.size());
        ArrayList<String> supplierNames = new ArrayList<String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            supplierIds.add(dynamicObject.getLong("id"));
            supplierNames.add(dynamicObject.getString("name"));
        }
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SupplierHelper", (String)"srm_supplier", (String)"supplier", (QFilter[])new QFilter[]{new QFilter("supplier", "in", supplierIds).or(new QFilter("name", "in", supplierNames))}, (String)"supplier");){
            dataSet.forEach(row -> supplierIds.remove(row.getLong("supplier")));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (!supplierIds.isEmpty()) {
            String srcEntityKey = "bd_supplier";
            String string = "srm_supplier";
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(srcEntityKey);
            pushArgs.setTargetEntityNumber(string);
            pushArgs.setBuildConvReport(false);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(dynamicObjects.size());
            for (DynamicObject billData3 : dynamicObjects) {
                ListSelectedRow row2 = new ListSelectedRow();
                row2.setPrimaryKeyValue((Object)billData3.getLong("id"));
                selectedRowList.add(row2);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)string);
                List targetData = result.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objects, IDataEntityType iDataEntityType) {
                        BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType);
                    }
                }, mainType);
                Date now = TimeServiceHelper.now();
                String userId = RequestContext.get().getUserId();
                for (DynamicObject supplier : targetData) {
                    supplier.set("auditdate", (Object)now);
                    supplier.set("auditor_id", (Object)Long.valueOf(userId));
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                option.setVariableValue("ishasright", String.valueOf(true));
                OperationResult opResult = SaveServiceHelper.saveOperate((String)"srm_supplier", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!opResult.isSuccess()) {
                    StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6ce8\u518c\u4f9b\u5e94\u5546\u4fdd\u5b58\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a", (String)"SupplierHelper_0", (String)"scm-common", (Object[])new Object[0]));
                    message.append(opResult.getMessage());
                    opResult.getAllErrorOrValidateInfo().forEach(row -> message.append(row.getMessage()));
                    log.info(message.toString());
                } else {
                    log.info("\u6b63\u5f0f\u4f9b\u5e94\u5546\u8f6c\u6ce8\u518c\u4f9b\u5e94\u6210\u529f\uff0c\u606d\u559c\u60a8\uff01" + opResult.getSuccessPkIds());
                }
            } else {
                StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6b63\u5f0f\u4f9b\u5e94\u5546\u8f6c\u6ce8\u518c\u4f9b\u5e94\u5546\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a", (String)"SupplierHelper_1", (String)"scm-common", (Object[])new Object[0]));
                result.getReports().forEach(row -> message.append(row.getMessage()));
                log.info(message.toString());
            }
        }
    }

    public Set<String> getUserByPhone(Set<Long> bizpartnerId) {
        DynamicObject[] cols;
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Set<Long>> idMap = new HashMap<String, Set<Long>>(1);
        idMap.put("in", bizpartnerId);
        params.put("bizpartner", idMap);
        HashSet<String> phoneList = new HashSet<String>();
        for (DynamicObject dynamicObject : cols = ORMUtil.load("pur_supuser", "user.phone", params)) {
            if (dynamicObject.getDynamicObject("user") == null) continue;
            phoneList.add(dynamicObject.getDynamicObject("user").getString("phone"));
        }
        return phoneList;
    }

    public DynamicObject[] getUsers(Set<Long> bizpartnerId) {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Set<String>> phoneMap = new HashMap<String, Set<String>>(1);
        phoneMap.put("in", this.getUserByPhone(bizpartnerId));
        params.put("phone", phoneMap);
        return ORMUtil.load("bos_user", "enable", params);
    }

    private void setSuppState(DynamicObject supplier) {
        String enable = supplier.getString("enable");
        if (enable.equals("1")) {
            supplier.set("status", (Object)"C");
            supplier.set("enable", (Object)"1");
        } else if (enable.equals("2")) {
            supplier.set("status", (Object)"C");
            supplier.set("enable", (Object)"0");
        } else if (enable.equals("0")) {
            supplier.set("status", (Object)"C");
            supplier.set("enable", (Object)"1");
        }
    }

    private void setBizpartner(DynamicObject supplier) {
        ORM orm = ORM.create();
        String name = supplier.getString("name");
        String number = supplier.getString("number");
        String internalCompany = supplier.getString("internal_company_id");
        String selectFields = "id,name,bizpartner";
        Object bizpartner = null;
        try {
            DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (String)this.getEntityKey(), (String)selectFields);
            if (null != dyObj) {
                bizpartner = dyObj.get("bizpartner");
            }
        }
        catch (Exception dyObj) {
            // empty catch block
        }
        DynamicObject[] dynamicObjectCheck = null;
        dynamicObjectCheck = bizpartner instanceof DynamicObject ? BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id,name,issupplier,simplename,partnerrole", (QFilter[])new QFilter[]{new QFilter("id", "=", ((DynamicObject)bizpartner).getPkValue())}) : BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id,name,issupplier,simplename,partnerrole", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        if (null != dynamicObjectCheck && dynamicObjectCheck.length > 0) {
            DynamicObject save = dynamicObjectCheck[0];
            supplier.set("bizpartner", (Object)save.getLong("id"));
            save.set("name", (Object)name);
            save.set("number", (Object)number);
            save.set("simplename", (Object)name);
            save.set("issupplier", (Object)"1");
            String partnerrole = save.getString("partnerrole");
            if (partnerrole == null || partnerrole.isEmpty()) {
                save.set("partnerrole", (Object)",1,");
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjectCheck);
        } else {
            DynamicObject dynamicObjectSave = orm.newDynamicObject("bd_bizpartner");
            dynamicObjectSave.set("name", (Object)name);
            dynamicObjectSave.set("number", (Object)number);
            dynamicObjectSave.set("simplename", (Object)name);
            dynamicObjectSave.set("issupplier", (Object)"1");
            dynamicObjectSave.set("type", (Object)"1");
            dynamicObjectSave.set("status", (Object)"C");
            dynamicObjectSave.set("enable", (Object)"1");
            dynamicObjectSave.set("partnerrole", (Object)",1,");
            dynamicObjectSave.set("internal_company_id", (Object)internalCompany);
            Object[] result = SaveServiceHelper.save((IDataEntityType)dynamicObjectSave.getDataEntityType(), (Object[])new Object[]{dynamicObjectSave});
            if (null != result && result.length > 0) {
                supplier.set("bizpartner", ((DynamicObject)result[0]).getPkValue());
            }
        }
    }
}

