/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class WarehouseHelper
extends CoreHelper {
    private static String ENTITY_KEY = "pur_warehouse";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected String getSelectfields(Set<String> keySet, List<String> bd_properties) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(super.getSelectfields(keySet, bd_properties));
        strBuffer.append(",number,name,enable,status,creator,createtime,createorg,useorg,org");
        return strBuffer.toString();
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        for (DynamicObject warehouse : dynamicObjects) {
            String enable = warehouse.getString("enable");
            if (!"2".equals(enable)) continue;
            warehouse.set("enable", (Object)"0");
        }
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.afterAddEntity(dynamicObjects, dataMap);
        Object bdWarehouse = null;
        HashSet<DynamicObject> bdWarehouseSet = new HashSet<DynamicObject>();
        HashSet<Long> idSet = new HashSet<Long>(dynamicObjects.size());
        HashSet<String> numberSet = new HashSet<String>(dynamicObjects.size());
        for (DynamicObject warehouse : dynamicObjects) {
            String number = warehouse.getString("number");
            Map<String, Object> wareHouseMap = dataMap.get(number.toLowerCase());
            Object locas = wareHouseMap.get("locations");
            if (locas instanceof List) {
                List locations = (List)wareHouseMap.get("locations");
                StringBuilder locNumberSb = new StringBuilder();
                for (Object location : locations) {
                    if (location == null || String.valueOf(location).equals("null")) continue;
                    if (locNumberSb.length() > 0) {
                        locNumberSb.append(',').append('\'').append(String.valueOf(location)).append('\'');
                        continue;
                    }
                    locNumberSb.append('\'').append(String.valueOf(location)).append('\'');
                }
                if (locNumberSb.length() > 0) {
                    ApiUtil.syncLocation(locNumberSb.toString());
                }
            }
            idSet.add(warehouse.getLong("id"));
            numberSet.add(warehouse.getString("number"));
        }
        HashMap<String, DynamicObject> number_bdLocationMap = new HashMap<String, DynamicObject>();
        Map id_purLocatsMap = this.getLocationByWare(idSet, number_bdLocationMap);
        Map<String, DynamicObject> number_bdWareMap = this.getBdWareHouse(numberSet);
        for (DynamicObject warehouse : dynamicObjects) {
            this.addBdWarehouse(bdWarehouseSet, warehouse, id_purLocatsMap, number_bdLocationMap, number_bdWareMap);
        }
        if (bdWarehouseSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bdWarehouseSet.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, DynamicObject> getBdWareHouse(Set<String> numberSet) {
        QFilter filter = new QFilter("number", "in", numberSet);
        DynamicObject[] srcArray = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)(DynamicObjectUtil.getSelectfields("bd_warehouse", false) + "," + DynamicObjectUtil.getEntrySelectfields(null, "bd_warehouse", "entryentity", false)), (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> bdWareMap = new HashMap<String, DynamicObject>(srcArray.length);
        for (int i = 0; i < srcArray.length; ++i) {
            bdWareMap.put(srcArray[i].getString("number"), srcArray[i]);
        }
        return bdWareMap;
    }

    public Map getLocationByWare(Set<Long> idSet, Map<String, DynamicObject> bdLocationmap) {
        HashMap<Long, DynamicObjectCollection> wid_LocationMap = new HashMap<Long, DynamicObjectCollection>();
        QFilter filter = new QFilter("warehouse", "in", idSet);
        DynamicObject[] srcArray = BusinessDataServiceHelper.load((String)"pur_location", (String)DynamicObjectUtil.getSelectfields("pur_location", false), (QFilter[])new QFilter[]{filter});
        HashSet<String> numberSet = new HashSet<String>(srcArray.length);
        DynamicObject location = null;
        DynamicObject warehouse = null;
        for (int i = 0; i < srcArray.length; ++i) {
            location = srcArray[i];
            warehouse = location.getDynamicObject("warehouse");
            DynamicObjectCollection col = new DynamicObjectCollection();
            col.add((Object)location);
            if (null == wid_LocationMap.get(warehouse.getLong("id"))) {
                wid_LocationMap.put(warehouse.getLong("id"), col);
            } else {
                col = (DynamicObjectCollection)wid_LocationMap.get(warehouse.getLong("id"));
                col.add((Object)location);
                wid_LocationMap.put(warehouse.getLong("id"), col);
            }
            numberSet.add(location.getString("number"));
        }
        QFilter bdfilter = new QFilter("number", "in", numberSet);
        DynamicObject[] bdArray = BusinessDataServiceHelper.load((String)"bd_location", (String)DynamicObjectUtil.getSelectfields("bd_location", false), (QFilter[])new QFilter[]{bdfilter});
        for (int i = 0; i < bdArray.length; ++i) {
            location = bdArray[i];
            bdLocationmap.put(location.getString("number"), location);
        }
        return wid_LocationMap;
    }

    private void addBdWarehouse(Set<DynamicObject> bdWarehouseSet, DynamicObject warehouse, Map<Long, DynamicObjectCollection> id_purLocatsMap, Map<String, DynamicObject> number_bdLocationMap, Map<String, DynamicObject> number_bdWareMap) {
        DynamicObject bdWarehouse = null != number_bdWareMap.get(warehouse.getString("number")) ? number_bdWareMap.get(warehouse.getString("number")) : ORMUtil.newDynamicObject("bd_warehouse");
        bdWarehouse.set("number", (Object)warehouse.getString("number"));
        bdWarehouse.set("name", (Object)warehouse.getString("name"));
        bdWarehouse.set("enable", (Object)warehouse.getString("enable"));
        bdWarehouse.set("status", (Object)warehouse.getString("status"));
        bdWarehouse.set("id", warehouse.getPkValue());
        bdWarehouse.set("masterid", warehouse.getPkValue());
        bdWarehouse.set("creator", (Object)warehouse.getLong("creator"));
        bdWarehouse.set("createorg", (Object)warehouse.getLong("createorg"));
        bdWarehouse.set("createtime", (Object)warehouse.getDate("createtime"));
        bdWarehouse.set("org", (Object)warehouse.getLong("useorg"));
        bdWarehouse.set("createorg", (Object)warehouse.getLong("org"));
        bdWarehouse.set("ctrlstrategy", (Object)5);
        bdWarehouse.set("address", (Object)"410");
        bdWarehouse.set("detailaddress", (Object)"");
        if (null != id_purLocatsMap.get(warehouse.getLong("id")) && id_purLocatsMap.get(warehouse.getLong("id")).size() > 0) {
            bdWarehouse.set("isopenlocation", (Object)1);
        } else {
            bdWarehouse.set("isopenlocation", (Object)0);
        }
        WarehouseHelper.setWarehouseEntry(bdWarehouse, warehouse, id_purLocatsMap, number_bdLocationMap);
        bdWarehouseSet.add(bdWarehouse);
    }

    public static void setWarehouseEntry(DynamicObject newDestDyna, DynamicObject srcDyna, Map id_purLocatsMap, Map number_bdLocationMap) {
        DynamicObjectCollection locationCol = new DynamicObjectCollection();
        DynamicObjectCollection purLocations = (DynamicObjectCollection)id_purLocatsMap.get(srcDyna.getLong("id"));
        if (null == purLocations) {
            return;
        }
        int index = 1;
        for (int j = 0; j < purLocations.size(); ++j) {
            if (null == number_bdLocationMap.get(((DynamicObject)purLocations.get(j)).getString("number"))) continue;
            DynamicObject entry = ORMUtil.newDynamicObject("bd_warehouse.entryentity");
            entry.set("seq", (Object)index);
            entry.set("location", number_bdLocationMap.get(((DynamicObject)purLocations.get(j)).getString("number")));
            locationCol.add((Object)entry);
            ++index;
        }
        if (locationCol.size() > 0) {
            newDestDyna.set("isopenlocation", (Object)1);
        }
        newDestDyna.set("entryentity", (Object)locationCol);
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        super.setDefaultProperties(obj);
        obj.set("auditdate", (Object)new Date());
        obj.set("auditor", (Object)RequestContext.get().getUserId());
        obj.set("creator", (Object)RequestContext.get().getUserId());
        obj.set("createorg", (Object)RequestContext.get().getOrgId());
        obj.set("ctrlstrategy", (Object)"5");
        return obj;
    }
}

