/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.util;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.api.client.ApiResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.eip.errorcode.EipErrorCode;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DataTransterLogUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class EipUtils {
    private static Log log = LogFactory.getLog(EipUtils.class);

    private EipUtils() {
    }

    public static DynamicObject map2DynamicObject(Map<String, Object> billMap, List<String> dateProperties, String entityKey) {
        DynamicObject billObj = ORMUtil.newDynamicObject(entityKey);
        billObj = EipUtils.map2DynamicObject(billMap, billObj);
        return billObj;
    }

    @Deprecated
    public static DynamicObject map2DynamicObject(Map<String, Object> billMap, String entityKey) {
        DynamicObject billObj = ORMUtil.newDynamicObject(entityKey);
        billObj = EipUtils.map2DynamicObject(billMap, billObj);
        return billObj;
    }

    public static DynamicObject map2DynamicObject(Map<String, Object> billMap, DynamicObject billObj) {
        if (billObj != null && billMap != null) {
            Map<String, List<String>> differProMap = DynamicObjectUtil.getDifferDynamicProperties(billObj);
            List<String> allProList = differProMap.get("allProList");
            List<String> dateList = differProMap.get("dateList");
            List<String> decimalList = differProMap.get("decimalList");
            List<String> booleanList = differProMap.get("booleanList");
            Set<Map.Entry<String, Object>> entrySet = billMap.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                if (!allProList.contains(key)) continue;
                if (dateList.contains(key)) {
                    billObj.set(key, (Object)DateUtil.string2date("".equals(entry.getValue()) ? null : entry.getValue().toString(), null));
                    continue;
                }
                if (decimalList.contains(key)) {
                    billObj.set(key, (Object)EipUtils.obj2decimal(entry.getValue()));
                    continue;
                }
                if (booleanList.contains(key)) {
                    billObj.set(key, StringUtils.isEmpty((String)entry.getValue().toString()) ? Character.valueOf('0') : entry.getValue());
                    continue;
                }
                if (StringUtils.equals((String)"taxtype", (String)key)) {
                    billObj.set(key, (Object)EipUtils.obj2taxType(entry.getValue()));
                    continue;
                }
                if (StringUtils.equals((String)"id", (String)key) || StringUtils.equals((String)"entryentity", (String)key) || StringUtils.equals((String)"seq", (String)key)) continue;
                billObj.set(key, entry.getValue());
            }
        }
        return billObj;
    }

    public static DynamicObject setDynamicObjBDVal(DynamicObject dynamicObj, String property, String bd_entityKey) {
        if (dynamicObj == null || StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)bd_entityKey)) {
            return dynamicObj;
        }
        String val = dynamicObj.get(property).toString();
        QFilter filter = new QFilter("number", "=", (Object)val);
        if ("bd_measureunits".equals(bd_entityKey)) {
            filter.and("ispreset", "=", (Object)Character.valueOf('0'));
        }
        String selectFields = "id,number";
        DynamicObject[] basedatas = BusinessDataServiceHelper.loadFromCache((String)bd_entityKey, (String)selectFields, (QFilter[])new QFilter[]{filter}).values().toArray(new DynamicObject[0]);
        RequestContext request = RequestContext.get();
        if (EipConfigration.isISLOG() && basedatas.length > 0 && StringUtils.equals((String)"700416436996178944", (String)basedatas[0].getPkValue().toString())) {
            String msg = "[700416436996178944]bd_entityKey=" + bd_entityKey + ", paramMap=" + filter + ",accountId:" + request.getAccountId() + ",tenantId:" + request.getTenantId();
            log.info(msg);
            DataTransterLogUtil.logInputData(EipConfigration.getAPICONFIGID(), "currencyError", bd_entityKey, msg);
        }
        dynamicObj.set(property, basedatas.length == 0 ? Integer.valueOf(0) : basedatas[0].getPkValue());
        return dynamicObj;
    }

    public static DynamicObject setDynamicObjAssistantDataVal(DynamicObject dynamicObj, String property, String bd_entityKey, long assitantType) {
        if (dynamicObj == null || StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)bd_entityKey)) {
            return dynamicObj;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", dynamicObj.get(property));
        map.put("group", assitantType);
        String selectFields = "id,number";
        DynamicObject basedata = ORMUtil.queryOneByPro(bd_entityKey, selectFields, map);
        dynamicObj.set(property, basedata == null ? Integer.valueOf(0) : basedata.getPkValue());
        return dynamicObj;
    }

    public static DynamicObject setBDProperties(DynamicObject obj, List<String> properties, Map<String, String> bd_pageindentity) {
        DynamicObject configObj = ApiConfigUtil.getEasConfig();
        for (int i = 0; i < properties.size(); ++i) {
            String property = properties.get(i);
            if (obj.get(property) == null || StringUtils.isEmpty((String)obj.get(property).toString())) {
                obj.set(property, (Object)0);
                continue;
            }
            String val = obj.get(property).toString();
            Object lock = null;
            if ((obj = EipUtils.setDynamicObjBDVal(obj, property, bd_pageindentity.get(property))).get(property) != null && !StringUtils.equals((String)"0", (String)obj.get(property).toString())) continue;
            if (ApiConfigUtil.isSyn(configObj, property)) {
                ApiUtil.invokeApi(property, "'" + val + "'");
                obj.set(property, (Object)val);
                obj = EipUtils.setDynamicObjBDVal(obj, property, bd_pageindentity.get(property));
                continue;
            }
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\uff1a\u4e0d\u5b58\u5728(\u4e0d\u81ea\u52a8\u540c\u6b65),\u8bf7\u786e\u8ba4\u6b64\u57fa\u7840\u8d44\u6599\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002", (String)"EipUtils_0", (String)"scm-common", (Object[])new Object[0]), property, val));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject setBDProperties(DynamicObject obj) {
        DynamicObject configObj = ApiConfigUtil.getEasConfig();
        Map<String, String> map = EipUtils.getDynamicBDProperties(obj);
        for (Map.Entry<String, String> propertyMap : map.entrySet()) {
            Object proVal = obj.get(propertyMap.getKey());
            if (proVal == null || StringUtils.isEmpty((String)proVal.toString())) {
                obj.set(propertyMap.getKey(), (Object)0);
                continue;
            }
            if (proVal instanceof DynamicObject) {
                obj.set(propertyMap.getKey(), ((DynamicObject)proVal).getPkValue());
                continue;
            }
            String val = proVal.toString();
            Object lock = null;
            try {
                if ((obj = EipUtils.setDynamicObjBDVal(obj, propertyMap.getKey(), propertyMap.getValue())).get(propertyMap.getKey()) != null && !StringUtils.equals((String)"0", (String)obj.get(propertyMap.getKey()).toString())) continue;
                if (ApiConfigUtil.isSyn(configObj, propertyMap.getValue())) {
                    JSONObject resultMap;
                    String result = ApiUtil.invokeApi(propertyMap.getValue(), "'" + val + "'");
                    if (null != result && (resultMap = JSONObject.fromObject((Object)result)).get("code") != null && resultMap.get("code").toString().equals("500")) {
                        throw new KDBizException(resultMap.get("msg") == null ? ResManager.loadKDString((String)"\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"EipUtils_1", (String)"scm-common", (Object[])new Object[0]) : resultMap.get("msg").toString());
                    }
                    obj.set(propertyMap.getKey(), (Object)val);
                    obj = EipUtils.setDynamicObjBDVal(obj, propertyMap.getKey(), propertyMap.getValue());
                    continue;
                }
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4e0d\u5b58\u5728(\u4e0d\u81ea\u52a8\u540c\u6b65),\u8bf7\u786e\u8ba4\u6b64\u57fa\u7840\u8d44\u6599\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002", (String)"EipUtils_2", (String)"scm-common", (Object[])new Object[0]), propertyMap.getKey(), val));
            }
            finally {
                if (lock == null) continue;
                lock.unlock();
            }
        }
        return obj;
    }

    public static DynamicObject setAssistantDataProperties(DynamicObject obj) {
        Map<String, Map<String, String>> assisbdMap = EipUtils.getDynamicAssistantProperties(obj);
        for (Map.Entry<String, Map<String, String>> propertyMap : assisbdMap.entrySet()) {
            Object proVal = obj.get(propertyMap.getKey());
            if (proVal == null || StringUtils.isEmpty((String)proVal.toString())) {
                obj.set(propertyMap.getKey(), (Object)0);
                continue;
            }
            if (proVal instanceof DynamicObject) {
                obj.set(propertyMap.getKey(), ((DynamicObject)proVal).getPkValue());
                continue;
            }
            String val = proVal.toString();
            Map<String, String> map = propertyMap.getValue();
            String assistantType = map.get("assistantType");
            String key = map.get("key");
            String lockKey = "/scm/common/eipUitls/addDBEntity/" + assistantType + val;
            DLock lock = DLock.create((String)lockKey);
            Throwable throwable = null;
            try {
                if (EipConfigration.isISLOCK() ? lock.tryLock(30000L) : !EipConfigration.isISLOCK()) {
                    if ((obj = EipUtils.setDynamicObjAssistantDataVal(obj, propertyMap.getKey(), key, Long.parseLong(assistantType))).get(propertyMap.getKey()) != null && !StringUtils.equals((String)"0", (String)obj.get(propertyMap.getKey()).toString())) continue;
                    ApiUtil.invokeApi(key, assistantType, "'" + val + "'");
                    obj.set(propertyMap.getKey(), (Object)val);
                    obj = EipUtils.setDynamicObjAssistantDataVal(obj, propertyMap.getKey(), key, Long.parseLong(assistantType));
                    continue;
                }
                throw new KDBizException("### eipUitls can not get the lock:" + lockKey);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
        return obj;
    }

    public static BigDecimal obj2decimal(Object obj) {
        String str = null;
        str = obj == null || StringUtils.isEmpty((String)obj.toString()) ? "0" : obj.toString().replaceAll(",", "");
        return new BigDecimal(str).abs();
    }

    public static String obj2taxType(Object obj) {
        String str = TaxTypeEnum.TAXSEXPRICE_INTAX.getVal();
        if (StringUtils.equals((String)"11", (String)obj.toString())) {
            str = TaxTypeEnum.TAXSEXPRICE_INTAX.getVal();
        } else if (StringUtils.equals((String)"01", (String)obj.toString())) {
            str = TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal();
        } else if (StringUtils.equals((String)"10", (String)obj.toString())) {
            str = TaxTypeEnum.TAXSINPRICE_INTAX.getVal();
        }
        return str;
    }

    public static List<String> getDynamicDecimalProperties(DynamicObject obj) {
        return DynamicObjectUtil.getDifferDynamicProperties(obj).get("decimalList");
    }

    public static List<String> getDynamicDateProperties(DynamicObject obj) {
        return DynamicObjectUtil.getDifferDynamicProperties(obj).get("dateList");
    }

    public static Map<String, Map<String, String>> getDynamicAssistantProperties(DynamicObject obj) {
        HashMap<String, Map<String, String>> assisbdMap = new HashMap<String, Map<String, String>>(1);
        if (obj != null) {
            DataEntityPropertyCollection proptiesCol = obj.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                if (!(iDataEntityProperty instanceof AssistantProp)) continue;
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("assistantType", ((AssistantProp)iDataEntityProperty).getAsstTypeId());
                map.put("key", ((AssistantProp)iDataEntityProperty).getBaseEntityId());
                assisbdMap.put(iDataEntityProperty.getName(), map);
            }
        }
        return assisbdMap;
    }

    public static Map<String, String> getDynamicBDProperties(DynamicObject obj) {
        HashMap<String, String> bdMap = new HashMap<String, String>();
        if (obj != null) {
            DataEntityPropertyCollection proptiesCol = obj.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                if (iDataEntityProperty instanceof AssistantProp || !(iDataEntityProperty instanceof BasedataProp)) continue;
                bdMap.put(iDataEntityProperty.getName(), ((BasedataProp)iDataEntityProperty).getBaseEntityId());
            }
        }
        return bdMap;
    }

    public static List<String> getDynamicProperties(DynamicObject dynamicObject) {
        return DynamicObjectUtil.getDifferDynamicProperties(dynamicObject).get("allProList");
    }

    public static Map<String, Object> handleApiResult(ApiResult result, String api) {
        Map map = null;
        String errorMsg = null;
        if (result.isOk()) {
            map = (Map)result.getData(Map.class);
            if (!map.get("code").equals(0)) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EIP\u63a5\u53e3\uff1a{0}EIP\u8fd4\u56de\u6d88\u606f\uff1a{1}", (String)"EipUtils_3", (String)"scm-common", (Object[])new Object[0]), api, map.get("message").toString());
                log.error(String.format(EipErrorCode.INVOKE_FAILED.getMessage(), errorMsg));
                throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{errorMsg});
            }
        } else {
            errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528EIP\u63a5\u53e3\uff1a{0}", (String)"EipUtils_4", (String)"scm-common", (Object[])new Object[0]), api);
            log.error(String.format(EipErrorCode.INVOKE_FAILED.getMessage(), errorMsg));
            throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[0]);
        }
        map.put("data", map.get("out"));
        map.put("out", null);
        return map;
    }

    public static Map<String, Object> object2Map(DynamicObject dynamicObject) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection dynamicObjects = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : dynamicObjects) {
                if (iDataEntityProperty instanceof LongProp) continue;
                if (iDataEntityProperty instanceof BasedataProp) {
                    objectMap.put(iDataEntityProperty.getName(), EipUtils.getBDNumberOfValue(dynamicObject.getDynamicObject(iDataEntityProperty.getName())));
                    continue;
                }
                if (iDataEntityProperty instanceof EntryProp) continue;
                objectMap.put(iDataEntityProperty.getName(), dynamicObject.get(iDataEntityProperty.getName()));
            }
        }
        return objectMap;
    }

    public static Object getBDNumberOfValue(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            return dynamicObject.get("number");
        }
        return null;
    }
}

