/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private MessageDigest md;

    public MD5Util() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public final void update(byte[] input) {
        this.md.update(input);
    }

    public final String getDigestResult() {
        return MD5Util.bytesToHex(this.md.digest());
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int t = bytes[i];
            if (t < 0) {
                t += 256;
            }
            sb.append(hexDigits[t >>> 4]);
            sb.append(hexDigits[t % 16]);
        }
        return sb.toString();
    }

    public static String code(String input) throws Exception {
        return MD5Util.code(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String code(byte[] bytes) throws Exception {
        return MD5Util.code(bytes, 32);
    }

    public static String code(byte[] bytes, int bit) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        if (bit == 16) {
            return MD5Util.bytesToHex(md.digest(bytes)).substring(8, 24);
        }
        return MD5Util.bytesToHex(md.digest(bytes));
    }
}

