/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.transfer;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class SDKTransferHelper {
    private static final Log log = LogFactory.getLog((String)SDKTransferHelper.class.getName());

    public static Map<String, String> getSDKEntryMap(String extCase, Class classz, Class defaultClass) {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(50);
        PluginProxy pluginProxy = PluginProxy.create((Object)defaultClass, (Class)classz, (String)extCase, null);
        List pluginProxyPlugins = pluginProxy.getPlugins();
        StringBuilder pluginInfo = new StringBuilder();
        StringBuilder callPluginInfo = new StringBuilder();
        if (pluginProxyPlugins != null && !pluginProxyPlugins.isEmpty()) {
            pluginProxyPlugins.forEach(p -> pluginInfo.append(p.getClass().getName()).append("\t\n"));
        }
        pluginProxy.callReplace(p -> {
            callPluginInfo.append(p.getClass().getName()).append("\t\n");
            sdkEntryMap.putAll(p.assembleExtPro());
            return null;
        });
        if (log.isInfoEnabled()) {
            log.info(pluginInfo.toString());
            log.info(callPluginInfo.toString());
            log.info(((Object)sdkEntryMap).toString());
        }
        return sdkEntryMap;
    }

    public static Map<String, String> getSDKHeadMap(String extCase, Class classz, Class defaultClass) {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(50);
        PluginProxy pluginProxy = PluginProxy.create((Object)defaultClass, (Class)classz, (String)extCase, null);
        List pluginProxyPlugins = pluginProxy.getPlugins();
        StringBuilder pluginInfo = new StringBuilder();
        StringBuilder callPluginInfo = new StringBuilder();
        if (pluginProxyPlugins != null && !pluginProxyPlugins.isEmpty()) {
            pluginProxyPlugins.forEach(p -> pluginInfo.append(p.getClass().getName()).append("\t\n"));
        }
        pluginProxy.callReplace(p -> {
            callPluginInfo.append(p.getClass().getName()).append("\t\n");
            sdkEntryMap.putAll(p.assembleExtHeadPro());
            return null;
        });
        if (log.isInfoEnabled()) {
            log.info(pluginInfo.toString());
            log.info(callPluginInfo.toString());
            log.info(((Object)sdkEntryMap).toString());
        }
        return sdkEntryMap;
    }

    public static Map<String, String> executeTransfer(DynamicObject data, Map<String, String> transferEntry) {
        return SDKTransferHelper.executeTransfer(data, transferEntry, true);
    }

    public static Map<String, String> executeTransfer(DynamicObject data, Map<String, String> transferEntry, boolean baseNumberValue) {
        LinkedHashMap<String, String> extTransferData = new LinkedHashMap<String, String>(50);
        DynamicObjectType dynamicObjectType = data.getDynamicObjectType();
        if (!transferEntry.isEmpty()) {
            for (Map.Entry<String, String> entry : transferEntry.entrySet()) {
                String entryKey = entry.getKey();
                String entryValue = entry.getValue();
                DynamicProperty dynamicProperty = dynamicObjectType.getProperty(entryKey);
                if (dynamicProperty == null) continue;
                if (dynamicProperty instanceof BasedataProp) {
                    DynamicObject baseData = (DynamicObject)dynamicProperty.getValue((Object)data);
                    if (baseData != null) {
                        if (baseNumberValue) {
                            String numberProp = ((BasedataProp)dynamicProperty).getNumberProp();
                            if (numberProp != null) {
                                extTransferData.put(entryValue, baseData.getString(numberProp));
                                continue;
                            }
                            extTransferData.put(entryValue, baseData.getString("number"));
                            continue;
                        }
                        extTransferData.put(entryValue, baseData.getString("id"));
                        continue;
                    }
                    extTransferData.put(entryValue, "");
                    continue;
                }
                if (dynamicProperty instanceof DecimalProp) {
                    extTransferData.put(entryValue, ((BigDecimal)dynamicProperty.getValue((Object)data)).toPlainString());
                    continue;
                }
                if (dynamicProperty instanceof DateTimeProp) {
                    extTransferData.put(entryValue, String.valueOf(dynamicProperty.getValue((Object)data)));
                    continue;
                }
                extTransferData.put(entryValue, String.valueOf(dynamicProperty.getValue((Object)data)));
            }
        }
        if (log.isInfoEnabled()) {
            log.info(transferEntry.toString());
            log.info(((Object)extTransferData).toString());
        }
        return extTransferData;
    }
}

