/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.isc.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.util.ExceptionUtil;

public abstract class BillOperationUtil {
    protected static final String BILLNO = "billno";
    protected Map<String, Object> param = null;

    protected abstract String getOperationKey();

    public void doOperation(Map<String, Object> param) {
        this.param = param;
        Map<String, Object> retData = new HashMap<String, Object>();
        retData.put("code", "200");
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u534f\u540c\u7aef", (String)"BillOperationUtil_0", (String)"scm-common", (Object[])new Object[0]));
        String entityKey = this.getEntityKey();
        String exceptionStr = "";
        if (entityKey == null) {
            msg.append(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\uff01", (String)"BillOperationUtil_1", (String)"scm-common", (Object[])new Object[0]));
        } else {
            OperationArgs opArgs = new OperationArgs();
            opArgs.setReturnData(retData).setMsg(msg).setParam(param);
            String operation = this.getOperationKey();
            DynamicObject[] objs = ORMUtil.load(entityKey, this.getSelectFields(), this.buildCondition(), this.getOrderby());
            if (objs.length == 0) {
                msg.append(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"BillOperationUtil_2", (String)"scm-common", (Object[])new Object[0]));
            } else {
                opArgs.setDynamicObjects(objs);
                try {
                    switch (operation) {
                        case "delete": {
                            this.beforeDelete(opArgs);
                            this.delete(opArgs);
                            this.afterDelete(opArgs);
                            break;
                        }
                        case "alert": {
                            this.beforeAlert(opArgs);
                            this.alert(opArgs);
                            this.afterAlert(opArgs);
                            break;
                        }
                        case "save": {
                            this.beforeSave(opArgs);
                            this.save(opArgs);
                            this.afterSave(opArgs);
                            break;
                        }
                        default: {
                            msg.append(MessageFormat.format(ResManager.loadKDString((String)"\u64cd\u4f5c{0}\u672a\u5b9a\u4e49\uff01", (String)"BillOperationUtil_3", (String)"scm-common", (Object[])new Object[0]), operation));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    exceptionStr = MessageFormat.format(ResManager.loadKDString((String)"\u5f02\u5e38{0}", (String)"BillOperationUtil_4", (String)"scm-common", (Object[])new Object[0]), ExceptionUtil.getStackTrace(e));
                }
            }
            retData = opArgs.getReturnData();
            msg = opArgs.getMsg();
            msg.append(exceptionStr);
        }
        retData.put("msg", msg.toString());
    }

    protected String getSelectFields() {
        return "id,billno,cfmstatus,billstatus";
    }

    protected String getOrderby() {
        return BILLNO;
    }

    protected Map<String, Map<String, Object>> buildCondition() {
        HashMap<String, Map<String, Object>> conditions = new HashMap<String, Map<String, Object>>();
        HashMap billNoMap = new HashMap(1);
        HashSet<Object> billnoSet = new HashSet<Object>();
        billnoSet.add(this.param.get(BILLNO));
        billNoMap.put("in", billnoSet);
        conditions.put(BILLNO, billNoMap);
        return conditions;
    }

    protected void beforeDelete(OperationArgs opArgs) {
    }

    protected abstract String getEntityKey();

    protected void delete(OperationArgs opArgs) {
        block18: {
            DynamicObject[] objs = opArgs.getDynamicObjects();
            HashSet<Object> pks = new HashSet<Object>(objs.length);
            for (DynamicObject object : objs) {
                Object billno = "pur_ordchange".equals(this.getEntityKey()) ? object.get("pobillno") : object.get(BILLNO);
                pks.add(object.getPkValue());
            }
            if (pks.size() > 0) {
                try (TXHandle h = TX.required();){
                    try {
                        OperationResult unAuditResullt = OperationServiceHelper.executeOperate((String)"unaudit", (String)objs[0].getDataEntityType().getName(), (Object[])pks.toArray(), (OperateOption)OperateOption.create());
                        if (unAuditResullt.isSuccess()) {
                            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)objs[0].getDataEntityType().getName(), (Object[])pks.toArray(), (OperateOption)OperateOption.create());
                            if (!deleteResullt.isSuccess()) {
                                StringBuilder message = this.buildErrorMessage(deleteResullt);
                                throw new KDBizException(message.toString());
                            }
                            break block18;
                        }
                        StringBuilder message = this.buildErrorMessage(unAuditResullt);
                        throw new KDBizException(message.toString());
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
        }
    }

    protected StringBuilder buildErrorMessage(OperationResult unAuditResult) {
        StringBuilder message = new StringBuilder(unAuditResult.getMessage());
        message.append(ExceptionUtil.getErrorInfoDetails(unAuditResult.getAllErrorOrValidateInfo()));
        return message;
    }

    protected void afterDelete(OperationArgs opArgs) {
    }

    protected void beforeAlert(OperationArgs opArgs) {
    }

    protected void alert(OperationArgs opArgs) {
    }

    protected void afterAlert(OperationArgs opArgs) {
    }

    protected void beforeSave(OperationArgs opArgs) {
    }

    protected void save(OperationArgs opArgs) {
    }

    protected void afterSave(OperationArgs opArgs) {
    }
}

