/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.kuaidi100.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.kuaidi100.util.KuaidiUtil;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.JacksonJsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class KuaidiMatchNumberHelper {
    private static Log log = LogFactory.getLog(KuaidiMatchNumberHelper.class);
    private static final String URL = "http://www.kuaidi100.com/autonumber/auto";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> executeMatchLogisticsInfo(String number) {
        ArrayList<Map<String, String>> resultMap;
        block12: {
            resultMap = new ArrayList<Map<String, String>>();
            if (!KuaidiUtil.IsExistAccount()) {
                throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u9700\u8981\u914d\u7f6e\u5feb\u9012100\u8d26\u53f7\u624d\u80fd\u67e5\u8be2\u7269\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"kuaidiQueryHelper_5", (String)"scm-common", (Object[])new Object[0])), new Object[0]);
            }
            DynamicObject kuaidiObj = KuaidiUtil.getKuaidi100Info();
            String newpwd = kuaidiObj.getString("newpwd");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("key", newpwd);
            paramMap.put("num", number);
            String respBody = null;
            HttpPost method = new HttpPost(URL);
            CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(500000).build()).build();
            HttpResponse response = null;
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(paramMap.size());
            for (Map.Entry entry : paramMap.entrySet()) {
                parameters.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
            }
            UrlEncodedFormEntity urlEncodedFormEntity = null;
            try {
                urlEncodedFormEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Throwable)e);
            }
            try {
                method.setEntity((HttpEntity)urlEncodedFormEntity);
                response = httpClient.execute((HttpUriRequest)method);
                HttpEntity entity = response.getEntity();
                respBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    log.warn(respBody);
                    break block12;
                }
                try {
                    resultMap.addAll(JacksonJsonUtil.fromJSON(respBody, List.class));
                }
                catch (Exception exception) {
                    Map errorMap = JacksonJsonUtil.fromJSON(respBody, Map.class);
                    String message = (String)errorMap.get("message");
                    String returnCode = (String)errorMap.get("returnCode");
                    throw new KDException(new ErrorCode(returnCode, message), new Object[]{message});
                }
            }
            catch (IOException e) {
                SRMStoreExceptionTraceHelper.saveExceptionData(e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return resultMap;
    }
}

