/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.BillTypeMapParser;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.ConvertRuleKeyPair;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.LongProp;
import kd.bos.form.IFormView;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scm.common.form.CustomBotpSourceBill;

public class ScmPushHolder {
    private boolean hidePushForm = false;
    private String defTargetBill = "";
    private String defRuleId = "";
    private boolean hasNewRight = false;
    private boolean mustSelectRule = false;
    private List<CustomBotpSourceBill> targetBills = new ArrayList<CustomBotpSourceBill>();
    private Push push = null;

    public List<CustomBotpSourceBill> getTargetBills() {
        return this.targetBills;
    }

    public ScmPushHolder(Push push) {
        Map parameters;
        this.push = push;
        if (push != null && (parameters = push.getParameter()) != null) {
            if (parameters.containsKey("hidepushform")) {
                this.hidePushForm = (Boolean)parameters.get("hidepushform");
            }
            if (parameters.containsKey("targetbill")) {
                this.defTargetBill = (String)parameters.get("targetbill");
                if (StringUtils.isBlank((CharSequence)this.defTargetBill)) {
                    this.hidePushForm = false;
                }
            }
            if (parameters.containsKey("ruleid")) {
                this.defRuleId = (String)parameters.get("ruleid");
                if (StringUtils.isBlank((CharSequence)this.defRuleId)) {
                    this.defRuleId = "@all";
                }
            }
            if (parameters.containsKey("ishasright")) {
                this.hasNewRight = (Boolean)parameters.get("ishasright");
            }
            if (parameters.containsKey("mustselectrule")) {
                this.mustSelectRule = (Boolean)parameters.get("mustselectrule");
            }
            this.targetBills = (List)parameters.get("customBotpSourceBills");
        }
    }

    public ConvertOpParameter buildParameter() {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        if (this.push != null) {
            IFormView view = this.push.getView();
            String appId = this.push.getOption().getVariableValue("checkRightAppId", "");
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                opParameter.setAppId(appId);
            }
            if (view instanceof IListView) {
                IListView listView = (IListView)view;
                opParameter.setSelectedRows(listView.getSelectedRows());
            } else if (view instanceof IBillView) {
                IBillView billView = (IBillView)view;
                IBillModel billModel = (IBillModel)billView.getModel();
                ListSelectedRow row = new ListSelectedRow(billModel.getPKValue(), Boolean.valueOf(billModel.getDataEntityType().getPrimaryKey() instanceof LongProp));
                opParameter.setSelectedRows(new ListSelectedRowCollection());
                opParameter.getSelectedRows().add((Object)row);
            }
            if (this.targetBills != null) {
                for (CustomBotpSourceBill targetBill : this.targetBills) {
                    targetBill.dealCustomBillRules(this.push, opParameter, this);
                    targetBill.removeStanderRules(this.push, opParameter, this);
                }
            }
            opParameter.setDefTargetBill(this.defTargetBill);
            opParameter.setDefRuleId(this.defRuleId);
            opParameter.setHasRight(this.hasNewRight);
            opParameter.setMustSelectRule(this.mustSelectRule);
        }
        return opParameter;
    }

    public List<ConvertBill> loadTargetBills(String srcBillId, Set<Long> billTypeIds) {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(10);
        ArrayList<ConvertBill> bills = null;
        if (this.hidePushForm && StringUtils.isNotBlank((CharSequence)this.defTargetBill)) {
            bills = new ArrayList<ConvertBill>();
            ConvertBill targetBill = new ConvertBill();
            targetBill.setEntityNumber(this.defTargetBill);
            bills.add(targetBill);
        } else {
            bills = ConvertMetaServiceHelper.loadConvertBills((String)srcBillId, (ConvertOpType)ConvertOpType.Push);
        }
        if (bills.isEmpty()) {
            return list;
        }
        ArrayList<ConvertRuleKeyPair> crKeys = new ArrayList<ConvertRuleKeyPair>(bills.size());
        for (ConvertBill bill : bills) {
            ConvertRuleKeyPair crKey = new ConvertRuleKeyPair(srcBillId, bill.getEntityNumber());
            crKeys.add(crKey);
        }
        Map allRules = ConvertRuleCache.batchLoadRules(crKeys);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules = this.filterRules(srcBillId, bill, billTypeIds, allRules);
            if (opRules.isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    protected List<ConvertOpRule> filterRules(String srcEntityId, ConvertBill bill, Set<Long> srcBillTypeIds, Map<ConvertRuleKeyPair, List<ConvertRuleElement>> allRules) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(10);
        List<ConvertRuleElement> rules = this.loadRules(srcEntityId, bill.getEntityNumber(), allRules);
        if (rules.isEmpty()) {
            return opRules;
        }
        boolean existBillTypePolicy = false;
        if (srcBillTypeIds != null && !srcBillTypeIds.isEmpty()) {
            for (ConvertRuleElement rule : rules) {
                if (!rule.isEnabled() || rule.getBillTypeMapPolicy().getItems().isEmpty()) continue;
                existBillTypePolicy = true;
                break;
            }
        }
        if (existBillTypePolicy) {
            return this.filterBillType(bill, rules, srcBillTypeIds);
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled() || !this.hidePushForm && !rule.isVisibled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber, Map<ConvertRuleKeyPair, List<ConvertRuleElement>> allRules) {
        ConvertRuleKeyPair key = new ConvertRuleKeyPair(sourceEntityNumber, targetEntityNumber);
        List<ConvertRuleElement> rules = allRules.get(key);
        if (rules == null) {
            return new ArrayList<ConvertRuleElement>(0);
        }
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }

    private List<ConvertOpRule> filterBillType(ConvertBill bill, List<ConvertRuleElement> rules, Set<Long> srcBillTypeIds) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)bill.getEntityNumber());
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>();
        IDataEntityProperty targetBillTypeProp = null;
        if (targetMainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)targetMainType).getBillType())) {
            targetBillTypeProp = targetMainType.findProperty(((BillEntityType)targetMainType).getBillType());
        }
        Map<Object, DynamicObject> objMap = null;
        DynamicObject[] targetBillTypeObjs = null;
        if (targetBillTypeProp != null) {
            objMap = this.loadTargetBillTypeObjs(targetMainType.getName());
            targetBillTypeObjs = objMap.values().toArray(new DynamicObject[0]);
        }
        BillTypeMapParser parser = new BillTypeMapParser();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled() || !this.hidePushForm && !rule.isVisibled()) continue;
            boolean enabled = false;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            if (srcBillTypeIds.isEmpty() || targetBillTypeProp == null) {
                enabled = true;
            } else {
                for (Long srcBillTypeId : srcBillTypeIds) {
                    parser.tryGetTargetBillTypeIds(rule.getBillTypeMapPolicy(), srcBillTypeId, targetBillTypeObjs);
                    if (parser.isCannotPushAnyOne()) continue;
                    if (parser.isCanPushAll()) {
                        enabled = true;
                        opRule.setAllBillType(true);
                        opRule.getInvalidBillTypeIds().addAll(parser.getOutCannotPushBillTypeIds());
                        opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
                        break;
                    }
                    if (parser.getOutBillTypeIds().isEmpty()) continue;
                    enabled = true;
                    opRule.setDefBillType((Long)parser.getOutBillTypeIds().get(0));
                    opRule.getBillTypeIds().addAll(parser.getOutBillTypeIds());
                    break;
                }
            }
            if (!enabled) continue;
            opRules.add(opRule);
        }
        return opRules;
    }

    private Map<Object, DynamicObject> loadTargetBillTypeObjs(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashMap<Object, DynamicObject>();
        }
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)entityNumber)};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
    }
}

