/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.splitrow;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.scm.common.splitrow.ISplitRowParamService;
import kd.scm.common.splitrow.SplitRowModel;
import kd.scm.common.splitrow.SplitRowParamDTO;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSplitRowParamServiceImplPlugin
implements ISplitRowParamService {
    private Integer unitPrecision = 10;
    private ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
    private String qtyField;
    private String unitField;
    private String basicQtyField;
    private String basicUnitField;
    private String asstQtyField;
    private String asstUnitField;
    private String locAmountField;
    private String amountField;
    private String locTaxField;
    private String taxField;
    private String locTaxAmountField;
    private String taxAmountField;
    private String exchrateField;
    private Boolean isReCal;

    public abstract void initConfig();

    public abstract void calSecondaryDevelopment(SplitRowParamDTO var1);

    @Override
    public void calSplitRowFields(SplitRowParamDTO args) {
        this.initConfig();
        this.calculate(args);
    }

    public void calculate(SplitRowParamDTO args) {
        Boolean locTaxAmountIfExist;
        Boolean locTaxIfExist;
        Boolean locAmountIfExist;
        Boolean asstQtyIfExist;
        Boolean basicQtyIfExist;
        DynamicObject dataEntity = args.getDataEntity();
        String entityName = dataEntity.getDataEntityType().getName();
        String entryKey = args.getEntryKey();
        Integer srcRowIndex = args.getSrcRowIndex();
        List<Integer> newRowIndex = args.getNewRowIndex();
        List<SplitRowModel> splitRowModels = args.getPbdSplitRowModels();
        List splitCurrentMetadataKeys = splitRowModels.stream().filter(p -> p.getSplitRow()).map(SplitRowModel::getCurrentMetadataKey).collect(Collectors.toList());
        Boolean qtyBoolIfExist = StringUtils.isNotBlank((CharSequence)this.qtyField) && StringUtils.isNotBlank((CharSequence)this.unitField) && splitCurrentMetadataKeys.contains(this.qtyField);
        if (qtyBoolIfExist.booleanValue()) {
            Map<Integer, BigDecimal> rowQtyMap = this.getRowIndexQtyMapping(dataEntity, entryKey, this.qtyField, this.unitField, srcRowIndex, newRowIndex);
            if (rowQtyMap.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u884c\u672a\u586b\u5199\u6570\u91cf, \u62c6\u5206\u884c\u6570\u91cf\u91d1\u989d\u7b49\u5b57\u6bb5\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"AbstractSplitRowParamServiceImplPlugin_0", (String)"scm-common", (Object[])new Object[0]));
            }
            if (rowQtyMap.values().contains(BigDecimal.ZERO)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62c6\u5206\u884c\u8ba1\u7b97\u6570\u91cf\u4e3a0, \u62c6\u5206\u884c\u6570\u91cf\u91d1\u989d\u7b49\u5b57\u6bb5\u65e0\u6cd5\u8ba1\u7b97\u3002", (String)"AbstractSplitRowParamServiceImplPlugin_0", (String)"scm-common", (Object[])new Object[0]));
            }
            Boolean isReCal = true;
            if (this.isReCal != null) {
                isReCal = this.isReCal;
            }
            this.setQtyValue(dataEntity, srcRowIndex, newRowIndex, rowQtyMap, this.qtyField, entryKey, isReCal);
        }
        if ((basicQtyIfExist = Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.basicQtyField) && StringUtils.isNotBlank((CharSequence)this.basicUnitField) && splitCurrentMetadataKeys.contains(this.basicQtyField))).booleanValue()) {
            Map<Integer, BigDecimal> rowBasicQtyMap = this.getRowIndexQtyMapping(dataEntity, entryKey, this.basicQtyField, this.basicUnitField, srcRowIndex, newRowIndex);
            Boolean isReCal = false;
            this.setQtyValue(dataEntity, srcRowIndex, newRowIndex, rowBasicQtyMap, this.basicQtyField, entryKey, isReCal);
        }
        if ((asstQtyIfExist = Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.asstQtyField) && StringUtils.isNotBlank((CharSequence)this.asstUnitField) && splitCurrentMetadataKeys.contains(this.asstQtyField))).booleanValue()) {
            Map<Integer, BigDecimal> rowAssQtyMap = this.getRowIndexQtyMapping(dataEntity, entryKey, this.asstQtyField, this.asstUnitField, srcRowIndex, newRowIndex);
            Boolean isReCal = false;
            this.setQtyValue(dataEntity, srcRowIndex, newRowIndex, rowAssQtyMap, this.asstQtyField, entryKey, isReCal);
        }
        if ((locAmountIfExist = Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.locAmountField) && StringUtils.isNotBlank((CharSequence)this.amountField) && splitCurrentMetadataKeys.contains(this.locAmountField))).booleanValue()) {
            this.reCurLocalAmount(dataEntity, entityName, entryKey, this.locAmountField, this.amountField, srcRowIndex, newRowIndex);
        }
        if ((locTaxIfExist = Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.locTaxField) && StringUtils.isNotBlank((CharSequence)this.taxField) && splitCurrentMetadataKeys.contains(this.locTaxField))).booleanValue()) {
            this.reCurLocalAmount(dataEntity, entityName, entryKey, this.locTaxField, this.taxField, srcRowIndex, newRowIndex);
        }
        if ((locTaxAmountIfExist = Boolean.valueOf(StringUtils.isNotBlank((CharSequence)this.locTaxAmountField) && StringUtils.isNotBlank((CharSequence)this.taxAmountField) && splitCurrentMetadataKeys.contains(this.locTaxAmountField))).booleanValue()) {
            this.reCurLocalAmount(dataEntity, entityName, entryKey, this.locTaxAmountField, this.taxAmountField, srcRowIndex, newRowIndex);
        }
        this.calSecondaryDevelopment(args);
    }

    protected void reCurLocalAmount(DynamicObject dataEntity, String entityName, String entryKey, String curFieldKey, String amountFieldKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        if (StringUtils.isBlank((CharSequence)this.exchrateField)) {
            return;
        }
        BigDecimal exChangeRate = dataEntity.getBigDecimal(this.exchrateField);
        if (exChangeRate != null && exChangeRate.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection(entryKey);
            this.reCurLocalAmount(dataEntity, billEntry, exChangeRate, curFieldKey, amountFieldKey, srcRowIndex);
            for (Integer rowIndex : newRowIndex) {
                this.reCurLocalAmount(dataEntity, billEntry, exChangeRate, curFieldKey, amountFieldKey, rowIndex);
            }
        }
    }

    protected void reCurLocalAmount(DynamicObject dataEntity, DynamicObjectCollection billEntry, BigDecimal exChangeRate, String curFieldKey, String amountFieldKey, Integer rowIndex) {
        DynamicObject entry = (DynamicObject)billEntry.get(rowIndex.intValue());
        int currencyPrecision = this.getAmtPrecision(dataEntity);
        BigDecimal amount = entry.getBigDecimal(amountFieldKey);
        if (amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal curAmount = amount.multiply(exChangeRate).setScale(currencyPrecision, RoundingMode.HALF_UP);
            entry.set(curFieldKey, (Object)curAmount);
        }
    }

    protected int getAmtPrecision(DynamicObject dynamicObject) {
        int amtPrecision = 6;
        DynamicObject currencyDynamic = dynamicObject.getDynamicObject("loccurr");
        if (currencyDynamic == null) {
            return amtPrecision;
        }
        return currencyDynamic.getInt("amtprecision");
    }

    protected Map<Integer, BigDecimal> getRowIndexQtyMapping(DynamicObject dataEntity, String entryKey, String qtyFieldKey, String unitKey, Integer srcRowIndex, List<Integer> newRowIndex) {
        int rowCount = newRowIndex.size() + 1;
        HashMap<Integer, BigDecimal> rowQtyMap = new HashMap<Integer, BigDecimal>(rowCount);
        DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection(entryKey);
        if (billEntry.isEmpty() || newRowIndex.isEmpty()) {
            return rowQtyMap;
        }
        DynamicObject entry = (DynamicObject)billEntry.get(srcRowIndex.intValue());
        BigDecimal srcQty = entry.getBigDecimal(qtyFieldKey);
        if (srcQty == null || BigDecimal.ZERO.compareTo(srcQty) == 0) {
            return rowQtyMap;
        }
        DynamicObject unit = entry.getDynamicObject(unitKey);
        if (unit != null) {
            this.unitPrecision = unit.getInt("precision");
        }
        BigDecimal average = srcQty.divide(new BigDecimal(rowCount), (int)this.unitPrecision, RoundingMode.DOWN);
        BigDecimal multiply = average.multiply(new BigDecimal(newRowIndex.size()));
        BigDecimal lastRowQty = srcQty.subtract(multiply);
        rowQtyMap.put(srcRowIndex, average);
        for (int i = 0; i < newRowIndex.size() - 1; ++i) {
            rowQtyMap.put(newRowIndex.get(i), average);
        }
        rowQtyMap.put(newRowIndex.get(newRowIndex.size() - 1), lastRowQty);
        return rowQtyMap;
    }

    protected void setQtyValue(DynamicObject dataEntity, Integer srcRowIndex, List<Integer> newRowIndex, Map<Integer, BigDecimal> rowQtyMap, String qtyFieldKey, String entryKey, Boolean isReCal) {
        if (rowQtyMap.isEmpty()) {
            return;
        }
        int intValue = srcRowIndex;
        DynamicObject dynamicObject = (DynamicObject)dataEntity.getDynamicObjectCollection(entryKey).get(intValue);
        dynamicObject.set(qtyFieldKey, (Object)rowQtyMap.get(srcRowIndex));
        if (isReCal.booleanValue()) {
            this.iCalDynamic.proChanged(dataEntity, entryKey, qtyFieldKey, srcRowIndex);
        }
        for (Integer rowIndex : newRowIndex) {
            DynamicObject dynamicObjectNew = (DynamicObject)dataEntity.getDynamicObjectCollection(entryKey).get(rowIndex.intValue());
            dynamicObjectNew.set(qtyFieldKey, (Object)rowQtyMap.get(rowIndex));
            if (!isReCal.booleanValue()) continue;
            this.iCalDynamic.proChanged(dataEntity, entryKey, qtyFieldKey, rowIndex);
        }
    }

    public void setUnitPrecision(Integer unitPrecision) {
        this.unitPrecision = unitPrecision;
    }

    public void setiCalDynamic(ICalDynamic iCalDynamic) {
        this.iCalDynamic = iCalDynamic;
    }

    public void setQtyField(String qtyField) {
        this.qtyField = qtyField;
    }

    public void setUnitField(String unitField) {
        this.unitField = unitField;
    }

    public void setBasicQtyField(String basicQtyField) {
        this.basicQtyField = basicQtyField;
    }

    public void setBasicUnitField(String basicUnitField) {
        this.basicUnitField = basicUnitField;
    }

    public void setAsstQtyField(String asstQtyField) {
        this.asstQtyField = asstQtyField;
    }

    public void setAsstUnitField(String asstUnitField) {
        this.asstUnitField = asstUnitField;
    }

    public void setLocAmountField(String locAmountField) {
        this.locAmountField = locAmountField;
    }

    public void setAmountField(String amountField) {
        this.amountField = amountField;
    }

    public void setLocTaxField(String locTaxField) {
        this.locTaxField = locTaxField;
    }

    public void setTaxField(String taxField) {
        this.taxField = taxField;
    }

    public void setLocTaxAmountField(String locTaxAmountField) {
        this.locTaxAmountField = locTaxAmountField;
    }

    public void setTaxAmountField(String taxAmountField) {
        this.taxAmountField = taxAmountField;
    }

    public void setExchrateField(String exchrateField) {
        this.exchrateField = exchrateField;
    }

    public void setIsReCal(Boolean isReCal) {
        this.isReCal = isReCal;
    }
}

