/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.store;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleLogHelper;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.store.SRMStoreDataTraceStackHelper;
import kd.scm.common.util.ExceptionUtil;

public final class SRMStoreExceptionTraceHelper {
    private static Log log = LogFactory.getLog((String)SRMStoreExceptionTraceHelper.class.getName());

    public static void saveExceptionData(Throwable throwableParam) {
        log.info("runtimeException,message:{},exceptionType:{}", (Object)String.valueOf(throwableParam.getMessage()), (Object)throwableParam.getClass().getName());
        ScDataHandleLogInfo scDataHandleLogInfo = SRMStoreExceptionTraceHelper.getLogInfo("storeexception");
        SRMStoreExceptionTraceHelper.doExecuteSaveData(scDataHandleLogInfo, throwableParam);
    }

    public static void saveWarnData(RuntimeException runtimeExceptionParam) {
        log.info("runtimeException,message:{},exceptionType:{}", (Object)String.valueOf(runtimeExceptionParam.getMessage()), (Object)runtimeExceptionParam.getClass().getName());
        ScDataHandleLogInfo scDataHandleLogInfo = SRMStoreExceptionTraceHelper.getLogInfo("storewarn");
        SRMStoreExceptionTraceHelper.doExecuteSaveData(scDataHandleLogInfo, runtimeExceptionParam);
    }

    private static void doExecuteSaveData(ScDataHandleLogInfo scDataHandleLogInfo, Throwable throwableParam) {
        try {
            scDataHandleLogInfo.setOperateDesc(throwableParam.getClass().getSimpleName());
            SRMStoreDataTraceStackHelper.assembleStack(scDataHandleLogInfo);
            scDataHandleLogInfo.setParams(String.valueOf(throwableParam.getMessage()));
            scDataHandleLogInfo.setParamsTag(ExceptionUtil.getStackTrace(throwableParam));
            scDataHandleLogInfo.setResult("success");
            scDataHandleLogInfo.setResultTag("success");
            scDataHandleLogInfo.setModifyTime(TimeServiceHelper.now());
            scDataHandleLogInfo.setModifier(RequestContext.get().getCurrUserId());
        }
        catch (Throwable throwable) {
            log.error(String.valueOf(throwableParam.getMessage()));
            scDataHandleLogInfo.setResult(String.valueOf(throwable.getMessage()));
            scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace(throwable));
            scDataHandleLogInfo.setModifyTime(TimeServiceHelper.now());
            scDataHandleLogInfo.setModifier(RequestContext.get().getCurrUserId());
        }
        finally {
            ScDataHandleLogHelper.fireInfoScDataLog(scDataHandleLogInfo);
        }
    }

    private static synchronized ScDataHandleLogInfo getLogInfo(String logDimString) {
        ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
        scDataHandleLogInfo.setId(DBServiceHelper.genStringId());
        scDataHandleLogInfo.setEntityDesc("SRMStoreExceptionTraceHelper");
        scDataHandleLogInfo.setLogAppId("pur");
        scDataHandleLogInfo.setLogType("successlog");
        scDataHandleLogInfo.setLogDim(logDimString);
        scDataHandleLogInfo.setState("success");
        try {
            String userName = RequestContext.get().getUserName();
            scDataHandleLogInfo.setUserName(userName == null || userName.isEmpty() ? "administrator" : userName);
        }
        catch (RuntimeException exception) {
            scDataHandleLogInfo.setUserName("administrator");
        }
        try {
            scDataHandleLogInfo.setCreator(RequestContext.get().getCurrUserId());
        }
        catch (RuntimeException exception) {
            scDataHandleLogInfo.setCreator(1L);
        }
        scDataHandleLogInfo.setTraceId(RequestContext.get().getTraceId());
        scDataHandleLogInfo.setCreateTime(TimeServiceHelper.now());
        return scDataHandleLogInfo;
    }
}

