/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.systemjoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.k3cloud.util.InvokeHelper;
import kd.scm.common.k3cloud.util.K3CloudUtil;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import org.json.JSONArray;

public final class HttpJointSystemHelper {
    private static final Log log = LogFactory.getLog(K3CloudUtil.class);
    private static final String DATA_CENTER = "data_center";
    private static final String USER = "user";
    private static final String CONTENT = "newpwd";
    private static final String PROTOCAL = "http_protocal";
    private static final String K3CLOUD = "/K3Cloud/";
    private static final String IP = "server_ip";
    private static final String PORT = "server_port";
    private static final Map map = new HashMap();
    private static final Map needCheckAuthOpMap = new HashMap();

    public static Object sendCustomRequest(Map<String, Object> param, DynamicObject iscLinkData) {
        String ip = String.valueOf(iscLinkData.get(IP));
        String protocal = String.valueOf(iscLinkData.get(PROTOCAL));
        String port = String.valueOf(iscLinkData.get(PORT));
        String url = protocal + "://" + ip + ":" + port + K3CLOUD;
        Object returnMsg = null;
        log.info("sendRequesturl=" + url);
        DataEntityPropertyCollection properties = iscLinkData.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"dum_link")) {
            DynamicObject linkDy = iscLinkData.getDynamicObject("dum_link");
            if (linkDy != null && "k3cloud_sdk".equals(linkDy.getString("number"))) {
                log.info("linksetnumber=" + linkDy.getString("number"));
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                ArrayList<Map<Object, Object>> paramsXK = new ArrayList<Map<Object, Object>>(1);
                HashMap<String, String> map1 = new HashMap<String, String>(1);
                String action = String.valueOf(param.remove("actionName"));
                map1.put("actionName", action);
                paramsXK.add(map1);
                paramsXK.add(param);
                params.put("#data", paramsXK);
                params.put("#needCheckAuthInfo", 1);
                Object custom = map.get("Custom");
                return HttpJointSystemHelper.invokeISCDataCopyService(iscLinkData, custom, params);
            }
            returnMsg = HttpJointSystemHelper.sendHttpRequest(iscLinkData, param, url);
        } else {
            returnMsg = HttpJointSystemHelper.sendHttpRequest(iscLinkData, param, url);
        }
        return returnMsg;
    }

    private static Object sendHttpRequest(DynamicObject iscLinkData, Map<String, Object> param, String url) {
        String returnMsg = null;
        if (HttpJointSystemHelper.doLogin(iscLinkData)) {
            try {
                JSONArray paramStr = InvokeHelper.getJsonParam(param);
                log.info("paramStr=" + paramStr);
                returnMsg = InvokeHelper.Custome(null, paramStr, url);
                log.info("returnMsg=" + returnMsg);
            }
            catch (Exception e) {
                log.warn("@@@\u661f\u7a7a\u767b\u5f55\u5f02\u5e38" + ExceptionUtil.getStackTrace(e));
                throw new KDBizException(ExceptionUtil.getStackTrace(e));
            }
        } else {
            log.info("@@@\u661f\u7a7a\u767b\u5f55\u5f02\u5e38fail");
        }
        return returnMsg;
    }

    public static Object sendStandardRequest(Object param, String opr, String formid, DynamicObject iscLinkData) {
        String ip = String.valueOf(iscLinkData.get(IP));
        String protocal = String.valueOf(iscLinkData.get(PROTOCAL));
        String port = String.valueOf(iscLinkData.get(PORT));
        String url = protocal + "://" + ip + ":" + port + K3CLOUD;
        Object returnMsg = null;
        log.info("sendRequesturl=" + url);
        DataEntityPropertyCollection properties = iscLinkData.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"dum_link")) {
            DynamicObject linkDy = iscLinkData.getDynamicObject("dum_link");
            if (linkDy != null && "k3cloud_sdk".equals(linkDy.getString("number"))) {
                log.info("linksetnumber=" + linkDy.getString("number"));
                Object action = map.get(opr);
                Object needCheckAuth = needCheckAuthOpMap.get(opr);
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                ArrayList<Object> paramsXK = new ArrayList<Object>(1);
                paramsXK.add(formid);
                paramsXK.add(param);
                params.put("#data", paramsXK);
                if (needCheckAuth != null) {
                    params.put("#needCheckAuthInfo", 1);
                }
                return HttpJointSystemHelper.invokeISCDataCopyService(iscLinkData, action, params);
            }
            returnMsg = HttpJointSystemHelper.sendInvokeOperation(iscLinkData, param, opr, formid, url);
        } else {
            returnMsg = HttpJointSystemHelper.sendInvokeOperation(iscLinkData, param, opr, formid, url);
        }
        return returnMsg;
    }

    private static Object invokeISCDataCopyService(DynamicObject iscLinkData, Object action, Map<String, Object> params) {
        try {
            Map res = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"callService", (Object[])new Object[]{iscLinkData.getString("number"), action, params, null});
            if (res != null) {
                return JacksonJsonUtil.toJSON(res.get("result"));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ExceptionUtil.getStackTrace(e));
        }
        return null;
    }

    private static Object sendInvokeOperation(DynamicObject iscLinkData, Object param, String opr, String formid, String url) {
        String returnMsg = null;
        if (HttpJointSystemHelper.doLogin(iscLinkData)) {
            try {
                returnMsg = InvokeHelper.invokeStandardOperation(opr, formid, param, url);
                log.info("returnMsg=" + returnMsg);
            }
            catch (Exception e) {
                log.warn("@@@\u661f\u7a7a\u767b\u5f55\u5f02\u5e38" + ExceptionUtil.getStackTrace(e));
                throw new KDBizException(ExceptionUtil.getStackTrace(e));
            }
        } else {
            log.info("@@@\u661f\u7a7a\u767b\u5f55\u5f02\u5e38fail");
        }
        return returnMsg;
    }

    public static boolean doLogin(DynamicObject iscLinkData) {
        boolean loginResult = false;
        try {
            String ip = String.valueOf(iscLinkData.get(IP));
            String protocal = String.valueOf(iscLinkData.get(PROTOCAL));
            String data_center = String.valueOf(iscLinkData.get(DATA_CENTER));
            String user = String.valueOf(iscLinkData.get(USER));
            String password = String.valueOf(iscLinkData.get(CONTENT));
            String port = String.valueOf(iscLinkData.get(PORT));
            String url = protocal + "://" + ip + ":" + port + K3CLOUD;
            loginResult = InvokeHelper.Login(data_center, user, password, 2052, url);
        }
        catch (Exception e) {
            SRMStoreExceptionTraceHelper.saveExceptionData(e);
            throw new KDBizException(ResManager.loadKDString((String)"\u767b\u5f55\u661f\u7a7a\u5931\u8d25", (String)"K3CloudUtil_0", (String)"scm-common", (Object[])new Object[0]) + ExceptionUtil.getStackTrace(e));
        }
        return loginResult;
    }

    static {
        map.put("Save", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Save.common.kdsvc");
        map.put("Delete", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Delete.common.kdsvc");
        map.put("View", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.View.common.kdsvc");
        map.put("ExecuteBillQuery", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc");
        map.put("Submit", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Submit.common.kdsvc");
        map.put("Audit", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Audit.common.kdsvc");
        map.put("UnAudit", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.UnAudit.common.kdsvc");
        map.put("StatusConvert", "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.StatusConvert.common.kdsvc");
        map.put("Custom", "Kingdee.K3.SCM.CQ.ServicesStub.DynamicScmService.ProcessRequest.common.kdsvc");
        needCheckAuthOpMap.put("Custom", 1);
    }
}

