/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.systemjoint;

import java.util.Collection;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.systemjoint.CosmicCloudSystemJointService;
import kd.scm.common.systemjoint.EASSystemJointService;
import kd.scm.common.systemjoint.ISystemJointService;
import kd.scm.common.systemjoint.XKSystemJointService;

public final class SystemJointServiceHelper {
    public static ISystemJointService getSystemJointServiceFactory(String jointSystemType) {
        ISystemJointService systemJointService = null;
        switch (jointSystemType) {
            case "eas": {
                systemJointService = new EASSystemJointService();
                break;
            }
            case "self": {
                systemJointService = new CosmicCloudSystemJointService();
                break;
            }
            case "xkcloud": {
                systemJointService = new XKSystemJointService();
                break;
            }
        }
        return systemJointService;
    }

    public static Object executeStdMService(String jointSystemType, String cloudId, String appId, String serviceName, String methodName, Object ... params) {
        ISystemJointService systemJointService = SystemJointServiceHelper.getSystemJointServiceFactory(jointSystemType);
        return systemJointService != null ? systemJointService.executeStdMServiceSend(cloudId, appId, serviceName, methodName, params) : null;
    }

    public static Object executeISCMService(String jointSystemType, String cloudId, String appId, String serviceName, String methodName, String connectNumber, String iscSourceNumber, Map<String, Object> customMap, String proxyUser) {
        ISystemJointService systemJointService = SystemJointServiceHelper.getSystemJointServiceFactory(jointSystemType);
        return systemJointService != null ? systemJointService.executeISCMServiceSend(cloudId, appId, serviceName, methodName, connectNumber, iscSourceNumber, customMap, proxyUser) : null;
    }

    public static boolean verifyCallJointService(String entityNumber, Collection<Long> billIds) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"verifyCallJointService", (String)entityNumber, (String)"businesstype", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, (String)"id");
        Throwable throwable = null;
        if (dataSet != null) {
            if (throwable != null) {
                try {
                    dataSet.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                dataSet.close();
            }
        }
        return false;
    }

    public static boolean verifyCallJointService(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return false;
        }
        return false;
    }
}

