/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.systemjoint;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.systemjoint.ISystemJointService;
import kd.scm.common.systemjoint.SystemJointException;

public final class XKSystemJointService
implements ISystemJointService {
    private static final Log log = LogFactory.getLog(XKSystemJointService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeISCCustomApiMServiceSend(String cloudId, String appId, String serviceName, String methodName, String customApiNumber, Map<String, Object> customMap, String proxyUser) throws SystemJointException {
        Object resultData = "";
        if (log.isInfoEnabled()) {
            log.info("cloudId:{},appId:{},serviceName:{},methodName:{},customApiNumber:{},customMap:{},proxyUser:{}", new Object[]{cloudId, appId, serviceName, methodName, customApiNumber, SerializationUtils.toJsonString(customMap), proxyUser});
        }
        try {
            Object exception;
            resultData = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{customApiNumber, customMap, proxyUser});
            if (resultData instanceof Map && (exception = ((Map)resultData).get("exception")) != null) {
                throw new SystemJointException(exception.toString());
            }
        }
        catch (RuntimeException exception) {
            SRMStoreExceptionTraceHelper.saveWarnData(exception);
            String message = exception.getClass().getName() + ":" + exception.getMessage();
            throw new KDException(new ErrorCode("SYSTEMJOINTEXCEPTION", message), new Object[0]);
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData(throwable);
        }
        finally {
            log.debug("\u8c03\u7528\u82cd\u7a79\u96c6\u6210\u4e91\u5fae\u670d\u52a1\u670d\u52a1\u7ed3\u675f\u3002");
        }
        return resultData;
    }
}

