/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.IHerlperService;
import kd.scm.common.eip.IOperationService;

public class ApiPluginConfigUtil {
    public static DynamicObject getExtendsConfig(String apiName) {
        HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>(4);
        HashMap<String, String> statusParam = new HashMap<String, String>(1);
        statusParam.put("=", "C");
        param.put("status", statusParam);
        HashMap<String, String> enableParam = new HashMap<String, String>(1);
        enableParam.put("=", "1");
        param.put("enable", enableParam);
        HashMap<String, String> apiNameParam = new HashMap<String, String>(1);
        apiNameParam.put("=", apiName);
        param.put("apiname", apiNameParam);
        String selectFields = "id,name,entitykey,plugin,apiname";
        DynamicObject[] dynaObjs = ORMUtil.load("pur_apipluginconfig", selectFields, param);
        return dynaObjs.length == 0 ? null : dynaObjs[0];
    }

    public static String getExtendsPlugin(String apiName) {
        DynamicObject pluginConfig;
        String plugin = null;
        if (null != apiName && null != (pluginConfig = ApiPluginConfigUtil.getExtendsConfig(apiName))) {
            plugin = pluginConfig.getString("plugin");
        }
        return plugin;
    }

    public static IHerlperService getPluginInstance(String apiName) {
        String plugin = ApiPluginConfigUtil.getExtendsPlugin(apiName);
        IHerlperService helperService = null;
        Object service = ApiPluginConfigUtil.refelectPluginInstance(plugin);
        if (null != service && service instanceof IHerlperService) {
            helperService = (IHerlperService)service;
        }
        return helperService;
    }

    public static IOperationService getPluginInstance(String apiName, boolean isOperation) {
        String plugin = ApiPluginConfigUtil.getExtendsPlugin(apiName);
        IOperationService operationService = null;
        Object service = ApiPluginConfigUtil.refelectPluginInstance(plugin);
        if (null != service && service instanceof IOperationService) {
            operationService = (IOperationService)service;
        }
        return operationService;
    }

    public static Object refelectPluginInstance(String plugin) {
        Object service = null;
        if (null == plugin) {
            return service;
        }
        try {
            service = Class.forName(plugin).newInstance();
        }
        catch (InstantiationException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(e.getMessage());
        }
        return service;
    }
}

