/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class AttachmentUtil {
    private static Log log = LogFactory.getLog(AttachmentUtil.class);

    public static DynamicObject createAttachmentData(DynamicObject bill, Map<String, Object> attachMap) {
        ORM orm = ORM.create();
        DynamicObject attachment = orm.newDynamicObject("bos_attachment");
        attachment.set("id", (Object)orm.genLongId("bos_attachment"));
        attachment.set("FNUMBER", attachMap.get("id"));
        attachment.set("FBillType", (Object)bill.getDataEntityType().getName());
        attachment.set("FTEMPPAGEID", (Object)"");
        attachment.set("FInterID", (Object)String.valueOf(bill.getPkValue()));
        Date today = new Date();
        attachment.set("fcreatetime", (Object)today);
        String name = String.valueOf(attachMap.get("name"));
        attachment.set("FaliasFileName", (Object)(name + "." + attachMap.get("simpleName")));
        attachment.set("FAttachmentName", (Object)(name + "." + attachMap.get("simpleName")));
        attachment.set("FExtName", attachMap.get("simpleName"));
        attachment.set("FATTACHMENTSIZE", attachMap.get("sizeInByte"));
        attachment.set("FFileId", attachMap.get("url"));
        attachment.set("FCREATEMEN", (Object)Long.valueOf(RequestContext.get().getUserId()));
        attachment.set("FTEMPPAGEID", (Object)"");
        attachment.set("fattachmentpanel", (Object)"attachmentpanel");
        Object description = attachMap.get("description");
        if (description != null && String.valueOf(description).length() > 0 && !String.valueOf(description).equals("null")) {
            attachment.set("FDESCRIPTION", description);
        }
        return attachment;
    }

    public static DynamicObject createAttachmentData(DynamicObject bill, DynamicObject attach) {
        ORM orm = ORM.create();
        DynamicObject attachment = orm.newDynamicObject("bos_attachment");
        attachment.set("id", (Object)orm.genLongId("bos_attachment"));
        attachment.set("FNUMBER", attach.get("FNUMBER"));
        attachment.set("FBillType", (Object)bill.getDataEntityType().getName());
        attachment.set("FTEMPPAGEID", attach.get("FTEMPPAGEID"));
        attachment.set("FInterID", (Object)String.valueOf(bill.getPkValue()));
        Date today = new Date();
        attachment.set("fcreatetime", (Object)today);
        attachment.set("FaliasFileName", attach.get("FaliasFileName"));
        attachment.set("FAttachmentName", attach.get("FAttachmentName"));
        attachment.set("FExtName", attach.get("FExtName"));
        attachment.set("FATTACHMENTSIZE", attach.get("FATTACHMENTSIZE"));
        attachment.set("FFileId", attach.get("FFileId"));
        attachment.set("FCREATEMEN", attach.get("fcreatemen.id"));
        attachment.set("FTEMPPAGEID", attach.get("FTEMPPAGEID"));
        attachment.set("fattachmentpanel", (Object)"attachmentpanel");
        attachment.set("FDESCRIPTION", attach.get("FDESCRIPTION"));
        return attachment;
    }

    public static String uploadFile(InputStream in, Map<String, Object> attachMap) {
        String url = "";
        String fileName = String.valueOf(attachMap.get("name"));
        String uuid = String.valueOf(attachMap.get("uid"));
        String fileType = String.valueOf(attachMap.get("simpleName"));
        String tenantId = CacheKeyUtil.getAcctId();
        StringBuilder pathSb = new StringBuilder();
        String path = "";
        path = pathSb.append("/public/attachment/").append(tenantId).append("/pur/").append(uuid).append('/').append(fileName).append('.').append(fileType).toString();
        FileItem fileItem = new FileItem(fileName + "." + fileType, path, in);
        FileService service = FileServiceFactory.getAttachmentFileService();
        url = service.upload(fileItem);
        if (!StringUtils.isEmpty((String)url)) {
            log.info("url=======>" + url);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            throw new KDBizException(ExceptionUtil.getStackTrace(e));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getFileAndOut(String url, Map<String, Object> attachMap) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        if (url == null || "".equals(url.trim())) {
            throw new KDBizException("url is empty.");
        }
        HttpGet get = null;
        InputStream inputStream = null;
        FileOutputStream out = null;
        try {
            int index;
            URI uri = new URI(url);
            get = new HttpGet(uri);
            HttpResponse e = client.execute((HttpUriRequest)get);
            inputStream = e.getEntity().getContent();
            byte[] bytes = new byte[1024];
            StringBuilder filePath = new StringBuilder();
            filePath.append("D:").append(File.separator).append("work").append(File.separator).append("testFile").append(File.separator);
            File file = new File(filePath.toString(), FilenameUtils.getName((String)("" + attachMap.get("name") + "." + attachMap.get("simpleName"))));
            out = new FileOutputStream(file);
            while ((index = inputStream.read(bytes)) != -1) {
                out.write(bytes, 0, index);
                out.flush();
            }
        }
        catch (IOException e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    throw new KDBizException(ExceptionUtil.getStackTrace(ioException));
                }
            }
            throw new KDBizException(ExceptionUtil.getStackTrace(e));
        }
        catch (URISyntaxException e) {
            log.info(e.toString());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioException) {
                    log.error((Throwable)ioException);
                }
            }
        }
        return inputStream;
    }

    public static InputStream getFile(String url) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        if (url == null || "".equals(url.trim())) {
            throw new KDBizException("url is empty.");
        }
        HttpGet get = null;
        InputStream inputStream = null;
        try {
            int len;
            URI uri = new URI(url);
            get = new HttpGet(uri);
            HttpResponse e = client.execute((HttpUriRequest)get);
            inputStream = e.getEntity().getContent();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            inputStream = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception exception) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    throw new KDBizException(ExceptionUtil.getStackTrace(ioException));
                }
            }
            throw new KDBizException(ExceptionUtil.getStackTrace(exception));
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return inputStream;
    }

    public static String getUrl(String attachId) {
        StringBuilder urlSb = new StringBuilder();
        StringBuilder urlSufix = new StringBuilder();
        String token = ApiUtil.Login();
        try {
            token = URLEncoder.encode(token, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(ExceptionUtil.getStackTrace(e));
        }
        urlSb.append(EipConfigration.getHOST()).append(':').append(EipConfigration.getPORT()).append("/easportal/eip/").append("getAttachment");
        urlSufix.append("?id=").append(attachId).append("&token=").append(token);
        return urlSb.append((CharSequence)urlSufix).toString();
    }

    public static Map<String, Object> copyAttachment(String sourceBillName, long sourceBillId, String sourceAttachPanel, String targetBillName, long targetBillId, String targetAttachPanel) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("FInterID", "=", (Object)String.valueOf(sourceBillId)), new QFilter("FBillType", "=", (Object)sourceBillName), new QFilter("fattachmentpanel", "=", (Object)sourceAttachPanel)};
        String selectFileds = DynamicObjectUtil.getSelectfields("bos_attachment", false);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFileds, (QFilter[])filters);
        int fInterIDIdx = 0;
        int fBillTypeIdx = 1;
        int fattachmentpanelIdx = 2;
        log.info("@@copyAttachment\u8fc7\u6ee4\u6761\u4ef6:" + filters[fInterIDIdx] + "&" + filters[fBillTypeIdx] + "&" + filters[fattachmentpanelIdx] + "\u67e5\u8be2\u5230\u9644\u4ef6" + objs.length + "\u4e2a");
        ArrayList<DynamicObject> attchList = new ArrayList<DynamicObject>(objs.length);
        long[] ids = orm.genLongIds("bos_attachment", objs.length);
        int index = 0;
        for (DynamicObject attach : objs) {
            String name = (String)attach.get("fattachmentname");
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            dynamicObject.set("id", (Object)ids[index++]);
            dynamicObject.set("FNUMBER", attach.get("fnumber"));
            dynamicObject.set("FBillType", (Object)targetBillName);
            dynamicObject.set("FInterID", (Object)String.valueOf(targetBillId));
            Date today = new Date();
            dynamicObject.set("FModifyTime", (Object)today);
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("FaliasFileName", (Object)name);
            log.info("@@\u9644\u4ef6\u540d\u79f0:" + name);
            dynamicObject.set("FAttachmentName", (Object)name);
            dynamicObject.set("FExtName", attach.get("fextname"));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("fattachmentsize"));
            dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getUserId());
            dynamicObject.set("fattachmentpanel", (Object)targetAttachPanel);
            dynamicObject.set("fdescription", attach.get("fdescription"));
            dynamicObject.set("FFileId", attach.get("FFileId"));
            attchList.add(dynamicObject);
        }
        if (attchList != null && attchList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])attchList.toArray(new DynamicObject[0]));
        }
        return resultMap;
    }

    public static void copyAttachmentByAttNumber(String sourceBillName, long sourceBillId, String sourceAttachPanel, String targetBillName, long targetBillId, String targetAttachPanel, List<String> attNumbers) {
        QFilter numberFilter = new QFilter("fnumber", "in", attNumbers);
        List<QFilter> filters = AttachmentUtil.getFilters(sourceBillName, sourceBillId, sourceAttachPanel);
        filters.add(numberFilter);
        AttachmentUtil.copyAttachmentByFilters(targetBillName, targetBillId, targetAttachPanel, filters);
    }

    public static List<QFilter> getFilters(String sourceBillName, long sourceBillId, String sourceAttachPanel) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("FInterID", "=", (Object)String.valueOf(sourceBillId)));
        qFilters.add(new QFilter("FBillType", "=", (Object)sourceBillName));
        qFilters.add(new QFilter("fattachmentpanel", "=", (Object)sourceAttachPanel));
        return qFilters;
    }

    public static List<QFilter> getFilters(String sourceBillName, Set<String> sourceBillId, String sourceAttachPanel) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("FInterID", "in", sourceBillId));
        qFilters.add(new QFilter("FBillType", "=", (Object)sourceBillName));
        qFilters.add(new QFilter("fattachmentpanel", "=", (Object)sourceAttachPanel));
        return qFilters;
    }

    public static List<QFilter> getFilters(String sourceBillName, List<Long> sourceBillIds, String sourceAttachPanel) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        HashSet<String> newSID = new HashSet<String>(sourceBillIds.size());
        for (Long sid : sourceBillIds) {
            newSID.add(String.valueOf(sid));
        }
        qFilters.add(new QFilter("FInterID", "in", newSID));
        qFilters.add(new QFilter("FBillType", "=", (Object)sourceBillName));
        qFilters.add(new QFilter("fattachmentpanel", "=", (Object)sourceAttachPanel));
        return qFilters;
    }

    public static void copyAttachmentByFilters(String targetBillName, long targetBillId, String targetAttachPanel, List<QFilter> filters) {
        log.info("@@copyAttachmentByFilters:" + filters);
        ORM orm = ORM.create();
        String selectFileds = DynamicObjectUtil.getSelectfields("bos_attachment", false);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectFileds, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<DynamicObject> attchList = new ArrayList<DynamicObject>(objs.length);
        long[] ids = orm.genLongIds("bos_attachment", objs.length);
        int index = 0;
        for (DynamicObject attach : objs) {
            String name = (String)attach.get("fattachmentname");
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            dynamicObject.set("id", (Object)ids[index++]);
            dynamicObject.set("FNUMBER", attach.get("fnumber"));
            dynamicObject.set("FBillType", (Object)targetBillName);
            dynamicObject.set("FInterID", (Object)String.valueOf(targetBillId));
            Date today = new Date();
            dynamicObject.set("FModifyTime", (Object)today);
            dynamicObject.set("fcreatetime", (Object)today);
            dynamicObject.set("FaliasFileName", (Object)name);
            dynamicObject.set("FAttachmentName", (Object)name);
            log.info("@@\u9644\u4ef6\u540d\u79f0:" + name);
            dynamicObject.set("FExtName", attach.get("fextname"));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("fattachmentsize"));
            dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getUserId());
            dynamicObject.set("fattachmentpanel", (Object)targetAttachPanel);
            dynamicObject.set("fdescription", attach.get("fdescription"));
            dynamicObject.set("FFileId", attach.get("FFileId"));
            attchList.add(dynamicObject);
        }
        if (attchList != null && attchList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])attchList.toArray(new DynamicObject[0]));
        }
    }

    public static void deleteAttachements(String billName, long billId, String attachPanel) {
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])AttachmentUtil.getFilters(billName, billId, attachPanel).toArray(new QFilter[0]));
    }

    public static void deleteAttachements(String billName, List<Long> billIds, String attachPanel) {
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])AttachmentUtil.getFilters(billName, billIds, attachPanel).toArray(new QFilter[0]));
    }

    public static DynamicObjectCollection getAttachements(String billName, long billId, String attachPanel, String selelctField) {
        return QueryServiceHelper.query((String)"bos_attachment", (String)selelctField, (QFilter[])AttachmentUtil.getFilters(billName, billId, attachPanel).toArray(new QFilter[0]));
    }

    public static DynamicObjectCollection getAttachements(String billName, Set<String> billId, String attachPanel, String selelctField) {
        return QueryServiceHelper.query((String)"bos_attachment", (String)selelctField, (QFilter[])AttachmentUtil.getFilters(billName, billId, attachPanel).toArray(new QFilter[0]));
    }

    public static void deleteAttachmentFile(String formId, Object billId, List<Object> fileUidList) {
        for (Object fileUid : fileUidList) {
            AttachmentServiceHelper.remove((String)formId, (Object)billId, (Object)fileUid);
        }
    }

    public static void bindAttachmentFileNew(String formId, String attachmentPanel, Object billId, String uid, String fileName, int size, String bindUrl) {
        ArrayList data = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uid", uid);
        map.put("name", fileName);
        map.put("url", bindUrl);
        map.put("size", size);
        data.add(map);
        AttachmentServiceHelper.upload((String)formId, (Object)billId, (String)attachmentPanel, data);
    }

    public static List<Map<String, Object>> getAttachmentFile(String entityNumber, Object pkId, String attachmentPanel) {
        List attachments = AttachmentServiceHelper.getAttachments((String)entityNumber, (Object)pkId, (String)attachmentPanel);
        return attachments;
    }

    public static void reUploadAtt(DynamicObjectCollection attachments, DynamicObjectCollection attCol) {
        if (attachments == null) {
            return;
        }
        boolean timeUp = false;
        StringBuilder attName = new StringBuilder();
        for (DynamicObject attachment : attachments) {
            DynamicObject bdAttachment = (DynamicObject)attachment.get(1);
            if (bdAttachment == null) continue;
            String url = bdAttachment.getString("url");
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            attObj.set("name", (Object)bdAttachment.getString("name"));
            attObj.set("size", (Object)bdAttachment.getString("size"));
            if (!url.contains("configKey")) {
                attObj.set("url", (Object)url);
            } else {
                String reUploadUrl = AttachmentUtil.uploadTempFile(url, bdAttachment.getString("name"));
                if ("field times up".equals(reUploadUrl)) {
                    timeUp = true;
                    if (attName.length() > 0) {
                        attName.append(",");
                    }
                    attName.append(bdAttachment.getString("name"));
                }
                attObj.set("url", (Object)reUploadUrl);
            }
            attObj.set("uid", (Object)("rc-upload-" + UUID.randomUUID()));
            attObj.set("tempfile", (Object)1);
            ORM orm = ORM.create();
            long id = orm.genLongId("bd_attachment");
            attObj.set("id", (Object)id);
            attObj.set("pageid", (Object)"");
            attObj.set("number", (Object)UUID.randomUUID().toString().substring(10));
            attObj.set("status", (Object)"B");
            Object lastModified = bdAttachment.get("modifytime");
            attObj.set("modifytime", lastModified);
            attObj.set("type", bdAttachment.get("type"));
            attObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attObj});
            attCol.addNew().set("fbasedataid", (Object)attObj);
        }
        if (timeUp) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6{0}\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SrmSupChgUtil_0", (String)"scm-common", (Object[])new Object[]{attName.toString()}));
        }
    }

    private static String uploadTempFile(String url, String name) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String downUrl = "";
        try {
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            FileService fs = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)name);
            FileItem fileItem = new FileItem(name, pathParam, in);
            downUrl = service.upload(fileItem);
        }
        catch (Exception e) {
            return "field times up";
        }
        return downUrl;
    }
}

