/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.botpinterface.IHandleAfterPushBill;

public class BOTPUtil {
    private static Log log = LogFactory.getLog((String)"BOTPUtil");

    public static Map<String, Object> pushBill(String sourceBill, String targetBill, DynamicObject sourceObj, Map<String, Object> defaultValue) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("billid", 0);
        resultMap.put("message", "");
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceBill);
        pushArgs.setTargetEntityNumber(targetBill);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(sourceObj.getPkValue());
        selectedRowList.add(row);
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetBill);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        if (result.isSuccess()) {
            OperationResult saveResult;
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            if (defaultValue != null) {
                for (Map.Entry<String, Object> map : defaultValue.entrySet()) {
                    ((DynamicObject)targetData.get(0)).set(map.getKey(), map.getValue());
                }
            }
            if ((saveResult = SaveServiceHelper.saveOperate((String)targetBill, (DynamicObject[])targetData.toArray(new DynamicObject[0]), null)).isSuccess()) {
                resultMap.put("billid", ((DynamicObject)targetData.get(0)).getLong("id"));
            } else {
                resultMap.put("succed", Boolean.FALSE);
                StringBuilder errMsg = new StringBuilder();
                for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                    errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                }
                resultMap.put("message", errMsg);
            }
        } else {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", result.getMessage());
        }
        return resultMap;
    }

    public static Map<String, HashSet<Long>> getTrackDownBill(Object[] objects, String srcEntity, Map<String, String> targetEntityOfPro) {
        return BOTPUtil.getTrackDownBillByFilter(objects, srcEntity, targetEntityOfPro, null);
    }

    public static Map<String, HashSet<Long>> getTrackDownBillByFilter(Object[] objects, String srcEntity, Map<String, String> targetEntityOfPro, QFilter statusFilter) {
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>(targetEntityOfPro.size());
        ArrayList<String> inqueryBillNo = new ArrayList<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)srcEntity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objects)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                inqueryBillNo.add(row.getString("billno"));
            }
        }
        for (Map.Entry<String, String> entry : targetEntityOfPro.entrySet()) {
            String entityKey = entry.getKey();
            String pro = entry.getValue();
            if (entityKey.isEmpty() || pro.isEmpty()) continue;
            QFilter filter = new QFilter(pro, "in", inqueryBillNo);
            if (null != statusFilter) {
                filter = filter.and(statusFilter);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)entityKey, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"id");
            Throwable throwable = null;
            try {
                HashSet<Long> pkIds = new HashSet<Long>();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    pkIds.add(row.getLong("id"));
                }
                resultMap.put(entityKey, pkIds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return resultMap;
    }

    public static void pushBill(String srcEntityKey, String targetEntityKey, Object id, List<Object> entryIds, String targetEntryEntityKey, IHandleAfterPushBill handleAfterPushBill) {
        ConvertOperationResult result;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setBuildConvReport(false);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(16);
        if (entryIds == null || entryIds.isEmpty()) {
            ListSelectedRow row = new ListSelectedRow((Object)Long.valueOf(String.valueOf(id)));
            selectedRowList.add(row);
        } else {
            for (Object e : entryIds) {
                ListSelectedRow row = new ListSelectedRow((Object)Long.valueOf(String.valueOf(id)));
                row.setEntryEntityKey(targetEntryEntityKey);
                row.setEntryPrimaryKeyValue(e);
                selectedRowList.add(row);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        try {
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
        }
        catch (Exception exception) {
            log.warn(srcEntityKey + "\u4e0b\u63a8" + targetEntityKey + "\u5931\u8d25\u539f\u56e0\uff1a" + exception.getMessage());
            throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BOTPUtil_0", (String)"scm-common", (Object[])new Object[0])), new Object[]{exception.getMessage()});
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
        if (!result.isSuccess()) {
            log.warn("@@\u4e0b\u63a8\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + result.getMessage() + srcEntityKey + "-" + targetEntityKey + "-" + id + "-" + entryIds + "-" + result.getBillReports());
            throw new KDBizException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BOTPUtil_0", (String)"scm-common", (Object[])new Object[0])), new Object[]{result.getMessage()});
        }
        List targetData = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainEntityType);
        handleAfterPushBill.process(targetData);
    }
}

