/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.JacksonJsonUtil;
import net.sf.json.JSONArray;

public final class BillFormUtil {
    private static final String TARGETKEY = "_submaintab_";

    public static FormShowParameter assembleShowDynamicFormParam(String formId, Map<String, Object> customParams, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(showType);
        if (customParams != null) {
            parameter.setCustomParams(customParams);
        }
        if (closeCallBack != null) {
            parameter.setCloseCallBack(closeCallBack);
        }
        return parameter;
    }

    public static ListShowParameter assembleShowListFormParam(String formId, Map<String, Object> customParams, CloseCallBack closeCallBack) {
        return BillFormUtil.assembleShowListFormParam(formId, customParams, closeCallBack, ShowType.MainNewTabPage);
    }

    public static ListShowParameter assembleShowListFormParam(String formId, Map<String, Object> customParams, CloseCallBack closeCallBack, ShowType showtype) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formId);
        parameter.getOpenStyle().setTargetKey(TARGETKEY);
        parameter.getOpenStyle().setShowType(showtype);
        parameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        if (customParams != null) {
            parameter.setCustomParams(customParams);
        }
        if (closeCallBack != null) {
            parameter.setCloseCallBack(closeCallBack);
        }
        return parameter;
    }

    public static BillShowParameter assembleShowBillFormParam(String formId, ShowType showType, OperationStatus status, long id, Map<String, Object> params, CloseCallBack closeCallBack) {
        BillShowParameter param = new BillShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (id != 0L) {
            param.setPkId((Object)id);
            if (status.equals((Object)OperationStatus.ADDNEW)) {
                param.setStatus(OperationStatus.ADDNEW);
            } else if (status.equals((Object)OperationStatus.EDIT)) {
                param.setStatus(OperationStatus.EDIT);
            } else {
                param.setStatus(OperationStatus.VIEW);
            }
        }
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        return param;
    }

    public static Map<String, Object> getCustomParams(Map<String, Object> showParameterMap) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Object showParameterValue = showParameterMap.get("customfilter");
        if (showParameterValue != null) {
            if (showParameterValue instanceof String) {
                Map map = JacksonJsonUtil.fromJson((String)showParameterValue, Map.class);
                returnMap.putAll(map);
            } else if (showParameterValue instanceof Map) {
                returnMap.putAll((Map)showParameterValue);
            }
        }
        return returnMap;
    }

    public static Map<String, Map<String, Object>> getCustomParamsForList(Map<String, Object> showParameterMap) {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        Object showParameterValue = showParameterMap.get("customfilter");
        if (showParameterValue != null) {
            JSONArray object = JSONArray.fromObject((Object)URLDecoder.decode(showParameterValue.toString()));
            HashSet idSet = new HashSet();
            if (object != null && !object.isEmpty()) {
                idSet.addAll(object);
            }
            if (!idSet.isEmpty()) {
                HashMap billMap = new HashMap();
                billMap.put("in", idSet);
                filterMap.put("materialentry.pobillid", billMap);
            }
        }
        return filterMap;
    }

    public static Map<String, Map<String, Object>> assembleFormParamMap(Map<String, Object> showParameterMap) {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Object> entry : showParameterMap.entrySet()) {
            switch (entry.getKey()) {
                case "purorg": {
                    HashMap<String, Long> purOrgMap = new HashMap<String, Long>();
                    purOrgMap.put("=", BillFormUtil.NumberToPkId("bos_org", (String)entry.getValue()));
                    filterMap.put("org", purOrgMap);
                    break;
                }
                case "billid": {
                    HashMap<String, Object> billMap = new HashMap<String, Object>();
                    billMap.put("=", entry.getValue());
                    filterMap.put("materialentry.pobillid", billMap);
                    break;
                }
                case "entryentityid": {
                    HashMap<String, Object> entryIdMap = new HashMap<String, Object>();
                    entryIdMap.put("in", entry.getValue());
                    filterMap.put("materialentry.poentryid", entryIdMap);
                    break;
                }
                case "invorg": {
                    if ("0".equals(entry.getValue().toString())) break;
                    HashMap<String, Object> invorg = new HashMap<String, Object>();
                    invorg.put("=", entry.getValue());
                    filterMap.put("invorg", invorg);
                    break;
                }
                case "rcvorg": {
                    if ("0".equals(entry.getValue().toString())) break;
                    HashMap<String, Object> rcvOrg = new HashMap<String, Object>();
                    rcvOrg.put("=", entry.getValue());
                    filterMap.put("rcvorg", rcvOrg);
                    break;
                }
                case "material": {
                    if ("0".equals(entry.getValue().toString())) break;
                    HashMap<String, Object> material = new HashMap<String, Object>();
                    material.put("=", entry.getValue());
                    filterMap.put("materialentry.material", material);
                    break;
                }
                case "supplier": {
                    if ("0".equals(entry.getValue().toString())) break;
                    HashMap<String, Object> supplier = new HashMap<String, Object>();
                    supplier.put("=", entry.getValue());
                    filterMap.put("supplier", supplier);
                    break;
                }
                case "pkidcoll": {
                    HashMap<String, Object> billidMap = new HashMap<String, Object>();
                    billidMap.put("in", entry.getValue());
                    filterMap.put("id", billidMap);
                    break;
                }
                case "billdate": {
                    HashMap<String, Object> billDateMap = new HashMap<String, Object>();
                    billDateMap.put("<=", entry.getValue());
                    filterMap.put("billdate", billDateMap);
                    break;
                }
                case "delidate": {
                    HashMap<String, Object> deliDateMap = new HashMap<String, Object>();
                    deliDateMap.put("<=", entry.getValue());
                    filterMap.put("delidate", deliDateMap);
                    break;
                }
            }
        }
        return filterMap;
    }

    public static void openEidtPageByBillNo(IFormView view, String billKey, Object billNo) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billno", billNo);
        DynamicObject dynaObject = ORMUtil.queryOneByPro(billKey, "id,billno", param);
        if (dynaObject == null) {
            view.showMessage(ResManager.loadKDString((String)"\u5355\u636e", (String)"BillFormUtil_0", (String)"scm-common", (Object[])new Object[0]) + billNo + ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\uff01", (String)"BillFormUtil_1", (String)"scm-common", (Object[])new Object[0]));
        } else {
            BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam(billKey, ShowType.MainNewTabPage, OperationStatus.VIEW, (Long)dynaObject.getPkValue(), null, null);
            view.showForm((FormShowParameter)showParam);
        }
    }

    public static Long NumberToPkId(String entryKey, String number) {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("=", number);
        filterMap.put("number", map);
        return ORMUtil.queryPkValueByNumber(entryKey, filterMap);
    }

    public static boolean verifyUniqueColl(Object[] objects) {
        return objects != null && objects.length == 1;
    }

    public static DynamicObject getSelectData(IFormView view, String entityKey) {
        BillList list = (BillList)view.getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u64cd\u4f5c\u3002", (String)"BillFormUtil_2", (String)"scm-common", (Object[])new Object[0]));
            return null;
        }
        String selectFields = DynamicObjectUtil.getSelectfields(entityKey, false);
        String id = objects[0].toString();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("id", Long.parseLong(id));
        return ORMUtil.queryOneByPro(entityKey, selectFields, filterMap);
    }

    public static DynamicObject getSelectData(IFormView view, String entityKey, List<String> entryKeyList) {
        BillList list = (BillList)view.getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u5206\u5f55\u64cd\u4f5c\u3002", (String)"BillFormUtil_3", (String)"scm-common", (Object[])new Object[0]));
            return null;
        }
        String selectFields = DynamicObjectUtil.getSelectfields(entityKey, false);
        for (String entryKey : entryKeyList) {
            selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, entityKey, entryKey, false);
        }
        long id = Long.parseLong(objects[0].toString());
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("id", id);
        return ORMUtil.queryOneByPro(entityKey, selectFields, filterMap);
    }

    public static DynamicObject[] getMultiSelectData(IFormView view, String entityKey, List<String> entryKeyList) {
        BillList list = (BillList)view.getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        String selectFields = DynamicObjectUtil.getSelectfields(entityKey, false);
        for (String entryKey : entryKeyList) {
            selectFields = DynamicObjectUtil.getEntrySelectfields(selectFields, entityKey, entryKey, false);
        }
        return BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objects)});
    }

    public static void activeTab(IFormView view, String controlKey, String tabKey) {
        Tab statusTab = (Tab)view.getControl(controlKey);
        if (statusTab == null) {
            return;
        }
        statusTab.activeTab(tabKey);
    }

    public static void clearSrcPro(IDataModel model, String entryKey) {
        int count = model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            model.setValue("srcbillid", (Object)"", i);
            model.setValue("srcentryid", (Object)"", i);
        }
    }
}

