/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.cal.Cal4MultCurrencyObj;

public final class BillPushAssistUtil {
    private static Log log = LogFactory.getLog(BillPushAssistUtil.class);

    public static Map<String, Object> pushBill(String billNo, String srcEntityKey, String targetEntityKey, HashMap<Long, Map<String, Object>> srcPriceMap, Map<String, Long> supplierMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        HashMap<String, String> autoBillNoMap = new HashMap<String, String>();
        Long org = 0L;
        int count = 1;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)srcEntityKey, (String)"org,id,billno,isautofillprice,turns,materialentry.id entryid,materialentry.newestturns newestturns", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNo)}, (String)"materialentry.seq asc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (count == 1) {
                    org = row.getLong("org");
                    ++count;
                }
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                if (row.getBoolean("isautofillprice").booleanValue()) {
                    autoBillNoMap.put(row.getString("billno"), "1");
                } else if (StringUtils.equals((CharSequence)row.getString("turns"), (CharSequence)row.getString("newestturns")) || StringUtils.isBlank((CharSequence)row.getString("newestturns"))) {
                    autoBillNoMap.put(row.getString("billno"), "0");
                }
                listSelectedRow.setEntryEntityKey("materialentry");
                listSelectedRow.setEntryPrimaryKeyValue((Object)row.getLong("entryid"));
                listSelectedRow.setPrimaryKeyValue((Object)row.getLong("id"));
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.getCustomParams().put("autoBillNoMap", JacksonJsonUtil.toJSON(autoBillNoMap));
        if (!selectedRowList.isEmpty()) {
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = null;
            try {
                result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u518d\u6b21\u6267\u884c\u3002", (String)"BillPushAssistUtil_0", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            HashMap<Long, Map<String, Object>> targetPriceMap = new HashMap<Long, Map<String, Object>>();
            if (result != null) {
                if (result.isSuccess()) {
                    OperationResult operationResult;
                    boolean flag = srcEntityKey.equals("sou_inquiry") && targetEntityKey.equals("sou_quote");
                    Object[] targetData = BusinessDataServiceHelper.load((Object[])result.getTargetBillIds().toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(flag ? "quo_quote" : targetEntityKey)));
                    List<Long> supIdList = BizPartnerUtil.getSupplierByUserAndOrgOfBizPartner(org);
                    Map supMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", supIdList)});
                    for (DynamicObject dynamicObject : targetData) {
                        if (supplierMap.get("supplier") > 0L) {
                            dynamicObject.set("supplier", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)supplierMap.get("supplier"), (String)"bd_supplier"));
                            dynamicObject.set("bizpartner_id", (Object)BizPartnerUtil.getBizPartnerBySupplier(supplierMap.get("supplier")));
                        } else if (supIdList != null && supIdList.size() >= 1) {
                            dynamicObject.set("supplier", supMap.get(supIdList.get(0)));
                            dynamicObject.set("bizpartner_id", (Object)BizPartnerUtil.getBizPartnerBySupplier(supIdList.get(0)));
                        }
                        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
                    }
                    BillPushAssistUtil.processTurnsCountInfo(srcEntityKey, (DynamicObject[])targetData, billNo, supIdList);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("isStrict", "false");
                    option.setVariableValue("ishasright", String.valueOf(true));
                    List targetRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)srcEntityKey, (String)"materialentry", (Long[])srcPriceMap.keySet().toArray(new Long[0]));
                    for (BFRow bFRow : targetRowIds) {
                        Long sid = bFRow.getSId().getEntryId();
                        Long id = bFRow.getId().getEntryId();
                        if (!srcPriceMap.containsKey(sid)) continue;
                        targetPriceMap.put(id, srcPriceMap.get(sid));
                    }
                    Cal4MultCurrencyObj cal4MultCurrencyObj = new Cal4MultCurrencyObj();
                    for (DynamicObject dynamicObject : targetData) {
                        if (flag && StringUtils.isBlank((CharSequence)dynamicObject.getString("billno"))) {
                            String readNumber = CodeRuleServiceHelper.getNumber((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, (String)dynamicObject.getString("org.id"));
                            dynamicObject.set("billno", (Object)readNumber);
                        }
                        Long pkVal = dynamicObject.getLong("id");
                        DynamicObjectCollection materialColl = dynamicObject.getDynamicObjectCollection("materialentry");
                        Set<String> standardProps = BillPushAssistUtil.getStandardProps();
                        for (DynamicObject materialEntry : materialColl) {
                            Map dataMap;
                            if (null == materialEntry || null == (dataMap = (Map)targetPriceMap.get(materialEntry.getPkValue()))) continue;
                            materialEntry.set("price", dataMap.get("price"));
                            materialEntry.set("qty", dataMap.get("qty"));
                            materialEntry.set("taxrate", dataMap.get("taxrate"));
                            materialEntry.set("taxrateid", dataMap.get("taxrateid"));
                            materialEntry.set("taxprice", dataMap.get("taxprice"));
                            materialEntry.set("note", dataMap.get("note"));
                            materialEntry.set("minorderqty", dataMap.get("minorderqty"));
                            materialEntry.set("purleadday", dataMap.get("purleadday"));
                            BillPushAssistUtil.setMultEntryInfo(materialEntry, dataMap);
                            Set entries = dataMap.entrySet();
                            for (Map.Entry entry : entries) {
                                String prop = (String)entry.getKey();
                                if (standardProps.contains(prop) || !materialEntry.getDynamicObjectType().getProperties().containsKey((Object)prop)) continue;
                                materialEntry.set(prop, entry.getValue());
                            }
                        }
                        cal4MultCurrencyObj.reCalBill(dynamicObject, "materialentry");
                        Cal4MultCurrencyObj.calCost(dynamicObject, "materialentry");
                        resultMap.put(billNo, pkVal);
                    }
                    if (flag) {
                        for (DynamicObject dynamicObject : targetData) {
                            dynamicObject.set("bizstatus", null);
                        }
                    }
                    if (targetData.length > 0 && !(operationResult = SaveServiceHelper.saveOperate((String)"save", (String)targetData[0].getDataEntityType().getName(), (DynamicObject[])targetData, (OperateOption)option)).isSuccess()) {
                        List resultInfo = operationResult.getAllErrorOrValidateInfo();
                        StringBuilder sb = new StringBuilder();
                        resultInfo.forEach(error -> sb.append(error.getMessage()).append('\n'));
                        resultMap.put(billNo, sb.toString().replaceAll(targetData[0].getString("billno") + ":", ""));
                        DeleteServiceHelper.delete((IDataEntityType)targetData[0].getDataEntityType(), (Object[])targetData);
                    }
                } else {
                    resultMap.put(billNo, result.getMessage());
                }
            }
        }
        return resultMap;
    }

    private static void setMultEntryInfo(DynamicObject materialEntry, Map<String, Object> dataMap) {
        materialEntry.set("quotecurr", dataMap.get("quotecurr"));
        materialEntry.set("quotecurr_id", dataMap.get("quotecurr_id"));
        materialEntry.set("exrate", dataMap.get("exrate"));
    }

    public static void processTurnsCountInfo(String srcEntityKey, DynamicObject[] targetData, String billNo, List<Long> supIdList) {
        block4: {
            if (targetData == null) break block4;
            DynamicObject info = QueryServiceHelper.queryOne((String)srcEntityKey, (String)"id,entryentity.entrycount", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNo).and("entryentity.supplier", "in", supIdList).and("entryentity.canshow", "=", (Object)Boolean.TRUE)});
            if (info != null) {
                String turns = info.getString("entryentity.entrycount");
                for (DynamicObject a : targetData) {
                    turns = StringUtils.isBlank((CharSequence)turns) ? "1" : turns;
                    a.set("turnscount", (Object)turns);
                }
            } else {
                for (DynamicObject a : targetData) {
                    a.set("turnscount", (Object)"1");
                }
            }
        }
    }

    public static String getSelectFilds() {
        StringBuilder sb = new StringBuilder().append("id").append(',').append("billno").append(',').append("supplier").append(',').append("taxtype").append(',').append("bizpartner").append(',').append("paycond").append(',').append("settletype").append(',').append("curr").append(',').append("sumtaxamount").append(',').append("sumamount").append(',').append("sumtax").append(',').append("totalamount").append(',').append("sumcost").append(',').append("creator").append(',').append("materialentry").append(',').append("materialentry").append('.').append("qty").append(',').append("materialentry").append('.').append("price").append(',').append("materialentry").append('.').append("amount").append(',').append("materialentry").append('.').append("dctrate").append(',').append("materialentry").append('.').append("dctamount").append(',').append("materialentry").append('.').append("taxprice").append(',').append("materialentry").append('.').append("taxrate").append(',').append("materialentry").append('.').append("tax").append(',').append("materialentry").append('.').append("taxamount").append(',').append("materialentry").append('.').append("note").append("materialentry").append('.').append("minorderqty").append("materialentry").append('.').append("purleadday");
        return sb.toString();
    }

    public static ConvertOperationResult pushBillResult(DynamicObjectCollection billColl, String srcEntityKey, String targetEntityKey) {
        if (null != billColl) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(srcEntityKey);
            pushArgs.setTargetEntityNumber(targetEntityKey);
            pushArgs.setBuildConvReport(false);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject billData : billColl) {
                ListSelectedRow row = new ListSelectedRow();
                row.setEntryEntityKey("materialentry");
                row.setEntryPrimaryKeyValue((Object)billData.getLong("entryid"));
                row.setPrimaryKeyValue((Object)billData.getLong("id"));
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            return result;
        }
        return null;
    }

    public static ConvertOperationResult pushBillResult(List<DynamicObject> objs, String srcEntityKey, String srcEntryKey, String targetEntityKey) {
        ConvertOperationResult result = null;
        if (null != objs && !objs.isEmpty()) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(srcEntityKey);
            pushArgs.setTargetEntityNumber(targetEntityKey);
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject bill : objs) {
                DynamicObjectCollection cols = bill.getDynamicObjectCollection(srcEntryKey);
                for (DynamicObject col : cols) {
                    ListSelectedRow row = new ListSelectedRow();
                    row.setPrimaryKeyValue(bill.getPkValue());
                    row.setEntryEntityKey(srcEntryKey);
                    row.setEntryPrimaryKeyValue(col.getPkValue());
                    selectedRowList.add(row);
                }
            }
            pushArgs.setSelectedRows(selectedRowList);
            result = ConvertServiceHelper.push((PushArgs)pushArgs);
        }
        return result;
    }

    public static List<DynamicObject> pushToTargetAuditBill(List<DynamicObject> objs, String srcEntityKey, String srcEntryKey, String targetEntityKey) {
        log.info("###\u5f00\u59cb\u6267\u884c\u4e0b\u63a8 pushToTargetAuditBill");
        List<DynamicObject> targetObjs = new ArrayList<DynamicObject>();
        ConvertOperationResult result = BillPushAssistUtil.pushBillResult(objs, srcEntityKey, srcEntryKey, targetEntityKey);
        if (result != null && result.isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            List<DynamicObject> targetData = BillPushAssistUtil.loadTargetDataObjects(result, targetEntityKey);
            OperationResult opResult = SaveServiceHelper.saveOperate((String)targetEntityKey, (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
            if (opResult.isSuccess()) {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityKey, (Object[])opResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                if (submitResult.getSuccessPkIds().size() > 0) {
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityKey, (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                    if (auditResult.isSuccess()) {
                        targetObjs = DynamicObjectUtil.getDataByIdList(targetData, auditResult.getSuccessPkIds());
                        log.info("###@\u5355\u636e\u5ba1\u6838\u6210\u529f!");
                    } else {
                        log.info("###\u5355\u636e\u5ba1\u6838\u5f02\u5e38\uff1a" + auditResult.getMessage());
                    }
                } else {
                    log.info("###\u5355\u636e\u63d0\u4ea4\u5f02\u5e38\uff1a" + submitResult.getMessage());
                    ArrayList errorPkIds = new ArrayList();
                    errorPkIds.addAll(submitResult.getValidateResult().getErrorPkIds());
                    log.info("###\u5220\u9664\u63d0\u4ea4\u4e2d\u65ad\u7684\u6570\u636e\uff1a" + errorPkIds.size());
                    if (errorPkIds.size() > 0) {
                        OperationServiceHelper.executeOperate((String)"delete", (String)targetEntityKey, (Object[])errorPkIds.toArray(new Object[0]), (OperateOption)option.copy());
                    }
                }
            } else {
                log.info("###\u5355\u636e\u4fdd\u5b58\u5931\u8d25\uff1a" + opResult.getMessage());
            }
        } else if (result != null) {
            log.info("###\u5355\u636e\u5931\u8d25\uff1a" + result.getMessage());
        }
        return targetObjs;
    }

    public static List<DynamicObject> loadTargetDataObjects(ConvertOperationResult result, String targetEntityKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        List<Object> targetData = new ArrayList<DynamicObject>();
        if (result.isSuccess()) {
            targetData = result.loadTargetDataObjects(refDataProvider, mainType);
        }
        return targetData;
    }

    private static Set<String> getStandardProps() {
        HashSet<String> set = new HashSet<String>();
        set.add("price");
        set.add("taxprice");
        set.add("taxrate");
        set.add("taxrateid");
        set.add("note");
        set.add("qty");
        set.add("taxtype");
        set.add("minorderqty");
        set.add("purleadday");
        return set;
    }
}

