/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BizTypeHelper {
    private BizTypeHelper() {
    }

    public static List<QFilter> getQFilterByLineType(Long billTypeId, Long bizTypeId, Long lineTypeId, boolean isMaterialInfo) {
        QFilter[] qFilters = (QFilter[])DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"BillTypeMaterialService", (String)"getQFilterByLineType", (Object[])new Object[]{billTypeId, bizTypeId, lineTypeId, isMaterialInfo});
        return Arrays.asList(qFilters);
    }

    public static List<Long> getAllBizTypes(String formId, Long billTypeId) {
        if (Objects.isNull(formId) || Objects.isNull(billTypeId)) {
            return null;
        }
        return BizTypeHelper.getBizTypes(formId, billTypeId, false);
    }

    public static Long getDefaultBizType(String formId, Long billTypeId) {
        if (Objects.isNull(formId) || Objects.isNull(billTypeId)) {
            return null;
        }
        List<Long> bizTypeList = BizTypeHelper.getBizTypes(formId, billTypeId, true);
        return bizTypeList != null && bizTypeList.size() != 0 ? bizTypeList.get(0) : null;
    }

    public static List<Long> getBizTypes(String formId, Long billTypeId, boolean isDefault) {
        DynamicObjectCollection entry;
        ArrayList<Long> bizTypeList = new ArrayList<Long>(16);
        if (Objects.isNull(formId) || Objects.isNull(billTypeId)) {
            return bizTypeList;
        }
        DynamicObject billTypeParam = BizTypeHelper.getBillTypeParameter(formId, billTypeId);
        if (!Objects.isNull(billTypeParam) && (entry = billTypeParam.getDynamicObjectCollection("entryentity")) != null && entry.size() > 0) {
            for (DynamicObject bizType : entry) {
                if (isDefault) {
                    if (!bizType.getBoolean("isdefault")) continue;
                    bizTypeList.add((Long)bizType.getDynamicObject("biztypenumber").getPkValue());
                    continue;
                }
                bizTypeList.add((Long)bizType.getDynamicObject("biztypenumber").getPkValue());
            }
        }
        return bizTypeList;
    }

    private static DynamicObject getBillTypeParameter(String formId, Long billTypeId) {
        MainEntity entity;
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        MainEntity mainEntity = entity = meta == null ? null : meta.getRootEntity();
        if (entity instanceof BillEntity) {
            String paramFormId = ((BillEntity)entity).getBillTypePara();
            DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
            return billTypeParam;
        }
        return null;
    }

    public static Set<Long> getAllLineTypeIds(Long bizTypeId) {
        Map<Long, JSONObject> result;
        if (!Objects.isNull(bizTypeId) && (result = BizTypeHelper.getLineTypeByBillType(bizTypeId)) != null && null != result.get(bizTypeId)) {
            return (Set)result.get(bizTypeId).get((Object)"lineTypeIds");
        }
        return null;
    }

    public static List<QFilter> getAllLineTypes(Long bizTypeId) {
        Map<Long, JSONObject> result;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (bizTypeId != null && (result = BizTypeHelper.getLineTypeByBillType(bizTypeId)) != null) {
            Set lineTypeIds;
            JSONObject lineTypeParam = result.get(bizTypeId);
            if (lineTypeParam != null && (lineTypeIds = (Set)lineTypeParam.get((Object)"lineTypeIds")) != null) {
                qFilters.add(new QFilter("id", "in", (Object)lineTypeIds));
            }
            if (qFilters.size() == 0) {
                QFilter emptyQfilter = QFilter.isNull((String)"id");
                qFilters.add(emptyQfilter);
            }
            return qFilters;
        }
        return null;
    }

    public static Long getDefaultLineType(Long bizTypeId) {
        Long deafaultLineType;
        JSONObject lineTypeParam;
        Map<Long, JSONObject> result = BizTypeHelper.getLineTypeByBillType(bizTypeId);
        if (result != null && (lineTypeParam = result.get(bizTypeId)) != null && (deafaultLineType = (Long)lineTypeParam.get((Object)"deafaultLineType")) != null) {
            return deafaultLineType;
        }
        return null;
    }

    public static Map<Long, JSONObject> getLineTypeByBillType(Long bizTypeId) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"BillTypeMaterialService", (String)"getLineTypeByBillType", (Object[])new Object[]{Collections.singletonList(bizTypeId)});
        return result;
    }
}

