/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.url.UrlService;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.DateUtil;
import org.apache.commons.codec.digest.DigestUtils;

public class CommonUtil {
    private static Log log = LogFactory.getLog(CommonUtil.class);

    public static String list2str(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            if (sb.length() > 0) {
                sb.append(",'").append(str).append('\'');
                continue;
            }
            sb.append('\'').append(str).append('\'');
        }
        return sb.toString();
    }

    public static String collection2str(Collection<? extends Object> colelction) {
        StringBuilder sb = new StringBuilder();
        for (Object object : colelction) {
            if (sb.length() > 0) {
                sb.append(",'").append(object).append('\'');
                continue;
            }
            sb.append('\'').append(object).append('\'');
        }
        return sb.toString();
    }

    public static String objs2str(Object[] objs) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objs) {
            if (sb.length() > 0) {
                sb.append(',').append(obj);
                continue;
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static Object[] str2objs(String str, String regex) {
        if (null == str) {
            return null;
        }
        String[] splitStrs = str.split(regex);
        Object[] objs = null;
        if (splitStrs.length > 0) {
            objs = new Object[splitStrs.length];
        }
        if (objs != null) {
            System.arraycopy(splitStrs, 0, objs, 0, splitStrs.length);
        }
        return objs;
    }

    public static Long[] strids2Longs(String str, String regex) {
        if (null == str) {
            return null;
        }
        String[] splitStrs = str.split(regex);
        ArrayList<Long> objs = new ArrayList<Long>();
        for (String splitStr : splitStrs) {
            if (StringUtils.isEmpty((CharSequence)splitStr)) continue;
            objs.add(Long.parseLong(splitStr));
        }
        return objs.toArray(new Long[0]);
    }

    public static List str2List(String str, String regex) {
        ArrayList<String> objs = new ArrayList<String>();
        if (null == str) {
            return objs;
        }
        String[] splitStrs = str.split(regex);
        if (splitStrs == null || splitStrs.length == 0) {
            return objs;
        }
        for (String obj : splitStrs) {
            if (obj == null) continue;
            objs.add(obj);
        }
        return objs;
    }

    public static BigDecimal getBigDecimalPro(Object obj) {
        String val = null;
        val = null == obj || obj.toString().trim().length() == 0 ? "0" : obj.toString();
        return new BigDecimal(val);
    }

    public static int[] list2Array(List<Integer> list) {
        int[] intArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            intArray[i] = list.get(i);
        }
        return intArray;
    }

    public static String getBillnoByDate(Object obj) {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.date2str(calendar.getTime(), "yyyyMMdd_HHmmssSSS");
    }

    public static synchronized String getUniqueKey() {
        long seq = 0L;
        SecureRandom secRandom = new SecureRandom();
        long val = secRandom.nextLong() + ++seq;
        String uniqueKey = String.valueOf(val).replaceFirst("-", "A");
        return uniqueKey;
    }

    public static String[] str2Strings(String str, String regex) {
        if (null == str) {
            return null;
        }
        String[] splitStrs = str.split(regex);
        String[] objs = null;
        if (splitStrs.length > 0) {
            objs = new String[splitStrs.length];
        }
        if (objs != null) {
            System.arraycopy(splitStrs, 0, objs, 0, splitStrs.length);
        }
        return objs;
    }

    public static final Long getUserTypeByName(String userTypeName) {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("=", userTypeName);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        map.put("name", typeMap);
        DynamicObjectCollection typeList = ORMUtil.queryDynamicObjectCollection("bos_usertype", "id,name", map);
        return typeList.size() == 1 ? Long.valueOf(((DynamicObject)typeList.get(0)).getLong("id")) : null;
    }

    @Deprecated
    public static final ArrayList<QFilter> getQueryListFilter(Map<String, Map<String, Object>> mapMap) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(mapMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapMap.entrySet()) {
            Map<String, Object> cpVal = entry.getValue();
            for (Map.Entry<String, Object> objectEntry : cpVal.entrySet()) {
                qFilters.add(new QFilter(entry.getKey(), objectEntry.getKey(), objectEntry.getValue()));
            }
        }
        return qFilters;
    }

    public static ArrayList<String> getBizAppId() {
        DynamicObjectCollection bizAppsByCloudIDs = BizAppServiceHelp.getAllBizAppsByCloudID((String)"d746ccf2000145ac");
        ArrayList<String> bizAppIds = new ArrayList<String>();
        for (DynamicObject dynamicObject : bizAppsByCloudIDs) {
            bizAppIds.add(dynamicObject.getString("id"));
        }
        return bizAppIds;
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (srcQty == null) {
            return BigDecimal.ZERO;
        }
        if (material == null || srcUnit == null || desUnit == null || srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            return srcQty;
        }
        return CommonUtil.getDesConvQty((Long)material.getPkValue(), (Long)srcUnit.getPkValue(), srcQty, desUnit);
    }

    public static BigDecimal getDesQtyConv(Long materialId, Long srcUnitId, BigDecimal srcQty, DynamicObject desUnit) {
        if (srcQty == null) {
            return BigDecimal.ZERO;
        }
        if (materialId == null || srcUnitId == null || desUnit == null || srcQty == null || srcUnitId.equals(desUnit.getPkValue())) {
            return srcQty;
        }
        return CommonUtil.getDesConvQty(materialId, srcUnitId, srcQty, desUnit);
    }

    private static BigDecimal getDesConvQty(Long materialId, Long srcUnitId, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal unitRate;
        BigDecimal qty = BigDecimal.ZERO;
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)((Long)desUnit.getPkValue()));
        if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
            int unitPrecision = desUnit.getInt("precision");
            if (StringUtil.isNotBlank((CharSequence)desUnit.getString("precisionaccount"))) {
                int account = desUnit.getInt("precisionaccount");
                int unitPrecisionType = 4;
                if (account == 2) {
                    unitPrecisionType = 1;
                } else if (account == 3) {
                    unitPrecisionType = 0;
                }
                qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
            }
        }
        return qty;
    }

    public static String getDomainUrlWidthouSlash() {
        String domainUrl = UrlService.getDomainContextUrl();
        if (StringUtils.isNotBlank((CharSequence)domainUrl) && domainUrl.trim().endsWith("/")) {
            return domainUrl.substring(0, domainUrl.lastIndexOf(47));
        }
        return domainUrl;
    }

    public static List<Object> stringList2objList(Collection<String> strings) {
        ArrayList<Object> list = new ArrayList<Object>(strings.size());
        for (String string : strings) {
            Object obj;
            try {
                obj = Long.valueOf(string);
            }
            catch (NumberFormatException e) {
                obj = string;
            }
            list.add(obj);
        }
        return list;
    }

    public static List<Object> stringObjList2longObjList(Collection<Object> strings) {
        ArrayList<Object> list = new ArrayList<Object>(strings.size());
        for (Object string : strings) {
            Object obj;
            try {
                obj = Long.valueOf(String.valueOf(string));
            }
            catch (NumberFormatException e) {
                obj = string;
            }
            list.add(obj);
        }
        return list;
    }

    public static String integerList2str(List<Integer> integerList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < integerList.size(); ++i) {
            Integer integer = integerList.get(i);
            if (i == integerList.size() - 1) {
                sb.append(integer);
                continue;
            }
            sb.append(integer).append('\u3001');
        }
        return sb.toString();
    }

    public static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            log.error("parse String to long Exception:", (Object)e.getMessage());
            return 0L;
        }
    }

    public static String md5Hex(String data) {
        return DigestUtils.md5Hex((String)data);
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        return ByteStreams.toByteArray((InputStream)in);
    }

    public static void check(OperationResult rs) {
        if (!rs.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo op : rs.getAllErrorOrValidateInfo()) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(op.getMessage());
            }
            if (sb.length() == 0) {
                throw new KDBizException(rs.getMessage());
            }
            throw new KDBizException(sb.toString());
        }
    }

    public static DynamicObject createDefaultDyn(String entityKey) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        return ParameterUtils.createDefaultEntity((MainEntityType)entityType, (DynamicObject)((DynamicObject)entityType.createInstance()));
    }

    public static List<Long> getLongList(Object poEntryIdList) {
        ArrayList srcList = null;
        srcList = poEntryIdList instanceof List ? (ArrayList)poEntryIdList : (poEntryIdList instanceof Set ? new ArrayList((Set)poEntryIdList) : new ArrayList(1024));
        ArrayList<Long> list = new ArrayList<Long>(srcList.size());
        for (Object poentryid : srcList) {
            list.add(Long.parseLong(String.valueOf(poentryid)));
        }
        return list;
    }

    public static boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        }
        if (oldObject instanceof Timestamp || oldObject instanceof Date) {
            Long oldvalue = 0L;
            Long newvalue = 0L;
            if (oldObject instanceof Timestamp) {
                oldvalue = ((Timestamp)oldObject).getTime();
            }
            if (oldObject instanceof Date) {
                oldvalue = ((Date)oldObject).getTime();
            }
            if (newObject instanceof Timestamp) {
                newvalue = ((Timestamp)newObject).getTime();
            }
            if (newObject instanceof Date) {
                newvalue = ((Date)newObject).getTime();
            }
            if (!newvalue.equals(oldvalue)) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else if (newObject instanceof OrmLocaleValue && oldObject instanceof OrmLocaleValue) {
                if (((OrmLocaleValue)newObject).getLocaleValue() == null) {
                    return true;
                }
                if (((OrmLocaleValue)oldObject).getLocaleValue() == null) {
                    return true;
                }
                if (!((OrmLocaleValue)oldObject).getLocaleValue().equals(((OrmLocaleValue)newObject).getLocaleValue())) {
                    return true;
                }
            } else {
                return !oldObject.equals(newObject);
            }
        }
        return false;
    }
}

