/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.lang.StringUtils;

public class DateUtil {
    public static final String FORMAT_PARTEN = "yyyy-MM-dd";
    public static final String FORMAT_PARTEN2 = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_PARTEN3 = "yyyyMM";
    public static final ZoneId UTC_PLUS_8 = ZoneId.systemDefault();

    @Deprecated
    public static Date getEndDate(Date date) {
        return DateUtil.formatEndDate(date);
    }

    public static String getFormatEndDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        LocalDateTime localDateTime = localDate.atTime(23, 59, 59);
        return DateUtil.localDateTime2str(localDateTime, FORMAT_PARTEN2);
    }

    @Deprecated
    public static String getFormatEndMaxDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        localDate = localDate.withDayOfMonth(localDate.lengthOfMonth());
        LocalDateTime localDateTime = localDate.atTime(23, 59, 59);
        return DateUtil.localDateTime2str(localDateTime, FORMAT_PARTEN2);
    }

    public static Date getFormatDateEndMaxDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        localDate = localDate.withDayOfMonth(localDate.lengthOfMonth());
        LocalDateTime localDateTime = localDate.atTime(23, 59, 59);
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static String getFormatStartDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return DateUtil.localDateTime2str(localDateTime, FORMAT_PARTEN2);
    }

    public static Date formatEndDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        LocalDateTime localDateTime = localDate.atTime(23, 59, 59);
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static Date formatEndDateForCurDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        LocalDateTime localDateTime = localDate.atTime(LocalTime.now(UTC_PLUS_8));
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static Date formatStartDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static Date getPreviousMonthDate(Date date, int count) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        localDate = localDate.minusMonths(count);
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static final Date getPreviousSomeMonthStingDate(Date date, int count) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        localDate = localDate.minusMonths(count).withDayOfMonth(1);
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static Date getPreviousMonthDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        localDate = localDate.minusMonths(1L);
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static Date getPreviousNatureMonthDate(int count) {
        Date temp = TimeServiceHelper.now();
        LocalDate localDate = temp.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        int lengthOfMonth = localDate.lengthOfMonth();
        int dayOfMonth = count >= lengthOfMonth ? lengthOfMonth : count;
        localDate = localDate.withDayOfMonth(dayOfMonth);
        LocalDateTime localDateTime = localDate.atTime(23, 59, 59);
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static String date2str(Date date, String pattern) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat format = null;
        format = StringUtils.isNotEmpty((String)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat(FORMAT_PARTEN2);
        return format.format(date);
    }

    public static Date getDefaultPreviousMonthDate(Date date) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        localDate = localDate.minusMonths(1L);
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static Date string2date(String str, String pattern) {
        SimpleDateFormat format = null;
        format = StringUtils.isNotEmpty((String)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat(FORMAT_PARTEN2);
        Date date = null;
        if (!StringUtils.isEmpty((String)str)) {
            try {
                date = format.parse(str);
            }
            catch (ParseException e) {
                throw new KDException(new ErrorCode("time convert error", ResManager.loadKDString((String)"\u65e5\u671f%s\u8f6c\u6362\u5f02\u5e38\u3002", (String)"DateUtil_0", (String)"scm-common", (Object[])new Object[0])), new Object[]{str});
            }
        }
        return date;
    }

    public static final Date getPreviousSomeMonth(Date date, int count) {
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        LocalDateTime localDateTime = localDate.minusMonths(count).withDayOfMonth(1).atStartOfDay();
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static ArrayList<String> assembleContinuousMonth(Date date) {
        int num = 5;
        String[] dateSet = new String[num + 1];
        LocalDate localDate = date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
        for (int i = 0; i < dateSet.length; ++i) {
            LocalDateTime localDateTime = localDate.minusMonths((long)num - (long)i).withDayOfMonth(1).atStartOfDay();
            dateSet[i] = localDateTime.format(DateTimeFormatter.ofPattern(FORMAT_PARTEN3));
        }
        return new ArrayList<String>(Arrays.asList(dateSet));
    }

    public static final Date addMonth(Date date, int month) {
        LocalDateTime localDateTime = DateUtil.date2localDateTime(date);
        return DateUtil.localDateTime2date(localDateTime.plusMonths(month));
    }

    public static final Date addWeek(Date date, int week) {
        LocalDateTime localDateTime = DateUtil.date2localDateTime(date);
        return DateUtil.localDateTime2date(localDateTime.plusWeeks(week));
    }

    public static final Date getNextDay(Date date) {
        LocalDateTime localDateTime = DateUtil.date2localDateTime(date);
        return DateUtil.localDateTime2date(localDateTime.plusDays(1L));
    }

    public static final Date addDays(Date date, int days) {
        LocalDateTime localDateTime = DateUtil.date2localDateTime(date);
        return DateUtil.localDateTime2date(localDateTime.plusDays(days));
    }

    public static final Date getDateByOffsetDay(Date now, int offsetDay) {
        LocalDateTime localDateTime = DateUtil.date2localDateTime(now);
        return DateUtil.localDateTime2date(localDateTime.plusDays(offsetDay));
    }

    public static int daysBetween(Date firstDate, Date secDate) {
        LocalDate localDate1 = DateUtil.date2localDate(firstDate);
        LocalDate localDate2 = DateUtil.date2localDate(secDate);
        return localDate2.isAfter(localDate1) ? (int)localDate1.until(localDate2, ChronoUnit.DAYS) : (int)localDate2.until(localDate1, ChronoUnit.DAYS);
    }

    public static Date getDayStart(Date date) {
        return DateUtil.formatStartDate(date);
    }

    public static String date2strByLocalDateTime(Date date, String pattern) {
        LocalDateTime localDateTime = DateUtil.date2localDateTime(date);
        return DateUtil.localDateTime2str(localDateTime, pattern);
    }

    public static Date str2dateByLocalDateTime(String dateStr, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
        return DateUtil.localDateTime2date(localDateTime);
    }

    public static String getMondayOfThisWeek() {
        return DateUtil.localDateTime2str(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(), FORMAT_PARTEN2);
    }

    public static String getSundayOfThisWeek() {
        LocalDateTime localDateTime = LocalDate.now().with(DayOfWeek.SUNDAY).atTime(23, 59, 59);
        return DateUtil.localDateTime2str(localDateTime, FORMAT_PARTEN2);
    }

    private static String localDateTime2str(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    private static Date localDateTime2date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(UTC_PLUS_8).toInstant());
    }

    private static LocalDateTime date2localDateTime(Date date) {
        return date.toInstant().atZone(UTC_PLUS_8).toLocalDateTime();
    }

    private static LocalDate date2localDate(Date date) {
        return date.toInstant().atZone(UTC_PLUS_8).toLocalDate();
    }

    public static Date getLastMonthEndDayByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date addYear(Date date, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, year);
        return calendar.getTime();
    }
}

