/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class ExchangeHelper {
    private static String EXRATE_DT = "bd_exrate_tree";
    private static String EXRATE_ORGCUR = "orgcur";
    private static String EXRATE_CUR = "cur";
    private static String EXRATE_EXCTABLE = "exctable";
    private static String EXRATE_EXCVAL = "excval";
    private static String EXRATE_INDIRECTEXRATE = "indirectexrate";

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }

    public static Long getExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        Long exRateTableId = null;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            exRateTableId = (Long)map.get("exchangeRateTableID");
        }
        return exRateTableId;
    }

    public static BigDecimal getExChangeRateByOrg(Long targetCurId, Long curId, Long orgId) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (curId.equals(targetCurId)) {
            exChangeRate = BigDecimal.ONE;
        } else {
            Long exRateTableId = ExchangeHelper.getExRateTable(orgId);
            exChangeRate = ExchangeHelper.getExChangeRate(curId, targetCurId, exRateTableId);
        }
        return exChangeRate;
    }

    public static BigDecimal getExChangeRateByOrg(Long targetCurId, Long curId, Long orgId, boolean isIndirectexrate) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (curId.equals(targetCurId)) {
            exChangeRate = BigDecimal.ONE;
        } else {
            Long exRateTableId = ExchangeHelper.getExRateTable(orgId);
            exChangeRate = ExchangeHelper.getExChangeRate(curId, targetCurId, exRateTableId, isIndirectexrate);
        }
        return exChangeRate;
    }

    public static BigDecimal getExChangeRate(Long targetCurId, Long curId, Long exRateTableId) {
        return ExchangeHelper.getExChangeRate(targetCurId, curId, exRateTableId, true);
    }

    public static BigDecimal getExChangeRate(Long targetCurId, Long curId, Long exRateTableId, boolean isIndirectexrate) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (curId.equals(targetCurId)) {
            exChangeRate = BigDecimal.ONE;
        } else {
            QFilter q2 = new QFilter(EXRATE_CUR, "=", (Object)curId);
            QFilter q1 = new QFilter(EXRATE_ORGCUR, "=", (Object)targetCurId);
            QFilter q3 = new QFilter(EXRATE_EXCTABLE, "=", (Object)exRateTableId);
            QFilter[] filters = new QFilter[]{q1, q2, q3};
            DynamicObject exchangeRateObj = BusinessDataServiceHelper.loadSingle((String)EXRATE_DT, (String)EXRATE_EXCVAL, (QFilter[])filters);
            if (exchangeRateObj != null) {
                exChangeRate = exchangeRateObj.getBigDecimal(EXRATE_EXCVAL);
            } else if (isIndirectexrate) {
                QFilter qtc = new QFilter(EXRATE_CUR, "=", (Object)targetCurId);
                QFilter qc = new QFilter(EXRATE_ORGCUR, "=", (Object)curId);
                QFilter qt = new QFilter(EXRATE_EXCTABLE, "=", (Object)exRateTableId);
                exchangeRateObj = BusinessDataServiceHelper.loadSingle((String)EXRATE_DT, (String)EXRATE_INDIRECTEXRATE, (QFilter[])new QFilter[]{qtc, qc, qt});
                if (exchangeRateObj != null) {
                    exChangeRate = exchangeRateObj.getBigDecimal(EXRATE_INDIRECTEXRATE);
                }
            }
        }
        return exChangeRate;
    }
}

