/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public interface IParseEvtSource {
    public static final String BIZ_PARTNER = ".bizpartner";
    public static final String BUSINESSKEY = "businesskey";

    @Deprecated
    public Set<Long> parseSourceToOthers(String var1, String var2);

    default public Map<String, Set<Long>> batchParseSourceToOthers(String billKey, String source, String fieldName, String bosOrg) {
        return null;
    }

    default public String setBasedataName() {
        return null;
    }

    default public String setOrgDataName() {
        return null;
    }

    default public String getFieldName(String billKey, String source) {
        String basedataName = this.setBasedataName();
        if (StringUtils.isEmpty((String)basedataName)) {
            return null;
        }
        String bdSupplier = this.parseFieldNameByBillKey(source, billKey, basedataName);
        return bdSupplier;
    }

    default public String getOrgFieldName(String billKey, String source) {
        String orgDataName = this.setOrgDataName();
        if (StringUtils.isEmpty((String)orgDataName)) {
            return null;
        }
        String bosOrg = this.parseFieldNameByBillKey(source, billKey, orgDataName);
        return bosOrg;
    }

    default public Map<String, List<Long>> parseSourceToBussinessKeyOthers(String billKey, String source) {
        String bosOrg;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(8);
        String fieldName = this.getFieldName(billKey, source);
        Map<String, Set<Long>> userIdMap = this.batchParseSourceToOthers(billKey, source, fieldName, bosOrg = this.getOrgFieldName(billKey, source));
        if (userIdMap == null) {
            throw new KDBizException("not rewrite parseSourceToOthers(billKey, single,fieldName,bosOrg) method");
        }
        for (Map.Entry<String, Set<Long>> userIdEntry : userIdMap.entrySet()) {
            String bussinessKey = userIdEntry.getKey();
            Set<Long> value = userIdEntry.getValue();
            ArrayList<Long> userIdList = new ArrayList<Long>(value);
            map.put(bussinessKey, userIdList);
        }
        return map;
    }

    default public String matchField(JSONObject jsonObject, String match) {
        Set paramsKeys = jsonObject.keySet();
        Pattern p = Pattern.compile("[a-z]*" + match + "[a-z]*");
        for (String paramsKey : paramsKeys) {
            if (!p.matcher(paramsKey).matches()) continue;
            return paramsKey;
        }
        return null;
    }

    default public Set<JSONObject> parseFirstLvlSource(String source) {
        HashSet<JSONObject> mapList = new HashSet<JSONObject>(1024);
        JSONArray array = JSONArray.parseArray((String)source);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            mapList.add(jsonObject);
        }
        return mapList;
    }

    default public Set<JSONObject> parseSecondLvlSource(String source, String entryKey) {
        HashSet<JSONObject> entryList = new HashSet<JSONObject>(8);
        JSONArray array = JSONArray.parseArray((String)source);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            entryKey = this.matchField(jsonObject, entryKey);
            if (entryKey == null) continue;
            JSONArray entryentity = jsonObject.getJSONArray(entryKey);
            for (int j = 0; j < entryentity.size(); ++j) {
                JSONObject entryObj = entryentity.getJSONObject(j);
                entryList.add(entryObj);
            }
        }
        return entryList;
    }

    default public String parseFieldNameByBillKey(String source, String billKey, String basedataName) {
        Set<JSONObject> jsonObjects = this.parseFirstLvlSource(source);
        HashSet firstLvlKeys = new HashSet(8);
        for (JSONObject jsonObject : jsonObjects) {
            firstLvlKeys.addAll(jsonObject.keySet());
        }
        String basedataPropName = null;
        DynamicObject dyn = ORM.create().newDynamicObject(billKey);
        DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : properties) {
            if (iDataEntityProperty instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)iDataEntityProperty;
                DynamicObjectType dynamicCollectionItemPropertyType = entryProp.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dynamicCollectionItemPropertyType.getProperties();
                String entryPropName = entryProp.getName();
                if (firstLvlKeys.contains(entryPropName)) {
                    Set<JSONObject> entryJsonObjects = this.parseSecondLvlSource(source, entryPropName);
                    HashSet secondLvlKeys = new HashSet();
                    for (JSONObject entryJsonObject : entryJsonObjects) {
                        secondLvlKeys.addAll(entryJsonObject.keySet());
                    }
                    for (IDataEntityProperty entryProperty : entryProperties) {
                        String baseEntityId;
                        String entryPropertyName = entryProperty.getName();
                        if (!(entryProperty instanceof BasedataProp) || !secondLvlKeys.contains(entryPropertyName) || !basedataName.equals(baseEntityId = ((BasedataProp)entryProperty).getBaseEntityId())) continue;
                        basedataPropName = entryPropName + "." + entryPropertyName;
                    }
                }
            }
            if (!(iDataEntityProperty instanceof BasedataProp)) continue;
            BasedataProp basedataProp = (BasedataProp)iDataEntityProperty;
            String baseEntityId = basedataProp.getBaseEntityId();
            String propName = basedataProp.getName();
            if (!basedataName.equals(baseEntityId) || !firstLvlKeys.contains(propName)) continue;
            basedataPropName = propName;
        }
        return basedataPropName;
    }

    default public Object getmatchFieldValue(String source, String match) {
        Set<JSONObject> jsonObjects = this.parseFirstLvlSource(source);
        Pattern p = Pattern.compile("[a-z]*" + match + "[a-z]*");
        for (JSONObject jsonObject : jsonObjects) {
            for (Map.Entry paramsKey : jsonObject.entrySet()) {
                if (!p.matcher((CharSequence)paramsKey.getKey()).matches()) continue;
                return paramsKey.getValue();
            }
        }
        return null;
    }

    default public Map<String, Set<Long>> parseUserIds(String source, String[] userIdKeys) {
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>(8);
        if (userIdKeys.length >= 2) {
            JSONArray array = JSONArray.parseArray((String)source);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String bussinessKey = jsonObject.getString(BUSINESSKEY);
                JSONObject supplier = jsonObject.getJSONObject(userIdKeys[0]);
                JSONObject bizpartner = supplier.getJSONObject(userIdKeys[1]);
                Long bizpartnerId = bizpartner.getLong("id");
                HashSet<Long> set = new HashSet<Long>();
                set.add(bizpartnerId);
                ids.put(bussinessKey, set);
            }
        }
        return ids;
    }

    default public Map<String, Set<Long>> parseUserIdsByEntitySupplier(String source, String[] userIdKeys) {
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>(8);
        if (userIdKeys.length >= 3) {
            JSONArray array = JSONArray.parseArray((String)source);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String bussinessKey = jsonObject.getString(BUSINESSKEY);
                JSONArray entryentity = jsonObject.getJSONArray(userIdKeys[0]);
                HashSet<Long> set = new HashSet<Long>(8);
                for (int j = 0; j < entryentity.size(); ++j) {
                    JSONObject entryObj = entryentity.getJSONObject(j);
                    JSONObject supplier = entryObj.getJSONObject(userIdKeys[1]);
                    JSONObject bizpartner = supplier.getJSONObject(userIdKeys[2]);
                    Long bizpartnerId = bizpartner.getLong("id");
                    set.add(bizpartnerId);
                }
                ids.put(bussinessKey, set);
            }
        }
        return ids;
    }

    default public Map<String, Set<Long>> parseUserIdsByEntityPerson(String source, String[] userIds) {
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>(8);
        if (userIds.length >= 2) {
            JSONArray array = JSONArray.parseArray((String)source);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String bussinessKey = jsonObject.getString(BUSINESSKEY);
                JSONArray entryentity = jsonObject.getJSONArray(userIds[0]);
                HashSet<Long> set = new HashSet<Long>();
                for (int j = 0; j < entryentity.size(); ++j) {
                    JSONObject entryObj = entryentity.getJSONObject(j);
                    if (entryObj == null) {
                        ids.put(bussinessKey, set);
                        continue;
                    }
                    JSONObject scorer = entryObj.getJSONObject(userIds[1]);
                    Long userId = scorer.getLong("id");
                    set.add(userId);
                }
                ids.put(bussinessKey, set);
            }
        }
        return ids;
    }

    default public Map<String, Set<Long>> parseUserIdsByPerson(String source, String[] userIds) {
        HashMap<String, Set<Long>> ids = new HashMap<String, Set<Long>>(8);
        if (userIds.length >= 2) {
            JSONArray array = JSONArray.parseArray((String)source);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String bussinessKey = jsonObject.getString(BUSINESSKEY);
                JSONObject purPerson = jsonObject.getJSONObject(userIds[0]);
                HashSet<Long> set = new HashSet<Long>(8);
                if (purPerson == null) {
                    ids.put(bussinessKey, set);
                    continue;
                }
                JSONObject user = purPerson.getJSONObject("user");
                Long userId = user.getLong("id");
                set.add(userId);
                ids.put(bussinessKey, set);
            }
        }
        return ids;
    }

    default public Long getOrgId(String source, String bosOrg, String pkId) {
        Long orgId = null;
        JSONArray orgArray = JSONArray.parseArray((String)source);
        for (int i = 0; i < orgArray.size(); ++i) {
            JSONObject jsonObject = orgArray.getJSONObject(i);
            String bussinesskey = jsonObject.getString(BUSINESSKEY);
            if (!pkId.equals(bussinesskey)) continue;
            JSONObject orgDyn = jsonObject.getJSONObject(bosOrg);
            orgId = orgDyn.getLong("id");
            return orgId;
        }
        return null;
    }

    default public Set<Long> getResultByMap(String billKey, String source, String fieldName, String bosOrg) {
        Map<String, Set<Long>> ids = this.batchParseSourceToOthers(billKey, source, fieldName, bosOrg);
        if (CollectionUtils.isEmpty(ids)) {
            return new HashSet<Long>(8);
        }
        Map.Entry findFirst = (Map.Entry)ids.entrySet().stream().findFirst().get();
        return (Set)findFirst.getValue();
    }
}

