/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.ecapi.jd.entity.JdOrderInfo;
import kd.scm.common.enums.MalStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.ParamUtil;

public class MalOrderUtil {
    private static final Log log = LogFactory.getLog(MalOrderUtil.class);
    private static final String TO_RECEIVE = "toReceive";

    @Deprecated
    public static void saveProduct(String number, String name, List img) {
        DynamicObject prod = ORMUtil.newDynamicObject("pmm_prodmanage");
        prod.set("number", (Object)number);
        prod.set("name", (Object)name);
        for (int i = 0; null != img && i < img.size(); ++i) {
            if (i == 0) {
                prod.set("thumbnail", img.get(i));
                continue;
            }
            String asc = "picture" + --i;
            prod.set(asc, img.get(++i));
        }
        prod.set("origin", (Object)1);
        prod.set("status", (Object)"C");
        prod.set("enable", (Object)"1");
        prod.set("source", (Object)"2");
        prod.set("mallStatus", (Object)MalStatusEnum.C.getVal());
        Object[] prods = new DynamicObject[]{prod};
        SaveServiceHelper.save((IDataEntityType)prod.getDataEntityType(), (Object[])prods);
    }

    public static String getBizFlowParam() {
        return MalOrderParamUtil.getBizFlowParam();
    }

    public static String getGenerateErpBill() {
        return MalOrderParamUtil.getGenerateErpBill();
    }

    public static String confirmOrder() {
        String confirmOrder = ParamUtil.getSysCtrlParam("UUPIH+47DAK", "confirmorder");
        log.info("@@@confirmOrder,\u53c2\u6570\u662f\u5426\u786e\u8ba4\u8ba2\u5355" + String.valueOf(confirmOrder));
        return StringUtils.isBlank((CharSequence)confirmOrder) ? "2" : confirmOrder;
    }

    public static boolean getDefaultMalVersion() {
        return MalOrderParamUtil.getDefaultMalVersion();
    }

    public static boolean isJD(String platform) {
        return MalOrderParamUtil.isJD(platform);
    }

    public static boolean isSN(String platform) {
        return MalOrderParamUtil.isSN(platform);
    }

    public static boolean isXY(String platform) {
        return MalOrderParamUtil.isXY(platform);
    }

    public static boolean isCG(String platform) {
        return MalOrderParamUtil.isCG(platform);
    }

    public static boolean isDL(String platform) {
        return MalOrderParamUtil.isDL(platform);
    }

    public static String getOrderFilterKeyByEcOrderId(String platform) {
        boolean isNewMalVerSion = MalOrderUtil.getDefaultMalVersion();
        if (MalOrderUtil.isJD(platform)) {
            if (isNewMalVerSion) {
                return "entryentity.order.number";
            }
            return "entryentity.jdorder.number";
        }
        if (MalOrderUtil.isSN(platform)) {
            return "entryentity.order.orderid";
        }
        return "entryentity.jdorder.number";
    }

    public static String getDefaultCurrency() {
        return MalOrderParamUtil.getDefaultCurrency();
    }

    public static String getDefaultPrice() {
        String defaultPrice = ParamUtil.getSysCtrlParam("UUPIH+47DAK", "defaultprice");
        log.info("@@@getDefaultPrice,\u53c2\u6570\u7535\u5546\u663e\u793a\u4ef7\u683c" + String.valueOf(defaultPrice));
        return StringUtils.isBlank((CharSequence)defaultPrice) ? "1" : defaultPrice;
    }

    public static String getJDUnit() {
        Map jdunit = (Map)ParamUtil.getParamObj("UUPIH+47DAK", "jdunit");
        log.info("@@@getJDUnit,\u4eac\u4e1c\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d" + String.valueOf(jdunit));
        return StringUtils.isBlank((Object)jdunit) ? "" : String.valueOf(jdunit.get("id"));
    }

    public static Long getEcUnitId(String source) {
        DynamicObject dyo = MalOrderUtil.getAuthDyo(source);
        return dyo != null ? dyo.getLong("mesureunits.id") : 11L;
    }

    public static Long getEcCurrencyId(String source) {
        DynamicObject dyo = MalOrderUtil.getAuthDyo(source);
        return dyo != null ? dyo.getLong("currency.id") : (StringUtils.isBlank((CharSequence)MalOrderUtil.getDefaultCurrency()) ? 1L : Long.parseLong(MalOrderUtil.getDefaultCurrency()));
    }

    public static Long getEcSupplierId(String source) {
        DynamicObject dyo = MalOrderUtil.getAuthDyo(source);
        return dyo != null ? Long.valueOf(dyo.getLong("malsupplier.id")) : MalOrderUtil.getDefualtSupplier(source);
    }

    public static DynamicObject getEcSupplier(String source) {
        return MalOrderUtil.getAuthDyo(source);
    }

    public static DynamicObject getAuthDyo(String source) {
        QFilter filter = new QFilter("platform", "=", (Object)source);
        filter.and(new QFilter("openstatus", "=", (Object)"2")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_ecadmit", (QFilter[])new QFilter[]{filter});
        return dyo;
    }

    private static Long getDefualtSupplier(String source) {
        switch (source) {
            case "2": {
                return Long.parseLong("486095512240421888");
            }
            case "3": {
                return Long.parseLong("968563370657601536");
            }
            case "4": {
                return Long.parseLong("968565068528637952");
            }
        }
        return 0L;
    }

    public static Long getDefualtStandard(String source) {
        DynamicObject dyo = MalOrderUtil.getAuthDyo(source);
        return dyo != null ? dyo.getLong("standard.id") : 0L;
    }

    public static void autoRrecive() {
        QFilter logFilter = new QFilter("logstatus", "in", (Object)new String[]{"A", "B", "C", "D", "F"});
        QFilter srcFilter = new QFilter("srctype", "=", (Object)ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        QFilter statesFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter cfmFilter = new QFilter("cfmstatus", "=", (Object)"B");
        QFilter dateFilter = new QFilter("auditdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate(new Date(), 3));
        String selectProperties = "id,billno,creator,org,materialentry.qty,materialentry.jdorder,materialentry.poentryid,materialentry.entryrcvorg,materialentry.pobillid,materialentry.unit,materialentry.basicunit,materialentry.purtype";
        DynamicObject[] purOrders = BusinessDataServiceHelper.load((String)"pur_order", (String)selectProperties, (QFilter[])new QFilter[]{logFilter, srcFilter, statesFilter, cfmFilter, dateFilter}, (String)"billdate desc");
        log.info("$$$$$$$purOrders:" + purOrders.length + ",dateFilter:" + dateFilter);
        if (purOrders.length > 0) {
            String token = JDAccessTokenUtil.getAccessTokenByKD(RequestContext.get().getTenantId());
            if (ApiConfigUtil.hasEASConfig()) {
                MalOrderUtil.generateEAS(purOrders, token);
            } else if (ApiConfigUtil.hasCQScmConfig()) {
                MalOrderUtil.generateCQScm(purOrders, token);
            }
        }
    }

    public static void generateCQScm(DynamicObject[] purOrders, String token) {
        log.info("$$$$$$$\u751f\u6210\u4f9b\u5e94\u94fe\u6536\u8d27/\u5165\u5e93\u5355\u5f00\u59cb");
        HashMap dataMap = new HashMap(purOrders.length);
        HashMap<String, String> entry_jdIdMap = new HashMap<String, String>();
        HashMap<String, String> pushParamMap = new HashMap<String, String>(purOrders.length);
        HashSet<String> jdOrderSet = new HashSet<String>();
        for (DynamicObject order : purOrders) {
            DynamicObjectCollection orderEntries = order.getDynamicObjectCollection("materialentry");
            ArrayList<String> entryOrderIds = new ArrayList<String>(orderEntries.size());
            String pk = order.getString("id");
            for (DynamicObject entry : orderEntries) {
                String jdOrderId = entry.getString("jdorder.number");
                String poentryId = entry.getString("poentryid");
                if (StringUtils.isBlank((CharSequence)jdOrderId) || StringUtils.isBlank((CharSequence)poentryId)) continue;
                jdOrderSet.add(jdOrderId);
                entryOrderIds.add(poentryId);
                entry_jdIdMap.put(poentryId, jdOrderId);
            }
            dataMap.put(pk, entryOrderIds);
            pushParamMap.put(pk, ((DynamicObject)orderEntries.get(0)).getString("purtype.checktype"));
        }
        log.info("$$$$$$$\u4eac\u4e1c\u8ba2\u5355\u53f7\uff1ajdOrderSet" + jdOrderSet);
        if (jdOrderSet.size() <= 0) {
            return;
        }
        List<String> needUpdateList = MalOrderUtil.getNeedUpdateIdSet(token, jdOrderSet);
        log.info("$$$$$$$\u5f85\u66f4\u65b0\u7684jdOrderId\u7ec4" + needUpdateList);
        if (needUpdateList.size() <= 0) {
            return;
        }
        String selectFields = "id,billentry.id";
        for (Map.Entry entry : dataMap.entrySet()) {
            String pk = (String)entry.getKey();
            ((List)entry.getValue()).removeIf(entryId -> !needUpdateList.contains(entry_jdIdMap.get(entryId)));
            log.info("$$$$$$$\u6267\u884c\u534f\u540c\u8ba2\u5355\uff1a" + pk + "\u4e0b\u63a8\uff0c\u53c2\u6570\u662f" + (String)pushParamMap.get(pk) + "\uff0c\u5206\u5f55ID:" + entry.getValue());
            if (((List)entry.getValue()).size() < 1) continue;
            try {
                if (StringUtils.isBlank((CharSequence)((CharSequence)pushParamMap.get(pk))) || StringUtils.equals((CharSequence)((CharSequence)pushParamMap.get(pk)), (CharSequence)"1")) {
                    MalOrderUtil.doAutoPushAndAudit("pm_purorderbill", "im_purreceivebill", "billentry", (List)entry.getValue(), selectFields, false);
                    continue;
                }
                MalOrderUtil.doAutoPushAndAudit("pm_purorderbill", "im_purinbill", "billentry", (List)entry.getValue(), selectFields, false);
            }
            catch (Exception e) {
                log.warn("\u81ea\u52a8\u751f\u6210\u4f9b\u5e94\u94fe\u6536\u8d27\u6216\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage() + "@@@" + ExceptionUtil.getStackTrace(e));
            }
        }
    }

    public static void doAutoPushAndAudit(String srcEntityKey, String targetEntityKey, String entryKey, List<String> entryIds, String selectFields, boolean isRollBack) {
        MalOrderUtil.doAutoPushAndAudit(srcEntityKey, targetEntityKey, entryKey, entryIds, selectFields, isRollBack, null);
    }

    public static List<DynamicObject> doAutoPushAndAudit(String srcEntityKey, String targetEntityKey, String entryKey, List<String> entryIds, String selectFields, boolean isRollBack, Map<String, String> customParams) {
        List targetData;
        block13: {
            DynamicObjectCollection billColl = MalOrderUtil.assemblePushBillData(srcEntityKey, entryIds, entryKey, selectFields);
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(srcEntityKey);
            pushArgs.setTargetEntityNumber(targetEntityKey);
            pushArgs.setBuildConvReport(false);
            if (customParams != null) {
                pushArgs.getCustomParams().putAll(customParams);
            }
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject billData : billColl) {
                ListSelectedRow row = new ListSelectedRow((Object)billData.getLong("id"));
                row.setEntryEntityKey(entryKey);
                row.setEntryPrimaryKeyValue((Object)billData.getLong(entryKey + ".id"));
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = null;
            targetData = null;
            try {
                result = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            catch (Exception e) {
                log.error("\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
                throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u518d\u6b21\u6267\u884c\u3002", (String)"MalOrderUtil_2", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
            String targetEntityName = ResManager.loadKDString((String)"\u6536\u8d27\u5355", (String)"MalOrderUtil_6", (String)"scm-common", (Object[])new Object[0]);
            if ("im_purinbill".equals(targetEntityKey)) {
                targetEntityName = ResManager.loadKDString((String)"\u5165\u5e93\u5355", (String)"MalOrderUtil_7", (String)"scm-common", (Object[])new Object[0]);
            }
            if (result.isSuccess()) {
                targetData = result.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objects, IDataEntityType iDataEntityType) {
                        BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType);
                    }
                }, mainType);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)targetEntityKey, (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                if (!saveResult.isSuccess()) {
                    log.error("@@@" + targetEntityKey + ":\u4fdd\u5b58\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getErrorInfoDetails(saveResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(ResManager.loadKDString((String)"{0}\u4fdd\u5b58\u5931\u8d25\uff1a{1}", (String)"MalOrderUtil_3", (String)"scm-common", (Object[])new Object[]{targetEntityName, ExceptionUtil.getErrorInfoDetails(saveResult.getAllErrorOrValidateInfo())}));
                }
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityKey, (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    if (isRollBack) {
                        MalOrderUtil.rollBackInWare(saveResult, targetEntityKey);
                    }
                    log.error("@@@" + targetEntityKey + ":\u63d0\u4ea4\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails(submitResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(ResManager.loadKDString((String)"{0}\u63d0\u4ea4\u5931\u8d25\uff1a{1}", (String)"MalOrderUtil_4", (String)"scm-common", (Object[])new Object[]{targetEntityName, ExceptionUtil.getErrorInfoDetails(submitResult.getAllErrorOrValidateInfo())}));
                }
                try {
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityKey, (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                    if (!auditResult.isSuccess()) {
                        if (isRollBack) {
                            MalOrderUtil.rollBackInWare(saveResult, targetEntityKey);
                        }
                        log.error("@@@" + targetEntityKey + ":\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails(auditResult.getAllErrorOrValidateInfo()));
                        throw new KDBizException(ResManager.loadKDString((String)"{0}\u5ba1\u6838\u5931\u8d25\uff1a{1}", (String)"MalOrderUtil_5", (String)"scm-common", (Object[])new Object[]{targetEntityName, ExceptionUtil.getErrorInfoDetails(auditResult.getAllErrorOrValidateInfo())}));
                    }
                    break block13;
                }
                catch (RuntimeException e) {
                    log.error("@@@" + targetEntityKey + ":\u5ba1\u6838\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
                    throw new KDBizException(ResManager.loadKDString((String)"{0}\u5ba1\u6838\u5931\u8d25\uff1a{1}", (String)"MalOrderUtil_5", (String)"scm-common", (Object[])new Object[]{targetEntityName, e.getMessage()}));
                }
            }
            log.error("\u81ea\u52a8\u4e0b\u63a8\u91c7\u8d2d\u6536\u8d27\u5931\u8d25\u539f\u56e0\uff1a\uff1a" + result.getMessage() + ExceptionUtil.getBillPushReportsErrorMsg(result));
            throw new KDBizException(result.getMessage() + " " + ExceptionUtil.getBillPushReportsErrorMsg(result));
        }
        return targetData;
    }

    private static void rollBackInWare(OperationResult saveOpResult, String targetEntityKey) {
        if (saveOpResult != null && saveOpResult.getSuccessPkIds() != null && saveOpResult.getSuccessPkIds().size() > 0) {
            Long[] pks = saveOpResult.getSuccessPkIds().toArray(new Long[0]);
            QFilter pkFilter = new QFilter("id", "in", (Object)pks);
            DeleteServiceHelper.delete((String)targetEntityKey, (QFilter[])new QFilter[]{pkFilter});
            log.info("kd.scm.common.util.MalOrderUtil.rollBackInvoice:\u56de\u6eda\u5f02\u5e38\uff0c\u5f02\u5e38\u7684\u5355\u636eID\uff1a" + saveOpResult.getSuccessPkIds());
        }
    }

    private static DynamicObjectCollection assemblePushBillData(String targetEntityKey, List<String> entryIds, String entryKey, String selectFields) {
        List ids = entryIds.stream().map(id -> Long.parseLong(id)).collect(Collectors.toList());
        QFilter filter = new QFilter(entryKey + ".id", "in", ids);
        return QueryServiceHelper.query((String)targetEntityKey, (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    private static List<String> getNeedUpdateIdSet(String token, Set<String> jdOrderSet) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, JdOrderInfo> jdOrderInfoMap = JDOrderUtil.getJdOrderState(token, jdOrderSet);
        for (Map.Entry<String, JdOrderInfo> entry : jdOrderInfoMap.entrySet()) {
            if (!entry.getValue().getState().equals("1")) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public static void generateEAS(DynamicObject[] purOrders, String token) {
        HashMap<String, DynamicObject> purorderMap = new HashMap<String, DynamicObject>();
        for (int i = 0; i < purOrders.length; ++i) {
            purorderMap.clear();
            HashSet<String> jdOrderSet = new HashSet<String>();
            DynamicObjectCollection purOrderEntries = purOrders[i].getDynamicObjectCollection("materialentry");
            String billno = purOrders[i].getString("billno");
            log.info("$$$$$$$purorder\u8ba2\u5355\u53f7" + billno);
            log.info("$$$$$$$JD data  start");
            for (int j = 0; j < purOrderEntries.size(); ++j) {
                DynamicObject purOrderEntry = (DynamicObject)purOrderEntries.get(j);
                String number = purOrderEntry.getString("jdorder.number");
                log.info("$$$$$$$JD\u8ba2\u5355\u53f7=" + number);
                if (StringUtils.isBlank((CharSequence)number)) continue;
                jdOrderSet.add(number);
                purorderMap.put(purOrderEntry.getString("id"), purOrderEntry);
            }
            log.info("$$$$$$$JD data  end");
            if (null == jdOrderSet || jdOrderSet.size() < 1) {
                log.info("$$$$$$$jdOrderSet is NULL");
                continue;
            }
            Map<String, JdOrderInfo> jdOrderInfoMap = JDOrderUtil.getJdOrderState(token, jdOrderSet);
            log.info("$$$$$$$jdOrderInfoMap" + jdOrderInfoMap.size());
            log.info("$$$$$$$jdOrderInfoMap" + jdOrderInfoMap);
            log.info("$$$$$$$purorderMap" + purorderMap);
            Map<String, List<Map<String, Object>>> JDIdMap = MalOrderUtil.jointJDIdMap(purorderMap, jdOrderInfoMap);
            log.info("$$$$$$$start call EAS");
            log.info("$$$$$$$JDIdMap" + JDIdMap);
            MalOrderUtil.callEASInterface(JDIdMap, purorderMap);
            log.info("$$$$$$$start call EAS END");
        }
    }

    public static String jdconfirmrecevie(Object[] ids) {
        StringBuilder result = new StringBuilder();
        HashSet<String> unconfirmOrder = new HashSet<String>();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter[] filters = new QFilter[]{filter};
        String selectProperties = "id,billno,entryentity.jdorder,entryentity.jdorder.number ";
        DynamicObject[] malOrders = BusinessDataServiceHelper.load((String)"mal_order", (String)selectProperties, (QFilter[])filters);
        log.info("$$$$$$$" + malOrders.length);
        HashSet<String> jdOrderSet = new HashSet<String>();
        for (int i = 0; i < malOrders.length; ++i) {
            DynamicObjectCollection purOrderEntries = malOrders[i].getDynamicObjectCollection("entryentity");
            String billno = malOrders[i].getString("billno");
            log.info("$$$$$$$" + billno);
            for (int j = 0; j < purOrderEntries.size(); ++j) {
                DynamicObject malOrderEntry = (DynamicObject)purOrderEntries.get(j);
                String number = malOrderEntry.getString("jdorder.number");
                log.info("$$$$$\u786e\u8ba4\u4eac\u4e1c\u8ba2\u5355\u83b7\u53d6\u4eac\u4e1c\u8ba2\u5355\u53f7" + number);
                if (StringUtils.isBlank((CharSequence)number)) {
                    unconfirmOrder.add(billno);
                    continue;
                }
                jdOrderSet.add(number);
            }
        }
        if (null == jdOrderSet || jdOrderSet.size() < 1) {
            return MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u662f\u6b63\u5f0f\u8ba2\u5355\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27\u3002", (String)"MalOrderUtil_0", (String)"scm-common", (Object[])new Object[0]), ((Object)unconfirmOrder).toString());
        }
        if (unconfirmOrder.size() > 0) {
            result.append(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u662f\u6b63\u5f0f\u8ba2\u5355\uff0c\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27\u3002", (String)"MalOrderUtil_1", (String)"scm-common", (Object[])new Object[0]), ((Object)unconfirmOrder).toString())).append('\n');
        }
        result.append(JDOrderUtil.confirmRecieve(jdOrderSet));
        return result.toString();
    }

    private static Map<String, List<Map<String, Object>>> jointJDIdMap(Map<String, DynamicObject> purorderMap, Map<String, JdOrderInfo> jdOrderInfoMap) {
        log.info("$$$$$\u65b9\u6cd5jointJDIdMap");
        HashMap<String, List<Map<String, Object>>> jdIDMap = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry<String, DynamicObject> entry : purorderMap.entrySet()) {
            log.info("$$$$$" + entry.getValue());
            List<HashMap<String, Object>> list = new ArrayList();
            DynamicObject entryobj = entry.getValue();
            DynamicObject parentobj = (DynamicObject)entryobj.getParent();
            String entryJDOrderId = entryobj.getString("jdorder.number");
            log.info("$$$$$jointJDIdMap->jdorder.number=" + entryJDOrderId);
            JdOrderInfo orderInfo = jdOrderInfoMap.get(entryJDOrderId);
            if (null == orderInfo) break;
            log.info("$$$$$" + entryJDOrderId + "\u4eac\u4e1c\u5355\u636e\u72b6\u6001" + orderInfo.getState());
            if (!orderInfo.getState().equals("1")) continue;
            if (null != jdIDMap.get(parentobj.getPkValue().toString())) {
                log.info("$$$$$\u6709\u76f8\u540c\u8ba2\u5355" + entryJDOrderId);
                list = (List)jdIDMap.get(parentobj.getPkValue().toString());
            }
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            detailMap.put("warehouse", "");
            detailMap.put("location", "");
            detailMap.put("lot", "");
            detailMap.put("project", "");
            detailMap.put("trace", "");
            detailMap.put("unit", ((DynamicObject)entryobj.get("unit")).get("number"));
            detailMap.put("basicUnit", ((DynamicObject)entryobj.get("basicunit")).get("number"));
            detailMap.put("note", "");
            detailMap.put("entryId", entryobj.get("poentryid"));
            detailMap.put("billid", entryobj.get("pobillid"));
            detailMap.put("qty", entryobj.get("qty"));
            detailMap.put("srcEntryId", entryobj.getPkValue().toString());
            detailMap.put("srcBillId", parentobj.getPkValue().toString());
            detailMap.put("source", "mal");
            list.add(detailMap);
            jdIDMap.put(parentobj.getPkValue().toString(), list);
        }
        return jdIDMap;
    }

    @Deprecated
    public static void callEASInterface(Map<String, List<Map<String, Object>>> jdIDMap) {
        MalOrderUtil.callEASInterface(jdIDMap, new HashMap<String, DynamicObject>());
    }

    public static void callEASInterface(Map<String, List<Map<String, Object>>> jdIDMap, Map<String, DynamicObject> purorderMap) {
        log.info("callEASInterface");
        HashMap<String, String> org_IdMap = new HashMap<String, String>(16);
        HashSet<String> recOrgIdSet = new HashSet<String>(16);
        DynamicObject orderBill = null;
        if (!purorderMap.isEmpty()) {
            DynamicObject orderEntry = purorderMap.values().stream().findFirst().get();
            orderBill = (DynamicObject)orderEntry.getParent();
            DynamicObject org = orderEntry.getDynamicObject("entryrcvorg");
            if (org != null) {
                recOrgIdSet.add(org.getString("id"));
                org_IdMap.put(org.getString("number"), org.getString("id"));
            }
        }
        HashMap<String, Object> billInfoMap = new HashMap<String, Object>(1024);
        for (Map.Entry<String, List<Map<String, Object>>> entry : jdIDMap.entrySet()) {
            billInfoMap.put("billstatus", ParamUtil.getParam("eae607fb000143ac", "recbillstatus"));
            billInfoMap.put(entry.getKey(), entry.getValue());
            billInfoMap.put("botpNumber", "INM-001");
            Map<String, String> paramMap = ParamUtil.getParam("eae607fb000143ac", "recbillstatus", recOrgIdSet);
            org_IdMap.replaceAll((k, v) -> (String)paramMap.get(v));
            billInfoMap.put("billstatus1", org_IdMap);
            log.info("$$$$$$$billInfoMap" + billInfoMap);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "receive");
            param.put("billtype", "pur_outstock");
            param.put("data", billInfoMap);
            param.put("action", TO_RECEIVE);
            param.put("code", "200");
            log.info("$$$$$$$\u8c03\u7528EAS\u63a5\u53e3");
            log.info("$$$$$$$param" + param);
            if (orderBill != null) {
                ApiUtil.putUserNUmberData(param, "mal_order", new DynamicObject[]{orderBill});
            } else {
                ApiUtil.putUserNUmberData(param, "mal_order");
            }
            String msg = ApiUtil.purSaloutToRec(param);
            log.info("$$$$$$$msg" + msg);
            log.info("$$$$$$$\u8c03\u7528\u7ed3\u675f");
            Map msgMap = JacksonJsonUtil.fromJson(msg, Map.class);
            LinkedHashMap errorMsg = (LinkedHashMap)msgMap.get("error");
            if (errorMsg == null || errorMsg.size() == 0) continue;
            log.info("\u751f\u6210\u5931\u8d25\uff1a" + errorMsg.get("error"));
            if (null == errorMsg.get(entry.getKey())) continue;
            LinkedHashMap errmap = (LinkedHashMap)errorMsg.get(entry.getKey());
            log.info("\u751f\u6210\u5931\u8d25\uff1a" + errmap.get("error"));
        }
    }

    public static boolean hasAttachmentUploading(IFormView view) {
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String uploadingAttJson = cache.get("UploadingAtt" + view.getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }
}

