/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.VectorAp;

public class MetaDataUtil {
    public static List<String> getColumnKey(String entityKey, String entryKey) {
        ArrayList<String> columnList = new ArrayList<String>();
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        EntryAp entryAp = null;
        for (ControlAp ap : formmeta.getItems()) {
            if (!entryKey.equals(ap.getKey())) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        if (null != entryAp) {
            for (ControlAp ap : entryAp.getItems()) {
                int visVal = ap.getVisibleValue();
                if (ap.isHidden() || visVal == 0) continue;
                columnList.add(ap.getKey());
            }
        }
        return columnList;
    }

    public static List<ControlAp<?>> getControlAps(FormMetadata formmeta, EntityMetadata entitymeta, String entryKey) {
        ArrayList columnList = new ArrayList();
        if (entitymeta != null && formmeta != null) {
            formmeta.bindEntityMetadata(entitymeta);
            EntryAp entryAp = null;
            for (ControlAp ap : formmeta.getItems()) {
                if (!entryKey.equals(ap.getKey())) continue;
                entryAp = (EntryAp)ap;
                break;
            }
            if (null != entryAp) {
                for (ControlAp ap : entryAp.getItems()) {
                    columnList.add(ap);
                }
            }
        }
        return columnList;
    }

    public static Map<String, String> getProMap(String entityKey) {
        LinkedHashMap<String, String> columnMap = new LinkedHashMap();
        FormMetadata formmeta = MetaDataUtil.getFormMetaData(entityKey);
        columnMap = MetaDataUtil.getPro(formmeta.getItems(), null);
        return columnMap;
    }

    public static Map<String, String> getProMap(String entityKey, boolean isHidden) {
        LinkedHashMap<String, String> columnMap = new LinkedHashMap();
        FormMetadata formmeta = MetaDataUtil.getFormMetaData(entityKey);
        columnMap = MetaDataUtil.getPro(formmeta.getItems(), null, isHidden);
        return columnMap;
    }

    public static FormMetadata getFormMetaData(String entityKey) {
        String entityId = MetadataDao.getIdByNumber((String)entityKey, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        return formmeta;
    }

    public static Map<String, String> getPro(List<ControlAp<?>> items, ControlAp<?> parent) {
        return MetaDataUtil.getPro(items, parent, false);
    }

    private static Map<String, String> getPro(List<ControlAp<?>> items, ControlAp<?> parent, boolean isHidden) {
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        EntryAp entryAp = null;
        StringBuilder val = null;
        for (ControlAp<?> ap : items) {
            LocaleString displayName;
            if (ap instanceof EntryAp) {
                entryAp = (EntryAp)ap;
                columnMap.putAll(MetaDataUtil.getPro(entryAp.getItems(), entryAp));
                continue;
            }
            if (ap instanceof BillFormAp || ap instanceof ContainerAp || ap instanceof ButtonAp || ap instanceof BarItemAp || ap instanceof FlexPanelAp || ap instanceof VectorAp || null == parent && ap instanceof EntryFieldAp) continue;
            if (!isHidden) {
                int visVal = ap.getVisibleValue();
                if (ap.isHidden() || visVal == 0) continue;
            }
            if (null == (displayName = ap.getName())) continue;
            String proKey = ap.getKey();
            String text = displayName.toString();
            if (null != parent) {
                val = new StringBuilder();
                val.append(parent.getKey());
                val.append('.');
                val.append(proKey);
                proKey = val.toString();
                val = new StringBuilder();
                val.append(parent.getName());
                val.append('.');
                val.append(ap.getName());
                text = val.toString();
            }
            columnMap.put(proKey, text);
        }
        return columnMap;
    }

    public static List<ComboItem> buildPropComboItems(Map<String, String> propertiesMap) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(propertyEntry.getValue()));
            item.setValue(propertyEntry.getKey());
            items.add(item);
        }
        items.sort(new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem comb1, ComboItem comb2) {
                String comb1Str = comb1.getValue();
                String comb2Str = comb2.getValue();
                if ("".equals(comb1Str)) {
                    return -1;
                }
                if ("".equals(comb2Str)) {
                    return 1;
                }
                if (comb1Str.indexOf(46) >= 0 && comb2Str.indexOf(46) < 0) {
                    return 1;
                }
                if (comb1Str.indexOf(46) < 0 && comb2Str.indexOf(46) >= 0) {
                    return -1;
                }
                return comb1.getValue().compareTo(comb1.getValue());
            }
        });
        return items;
    }

    public static List<ComboItem> getOpreateComboItemList(String entityNumber) {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(16);
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (dataEntityOperate.size() == 0) {
            return comboList;
        }
        LocaleString localeString = null;
        for (Map operate : dataEntityOperate) {
            String key = (String)operate.get("key");
            Object name = operate.get("name");
            if (name == null) continue;
            localeString = new LocaleString(ResManager.loadKDString((String)"\u672a\u547d\u540d\u64cd\u4f5c", (String)"PdsMetadataUtil_0", (String)"scm-pds-common", (Object[])new Object[0]));
            localeString = name instanceof Map ? LocaleString.fromMap((Map)((Map)name)) : new LocaleString(name.toString());
            comboList.add(new ComboItem(localeString, key));
        }
        return comboList;
    }
}

