/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.common.util.cal.ICal;

public abstract class AbstractCal
implements ICal {
    private static Log log = LogFactory.getLog(AbstractCal.class);
    private BigDecimal ZERO = BigDecimal.ZERO;
    private String NULL = "null";
    private String PRICE = "price";
    private String TAXPRICE = "taxprice";
    private String ACTUALPRICE = "actprice";
    private String ACTUALTAXPRICE = "acttaxprice";
    private String AMOUNT = "amount";
    private String TAXAMOUNT = "taxamount";
    private String TAX = "tax";
    private String DISCOUNTRATE = "dctrate";
    private String DISCOUNTAMOUNT = "dctamount";
    private String TAXRATE = "taxrate";
    private String QTY = "qty";
    private String SUMQTY = "sumqty";
    private String TAXTYPE = "taxtype";
    private String HEAD_AMOUNT = "sumamount";
    private String HEAD_TAXAMOUNT = "sumtaxamount";
    private String HEAD_TAX = "sumtax";
    private int amoutScale = 2;

    public int getAmoutscale() {
        return this.amoutScale;
    }

    public void setAmoutscale(int amoutScale) {
        this.amoutScale = amoutScale;
    }

    public String getTAXRATE() {
        return this.TAXRATE;
    }

    public void setTAXRATE(String taxrate) {
        this.TAXRATE = taxrate;
    }

    public String getPRICE() {
        return this.PRICE;
    }

    public void setPRICE(String price) {
        this.PRICE = price;
    }

    public String getTAXPRICE() {
        return this.TAXPRICE;
    }

    public void setTAXPRICE(String taxprice) {
        this.TAXPRICE = taxprice;
    }

    public String getACTUALPRICE() {
        return this.ACTUALPRICE;
    }

    public void setACTUALPRICE(String actualprice) {
        this.ACTUALPRICE = actualprice;
    }

    public String getACTUALTAXPRICE() {
        return this.ACTUALTAXPRICE;
    }

    public void setACTUALTAXPRICE(String actualtaxprice) {
        this.ACTUALTAXPRICE = actualtaxprice;
    }

    public String getAMOUNT() {
        return this.AMOUNT;
    }

    public void setAMOUNT(String amount) {
        this.AMOUNT = amount;
    }

    public String getTAXAMOUNT() {
        return this.TAXAMOUNT;
    }

    public void setTAXAMOUNT(String taxamount) {
        this.TAXAMOUNT = taxamount;
    }

    public String getTAX() {
        return this.TAX;
    }

    public void setTAX(String tax) {
        this.TAX = tax;
    }

    public String getDISCOUNTRATE() {
        return this.DISCOUNTRATE;
    }

    public void setDISCOUNTRATE(String dISCOUNTRATE) {
        this.DISCOUNTRATE = dISCOUNTRATE;
    }

    public String getTAXTYPE() {
        return this.TAXTYPE;
    }

    public void setTAXTYPE(String tAXTYPE) {
        this.TAXTYPE = tAXTYPE;
    }

    public String getDISCOUNTAMOUNT() {
        return this.DISCOUNTAMOUNT;
    }

    public void setDISCOUNTAMOUNT(String discountamount) {
        this.DISCOUNTAMOUNT = discountamount;
    }

    public String getQTY() {
        return this.QTY;
    }

    public void setQTY(String qty) {
        this.QTY = qty;
    }

    public String getHEAD_AMOUNT() {
        return this.HEAD_AMOUNT;
    }

    public void setHEAD_AMOUNT(String head_amount) {
        this.HEAD_AMOUNT = head_amount;
    }

    public String getHEAD_TAXAMOUNT() {
        return this.HEAD_TAXAMOUNT;
    }

    public void setHEAD_TAXAMOUNT(String head_taxamount) {
        this.HEAD_TAXAMOUNT = head_taxamount;
    }

    public String getHEAD_TAX() {
        return this.HEAD_TAX;
    }

    public void setHEAD_TAX(String head_tax) {
        this.HEAD_TAX = head_tax;
    }

    protected abstract void initFiledValue();

    @Override
    public void calEntryPriceByTaxPrice(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.TAXPRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.TAXRATE);
        int scale = this.getPricePrecision(datamodel, entryKey);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPrice(taxPrice, taxRate, scale) : CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
        datamodel.setValue(this.PRICE, (Object)price, index);
    }

    @Override
    public void calEntryTaxPriceByPrice(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.PRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.TAXRATE);
        int scale = this.getPricePrecision(datamodel, entryKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        datamodel.setValue(this.TAXPRICE, (Object)taxPrice, index);
    }

    @Override
    public void calEntryActualPrice(IDataModel datamodel, String entryKey) {
        if (this.ACTUALPRICE == null) {
            return;
        }
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.AMOUNT);
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
        int scale = this.getPricePrecision(datamodel, entryKey);
        BigDecimal actualPrice = CalculateUtils.calActualPrice(amount, qty, scale);
        datamodel.setValue(this.ACTUALPRICE, (Object)actualPrice, index);
    }

    @Override
    public void calEntryActualTaxPrice(IDataModel datamodel, String entryKey) {
        if (this.ACTUALTAXPRICE == null) {
            return;
        }
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.TAXAMOUNT);
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
        int scale = this.getPricePrecision(datamodel, entryKey);
        BigDecimal actualTaxPrice = CalculateUtils.calActualTaxPrice(taxAmount, qty, scale);
        datamodel.setValue(this.ACTUALTAXPRICE, (Object)actualTaxPrice, index);
    }

    @Override
    public void calEntryTaxAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        boolean containTax = this.isContainTax(taxType);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = this.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (containTax) {
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
            BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.TAXPRICE);
            BigDecimal discount = this.getEntryBigDecimalValue(datamodel, index, this.DISCOUNTRATE);
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discount, scale);
        } else {
            BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.AMOUNT);
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.TAX);
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        datamodel.setValue(this.TAXAMOUNT, (Object)taxAmount, index);
    }

    @Override
    public void calEntryTax(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.TAXAMOUNT);
        BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.TAXRATE);
        BigDecimal tax = this.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.AMOUNT);
            tax = CalculateUtils.calTax(amount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
        }
        datamodel.setValue(this.TAX, (Object)tax, index);
    }

    @Override
    public void calEntryAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = this.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.TAXAMOUNT);
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.TAX);
            amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.DISCOUNTRATE);
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
            BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.PRICE);
            amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
        }
        datamodel.setValue(this.AMOUNT, (Object)amount, index);
    }

    @Override
    public void calEntryDiscountRate(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.TAXPRICE);
        BigDecimal discountAmount = this.getEntryBigDecimalValue(datamodel, index, this.DISCOUNTAMOUNT);
        BigDecimal discountRate = this.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        discountRate = CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
        datamodel.setValue(this.DISCOUNTRATE, (Object)discountRate, index);
    }

    @Override
    public void calEntryDiscountAmount(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.TAXPRICE);
        BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.DISCOUNTRATE);
        BigDecimal discountAmount = this.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        discountAmount = CalculateUtils.calDiscountAmountByPercent(discountRate, qty, taxPrice, scale);
        datamodel.setValue(this.DISCOUNTAMOUNT, (Object)discountAmount, index);
    }

    @Override
    public void calEntryBaseQty(IDataModel datamodel, String entryKey) {
    }

    @Override
    public void calEntryAssistQty(IDataModel datamodel, String entryKey) {
    }

    @Override
    public void calEntryPriceByAmount(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.AMOUNT);
        BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.DISCOUNTRATE);
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
        BigDecimal price = this.ZERO;
        int scale = this.getPricePrecision(datamodel, entryKey);
        price = CalculateUtils.calPrice(amount, qty, discountRate, scale);
        datamodel.setValue(this.PRICE, (Object)price, index);
    }

    @Override
    public void calEntryTaxPriceByTaxAmount(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, this.TAXAMOUNT);
        BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.DISCOUNTRATE);
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.QTY);
        BigDecimal taxPrice = this.ZERO;
        int scale = this.getPricePrecision(datamodel, entryKey);
        taxPrice = CalculateUtils.calTaxPrice(taxAmount, qty, discountRate, scale);
        datamodel.setValue(this.TAXPRICE, (Object)taxPrice, index);
    }

    @Override
    public void calSumAmount(IDataModel datamodel, String entryKey) {
        BigDecimal sumAmount = this.ZERO;
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            sumAmount = sumAmount.add(entry.getBigDecimal(this.AMOUNT));
        }
        datamodel.setValue(this.HEAD_AMOUNT, (Object)sumAmount);
    }

    @Override
    public void calSumTax(IDataModel datamodel, String entryKey) {
        BigDecimal sumTax = this.ZERO;
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            sumTax = sumTax.add(entry.getBigDecimal(this.TAX));
        }
        datamodel.setValue(this.HEAD_TAX, (Object)sumTax);
    }

    @Override
    public void calSumQty(IDataModel datamodel, String entryKey) {
        BigDecimal sumQty = this.ZERO;
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            sumQty = sumQty.add(entry.getBigDecimal(this.QTY));
        }
        datamodel.setValue(this.SUMQTY, (Object)sumQty);
    }

    @Override
    public void calSumTaxAmount(IDataModel datamodel, String entryKey) {
        BigDecimal sumTaxAmount = this.ZERO;
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            sumTaxAmount = sumTaxAmount.add(entry.getBigDecimal(this.TAXAMOUNT));
        }
        datamodel.setValue(this.HEAD_TAXAMOUNT, (Object)sumTaxAmount);
    }

    public void calByEntryTaxPriceChange(IDataModel datamodel, String entryKey) {
        log.info(entryKey + "\u7684taxPrice\u89e6\u53d1\u8ba1\u7b97\u3002\u3002\u3002");
        this.calEntryPriceByTaxPrice(datamodel, entryKey);
        this.calEntryTaxAmount(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryAmount(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    public void calByEntryPriceChange(IDataModel datamodel, String entryKey) {
        this.calEntryTaxPriceByPrice(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calEntryAmount(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryTaxAmount(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    public void calByEntryQtyChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
        }
        this.calSum(datamodel, entryKey);
    }

    public void calByEntryAmountChange(IDataModel datamodel, String entryKey) {
        this.calEntryPriceByAmount(datamodel, entryKey);
        this.calEntryTaxPriceByPrice(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryTaxAmount(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    public void calByEntryTaxAmountChange(IDataModel datamodel, String entryKey) {
        this.calEntryTaxPriceByTaxAmount(datamodel, entryKey);
        this.calEntryPriceByTaxPrice(datamodel, entryKey);
        this.calEntryDiscountRate(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    public void calByEntryDiscountRateChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryActualPrice(datamodel, entryKey);
            this.calEntryActualTaxPrice(datamodel, entryKey);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryActualPrice(datamodel, entryKey);
            this.calEntryActualTaxPrice(datamodel, entryKey);
        }
        this.calSum(datamodel, entryKey);
    }

    public void calByEntryDiscountAmountChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountRate(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryActualPrice(datamodel, entryKey);
            this.calEntryActualTaxPrice(datamodel, entryKey);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountRate(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryActualPrice(datamodel, entryKey);
            this.calEntryActualTaxPrice(datamodel, entryKey);
        }
        this.calSum(datamodel, entryKey);
    }

    protected void calSum(IDataModel datamodel, String entryKey) {
        this.calSumAmount(datamodel, entryKey);
        this.calSumTax(datamodel, entryKey);
        this.calSumTaxAmount(datamodel, entryKey);
        this.calSumQty(datamodel, entryKey);
    }

    public void calByEntryTaxRateChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        boolean containTax = this.isContainTax(taxType);
        if (containTax) {
            this.calEntryPriceByTaxPrice(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
            this.calSumAmount(datamodel, entryKey);
        } else {
            this.calEntryTaxPriceByPrice(datamodel, entryKey);
            this.calEntryDiscountAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calSumTaxAmount(datamodel, entryKey);
        }
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSumTax(datamodel, entryKey);
    }

    public void calByEntryTaxChange(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.TAXTYPE);
        boolean containTax = this.isContainTax(taxType);
        if (containTax) {
            this.calEntryAmount(datamodel, entryKey);
            this.calSumAmount(datamodel, entryKey);
        } else {
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calSumTaxAmount(datamodel, entryKey);
        }
        this.calSumTax(datamodel, entryKey);
    }

    protected boolean isContainTax(String taxType) {
        boolean containTax = false;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            containTax = true;
        }
        return containTax;
    }

    protected BigDecimal getEntryBigDecimalValue(IDataModel datamodel, int index, String fieldName) {
        if (StringUtils.equals((CharSequence)this.NULL, (CharSequence)fieldName)) {
            return this.ZERO;
        }
        Object obj = this.getEntryObject(datamodel, index, fieldName);
        return null == obj ? this.ZERO : (BigDecimal)obj;
    }

    protected String getHeadStringValue(IDataModel datamodel, String fieldName) {
        if (fieldName.equals(this.NULL)) {
            return null;
        }
        Object obj = this.getHeadObject(datamodel, fieldName);
        return null == obj ? null : obj.toString();
    }

    protected boolean getHeadBooleanValue(IDataModel datamodel, String fieldName) {
        if (fieldName.equals(this.NULL)) {
            return false;
        }
        Object obj = this.getHeadObject(datamodel, fieldName);
        return null != obj && Boolean.parseBoolean(obj.toString());
    }

    protected Object getHeadObject(IDataModel datamodel, String fieldName) {
        return datamodel.getValue(fieldName);
    }

    protected Object getEntryObject(IDataModel datamodel, int index, String fieldName) {
        return datamodel.getValue(fieldName, index);
    }

    protected int getTaxRatePrecision(IDataModel datamodel, String entryKey) {
        return 2;
    }

    protected int getQtyPrecision(IDataModel datamodel, String entryKey, int index) {
        int qtyPrecision = 6;
        Object unit = datamodel.getValue("unit", index);
        if (null != unit && unit instanceof DynamicObject) {
            DynamicObject unitDy = (DynamicObject)unit;
            qtyPrecision = unitDy.getInt("precision");
        }
        return qtyPrecision;
    }

    protected int getAmtPrecision(IDataModel datamodel, String entryKey) {
        int amtPrecision = 6;
        Object currency = datamodel.getValue("curr");
        if (null != currency && currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }

    protected int getPricePrecision(IDataModel datamodel, String entryKey) {
        int pricePrecision = 6;
        Object currency = datamodel.getValue("curr");
        if (null != currency && currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            pricePrecision = curr.getInt("priceprecision");
        }
        return pricePrecision;
    }
}

