/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ORMUtil;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.cal.CalculateUtils;

public class Cal4DynamicObj {
    private static Log log = LogFactory.getLog(Cal4DynamicObj.class);
    private static Map<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();

    public static void calByQty(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        String taxType = bill.getString("taxtype");
        for (DynamicObject entryCol : entryCols) {
            if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entryCol);
                Cal4DynamicObj.calEntryDiscountAmount(bill, entryCol);
                Cal4DynamicObj.calEntryAmount(bill, entryCol);
                Cal4DynamicObj.calEntryTax(bill, entryCol);
                Cal4DynamicObj.calEntryTaxAmount(bill, entryCol);
                continue;
            }
            Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entryCol);
            Cal4DynamicObj.calEntryDiscountAmount(bill, entryCol);
            Cal4DynamicObj.calEntryTaxAmount(bill, entryCol);
            Cal4DynamicObj.calEntryTax(bill, entryCol);
            Cal4DynamicObj.calEntryAmount(bill, entryCol);
        }
        Cal4DynamicObj.calSum(bill, entryKey);
        Cal4DynamicObj.releaseData();
    }

    public static void calEntryByQty(DynamicObject bill, DynamicObject entryCol) {
        String taxType = bill.getString("taxtype");
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entryCol);
            Cal4DynamicObj.calEntryDiscountAmount(bill, entryCol);
            Cal4DynamicObj.calEntryAmount(bill, entryCol);
            Cal4DynamicObj.calEntryTax(bill, entryCol);
            Cal4DynamicObj.calEntryTaxAmount(bill, entryCol);
        } else {
            Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entryCol);
            Cal4DynamicObj.calEntryDiscountAmount(bill, entryCol);
            Cal4DynamicObj.calEntryTaxAmount(bill, entryCol);
            Cal4DynamicObj.calEntryTax(bill, entryCol);
            Cal4DynamicObj.calEntryAmount(bill, entryCol);
        }
        Cal4DynamicObj.releaseData();
    }

    public static void calByTaxAmount(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entryCols) {
            Cal4DynamicObj.calEntryTaxPriceByTaxAmount(bill, entry);
            Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entry);
            Cal4DynamicObj.calEntryTax(bill, entry);
            Cal4DynamicObj.calEntryAmount(bill, entry);
            Cal4DynamicObj.calEntryDiscountAmount(bill, entry);
        }
        Cal4DynamicObj.calSum(bill, entryKey);
        Cal4DynamicObj.releaseData();
    }

    public static void calByAmount(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entryCols) {
            Cal4DynamicObj.calEntryPriceByAmount(bill, entry);
            Cal4DynamicObj.calEntryTaxPriceByPrice(bill, entry);
            Cal4DynamicObj.calEntryDiscountAmount(bill, entry);
            Cal4DynamicObj.calEntryTax(bill, entry);
            Cal4DynamicObj.calEntryTaxAmount(bill, entry);
        }
        Cal4DynamicObj.calSum(bill, entryKey);
        Cal4DynamicObj.releaseData();
    }

    public static void calEntryByTaxAmount(DynamicObject bill, DynamicObject entry) {
        Cal4DynamicObj.calEntryTaxPriceByTaxAmount(bill, entry);
        Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entry);
        Cal4DynamicObj.calEntryTax(bill, entry);
        Cal4DynamicObj.calEntryAmount(bill, entry);
        Cal4DynamicObj.calEntryDiscountAmount(bill, entry);
        Cal4DynamicObj.releaseData();
    }

    public static void calEntryByAmount(DynamicObject bill, DynamicObject entry) {
        Cal4DynamicObj.calEntryPriceByAmount(bill, entry);
        Cal4DynamicObj.calEntryTaxPriceByPrice(bill, entry);
        Cal4DynamicObj.calEntryDiscountAmount(bill, entry);
        Cal4DynamicObj.calEntryTax(bill, entry);
        Cal4DynamicObj.calEntryTaxAmount(bill, entry);
        Cal4DynamicObj.releaseData();
    }

    public static void reCalBill(DynamicObject bill, String entryKey) {
        log.info(entryKey + "@\u5f00\u59cb\u91cd\u7b97--------------------");
        String taxType = bill.getString("taxtype");
        boolean containTax = Cal4DynamicObj.isContainTax(taxType);
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entryCol : entryCols) {
            if (containTax) {
                Cal4DynamicObj.calByTaxPrice(bill, entryCol);
                continue;
            }
            Cal4DynamicObj.calByPrice(bill, entryCol);
        }
        Cal4DynamicObj.calSum(bill, entryKey);
        Cal4DynamicObj.releaseData();
        log.info(entryKey + "@\u91cd\u7b97\u7ed3\u675f--------------------");
    }

    @Deprecated
    public static void calByPrice(DynamicObject bill, DynamicObject entry) {
        log.info("@\u4e0d\u542b\u7a0e\u65f6-------------------------");
        Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entry);
        Cal4DynamicObj.calEntryDiscountAmount(bill, entry);
        Cal4DynamicObj.calEntryAmount(bill, entry);
        Cal4DynamicObj.calEntryTax(bill, entry);
        Cal4DynamicObj.calEntryTaxAmount(bill, entry);
    }

    @Deprecated
    public static void calByTaxPrice(DynamicObject bill, DynamicObject entry) {
        log.info("@\u542b\u7a0e\u65f6\u8ba1\u7b97-------------------------");
        Cal4DynamicObj.calEntryPriceOrTaxPrice(bill, entry);
        Cal4DynamicObj.calEntryTaxAmount(bill, entry);
        Cal4DynamicObj.calEntryTax(bill, entry);
        Cal4DynamicObj.calEntryAmount(bill, entry);
        Cal4DynamicObj.calEntryDiscountAmount(bill, entry);
    }

    public static void calBillByPrice(DynamicObject bill, String entryKey) {
        log.info("@\u4e0d\u542b\u7a0e\u65f6-------------------------");
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entryCols) {
            Cal4DynamicObj.calByPrice(bill, entry);
        }
        Cal4DynamicObj.calSum(bill, entryKey);
        Cal4DynamicObj.releaseData();
    }

    public static void calBillByTaxPrice(DynamicObject bill, String entryKey) {
        log.info("@\u542b\u7a0e\u65f6\u8ba1\u7b97-------------------------");
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entryCols) {
            Cal4DynamicObj.calByTaxPrice(bill, entry);
        }
        Cal4DynamicObj.calSum(bill, entryKey);
        Cal4DynamicObj.releaseData();
    }

    public static void calEntryByPrice(DynamicObject bill, DynamicObject entry) {
        Cal4DynamicObj.calByPrice(bill, entry);
    }

    public static void calEntryByTaxPrice(DynamicObject bill, DynamicObject entry) {
        Cal4DynamicObj.calByTaxPrice(bill, entry);
    }

    public static void calEntryTaxPriceByTaxAmount(DynamicObject bill, DynamicObject entry) {
        int scale = Cal4DynamicObj.getPricePrecision(bill, entry);
        BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entry.get("taxamount"));
        BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
        BigDecimal taxPrice = CalConstant.BIGDECIMAL_ZERO;
        taxPrice = CalculateUtils.calTaxPrice(taxAmount, qty, discountRate, scale);
        entry.set("taxprice", (Object)taxPrice);
    }

    public static void calEntryPriceByAmount(DynamicObject bill, DynamicObject entry) {
        int scale = Cal4DynamicObj.getPricePrecision(bill, entry);
        BigDecimal amount = CommonUtil.getBigDecimalPro(entry.get("amount"));
        BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
        BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
        price = CalculateUtils.calPrice(amount, qty, discountRate, scale);
        entry.set("price", (Object)price);
    }

    public static void calEntryTaxPriceByPrice(DynamicObject bill, DynamicObject entry) {
        int scale = Cal4DynamicObj.getPricePrecision(bill, entry);
        BigDecimal price = CommonUtil.getBigDecimalPro(entry.get("price"));
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(entry.get("taxrate"));
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        entry.set("taxprice", (Object)taxPrice);
    }

    public static void calEntryPriceOrTaxPrice(DynamicObject bill, DynamicObject entry) {
        int scale = Cal4DynamicObj.getPricePrecision(bill, entry);
        String taxType = bill.getString("taxtype");
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(entry.get("taxrate"));
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
            BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
            price = CalculateUtils.calPrice(taxPrice, taxRate, scale);
            entry.set("price", (Object)price);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
            BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
            price = CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
            entry.set("price", (Object)price);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal price = CommonUtil.getBigDecimalPro(entry.get("price"));
            BigDecimal taxPrice = CalConstant.BIGDECIMAL_ZERO;
            taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
            entry.set("taxprice", (Object)taxPrice);
        }
    }

    public static void calEntryDiscountAmount(DynamicObject bill, DynamicObject entry) {
        BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
        BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
        BigDecimal discountAmount = CalConstant.BIGDECIMAL_ZERO;
        int scale = Cal4DynamicObj.getAmtPrecision(bill, entry);
        discountAmount = CalculateUtils.calDiscountAmountByPercent(discountRate, qty, taxPrice, scale);
        entry.set("dctamount", (Object)discountAmount);
    }

    public static void calEntryTaxAmount(DynamicObject bill, DynamicObject entry) {
        BigDecimal taxAmount = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
        int scale = Cal4DynamicObj.getAmtPrecision(bill, entry);
        String taxType = bill.getString("taxtype");
        boolean containTax = Cal4DynamicObj.isContainTax(taxType);
        if (containTax) {
            BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discountRate, scale);
        } else {
            BigDecimal amount = CommonUtil.getBigDecimalPro(entry.get("amount"));
            BigDecimal tax = CommonUtil.getBigDecimalPro(entry.get("tax"));
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        entry.set("taxamount", (Object)taxAmount);
    }

    public static void calEntryTax(DynamicObject bill, DynamicObject entry) {
        BigDecimal amount = CommonUtil.getBigDecimalPro(entry.get("amount"));
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(entry.get("taxrate"));
        BigDecimal tax = CommonUtil.getBigDecimalPro(entry.get("tax"));
        BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entry.get("taxamount"));
        String taxType = bill.getString("taxtype");
        int scale = Cal4DynamicObj.getAmtPrecision(bill, entry);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTax(amount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
        }
        entry.set("tax", (Object)tax);
    }

    public static void calEntryAmount(DynamicObject bill, DynamicObject entry) {
        BigDecimal amount = CalConstant.BIGDECIMAL_ZERO;
        int scale = Cal4DynamicObj.getAmtPrecision(bill, entry);
        String taxType = bill.getString("taxtype");
        boolean containTax = Cal4DynamicObj.isContainTax(taxType);
        if (containTax) {
            BigDecimal tax = CommonUtil.getBigDecimalPro(entry.get("tax"));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entry.get("taxamount"));
            amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else {
            BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
            BigDecimal price = CommonUtil.getBigDecimalPro(entry.get("price"));
            BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
            amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
        }
        entry.set("amount", (Object)amount);
    }

    private static boolean isContainTax(String taxType) {
        boolean containTax = false;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            containTax = true;
        }
        return containTax;
    }

    public static void calSum(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        BigDecimal sumTax = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal sumAmount = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal sumTaxAmount = CalConstant.BIGDECIMAL_ZERO;
        for (DynamicObject entryCol : entryCols) {
            BigDecimal tax = CommonUtil.getBigDecimalPro(entryCol.get("tax"));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entryCol.get("taxamount"));
            BigDecimal amount = CommonUtil.getBigDecimalPro(entryCol.get("amount"));
            sumTax = sumTax.add(tax);
            sumAmount = sumAmount.add(amount);
            sumTaxAmount = sumTaxAmount.add(taxAmount);
        }
        bill.set("sumtax", (Object)sumTax);
        bill.set("sumtaxamount", (Object)sumTaxAmount);
        bill.set("sumamount", (Object)sumAmount);
    }

    public static int getScale(DynamicObject bill, DynamicObject entry) {
        return 6;
    }

    public static int getAmtPrecision(DynamicObject bill, DynamicObject entry) {
        DynamicObject currency;
        int amtPrecision = 6;
        Object curr = bill.get("curr");
        if (null != curr && curr instanceof DynamicObject) {
            DynamicObject currency2 = (DynamicObject)curr;
            amtPrecision = currency2.getInt("amtprecision");
        } else if (null != curr && curr instanceof Long && null != (currency = Cal4DynamicObj.getCurrency((Long)curr))) {
            amtPrecision = currency.getInt("amtprecision");
        }
        return amtPrecision;
    }

    public static int getPricePrecision(DynamicObject bill, DynamicObject entry) {
        DynamicObject currency;
        int pricePrecision = 6;
        Object curr = bill.get("curr");
        if (null != curr && curr instanceof DynamicObject) {
            DynamicObject currency2 = (DynamicObject)curr;
            pricePrecision = currency2.getInt("priceprecision");
        } else if (null != curr && curr instanceof Long && null != (currency = Cal4DynamicObj.getCurrency((Long)curr))) {
            pricePrecision = currency.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public static void calCost(DynamicObject bill, String entryKey) {
        bill.set("sumcost", (Object)"0");
        bill.set("totalamount", (Object)bill.getBigDecimal("sumtaxamount"));
    }

    public static DynamicObject getCurrency(Long currId) {
        DynamicObject currency = currMap.get(currId);
        if (null == currency) {
            HashMap<String, Object> idMap = new HashMap<String, Object>(1);
            idMap.put("id", currId);
            currency = ORMUtil.querySingleByPro("bd_currency", "id,priceprecision,amtprecision", idMap);
            currMap.put(currId, currency);
        }
        return currency;
    }

    public static void releaseData() {
        currMap.clear();
    }
}

